/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

class SynonymTokenizer
extends TokenStream {
    private TokenStream realStream;
    private Token currentRealToken = null;
    private Map synonyms;
    StringTokenizer st = null;

    public SynonymTokenizer(TokenStream realStream, Map synonyms) {
        this.realStream = realStream;
        this.synonyms = synonyms;
    }

    @Override
    public Token next() throws IOException {
        if (this.currentRealToken == null) {
            Token nextRealToken = this.realStream.next();
            if (nextRealToken == null) {
                return null;
            }
            String expansions = (String)this.synonyms.get(nextRealToken.termText());
            if (expansions == null) {
                return nextRealToken;
            }
            this.st = new StringTokenizer(expansions, ",");
            if (this.st.hasMoreTokens()) {
                this.currentRealToken = nextRealToken;
            }
            return this.currentRealToken;
        }
        String nextExpandedValue = this.st.nextToken();
        Token expandedToken = new Token(nextExpandedValue, this.currentRealToken.startOffset(), this.currentRealToken.endOffset());
        expandedToken.setPositionIncrement(0);
        if (!this.st.hasMoreTokens()) {
            this.currentRealToken = null;
            this.st = null;
        }
        return expandedToken;
    }
}

