/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.TokenGroup;

public class SimpleHTMLFormatter
implements Formatter {
    String preTag;
    String postTag;

    public SimpleHTMLFormatter(String preTag, String postTag) {
        this.preTag = preTag;
        this.postTag = postTag;
    }

    public SimpleHTMLFormatter() {
        this.preTag = "<B>";
        this.postTag = "</B>";
    }

    @Override
    public String highlightTerm(String originalText, TokenGroup tokenGroup) {
        if (tokenGroup.getTotalScore() > 0.0f) {
            StringBuffer returnBuffer = new StringBuffer();
            returnBuffer.append(this.preTag);
            returnBuffer.append(originalText);
            returnBuffer.append(this.postTag);
            return returnBuffer.toString();
        }
        return originalText;
    }
}

