/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeFilter;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SynonymAnalyzer;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenGroup;
import org.apache.lucene.search.highlight.WeightedTerm;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HighlighterTest
extends TestCase
implements Formatter {
    private IndexReader reader;
    private static final String FIELD_NAME = "contents";
    private Query query;
    RAMDirectory ramDir;
    public Searcher searcher = null;
    public Hits hits = null;
    int numHighlights = 0;
    Analyzer analyzer = new StandardAnalyzer();
    String[] texts = new String[]{"Hello this is a piece of text that is very long and contains too much preamble and the meat is really here which says kennedy has been shot", "This piece of text refers to Kennedy at the beginning then has a longer piece of text that is very long in the middle and finally ends with another reference to Kennedy", "JFK has been shot", "John Kennedy has been shot", "This text has a typo in referring to Keneddy"};

    public HighlighterTest(String arg0) {
        super(arg0);
    }

    public void testSimpleHighlighter() throws Exception {
        this.doSearching("Kennedy");
        Highlighter highlighter = new Highlighter(new QueryScorer(this.query));
        highlighter.setTextFragmenter(new SimpleFragmenter(40));
        int maxNumFragmentsRequired = 2;
        for (int i = 0; i < this.hits.length(); ++i) {
            String text = this.hits.doc(i).get(FIELD_NAME);
            TokenStream tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(text));
            String result = highlighter.getBestFragments(tokenStream, text, maxNumFragmentsRequired, "...");
            System.out.println("\t" + result);
        }
    }

    public void testGetBestFragmentsSimpleQuery() throws Exception {
        this.doSearching("Kennedy");
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 4 ? 1 : 0) != 0);
    }

    public void testGetFuzzyFragments() throws Exception {
        this.doSearching("Kinnedy~");
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 5 ? 1 : 0) != 0);
    }

    public void testGetWildCardFragments() throws Exception {
        this.doSearching("K?nnedy");
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 4 ? 1 : 0) != 0);
    }

    public void testGetMidWildCardFragments() throws Exception {
        this.doSearching("K*dy");
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 5 ? 1 : 0) != 0);
    }

    public void testGetRangeFragments() throws Exception {
        String queryString = "contents:[kannedy TO kznnedy]";
        QueryParser parser = new QueryParser(FIELD_NAME, new StandardAnalyzer());
        parser.setUseOldRangeQuery(true);
        this.query = parser.parse(queryString);
        this.doSearching(this.query);
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 5 ? 1 : 0) != 0);
    }

    public void testGetBestFragmentsPhrase() throws Exception {
        this.doSearching("\"John Kennedy\"");
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 2 ? 1 : 0) != 0);
    }

    public void testGetBestFragmentsSpan() throws Exception {
        SpanQuery[] clauses = new SpanQuery[]{new SpanTermQuery(new Term(FIELD_NAME, "john")), new SpanTermQuery(new Term(FIELD_NAME, "kennedy"))};
        SpanNearQuery snq = new SpanNearQuery(clauses, 1, true);
        this.doSearching(snq);
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 2 ? 1 : 0) != 0);
    }

    public void testOffByOne() throws IOException {
        TermQuery query = new TermQuery(new Term("data", "help"));
        Highlighter hg = new Highlighter(new SimpleHTMLFormatter(), new QueryScorer(query));
        hg.setTextFragmenter(new NullFragmenter());
        String match = null;
        match = hg.getBestFragment(new StandardAnalyzer(), "data", "help me [54-65]");
        HighlighterTest.assertEquals((String)"<B>help</B> me [54-65]", (String)match);
    }

    public void testGetBestFragmentsFilteredQuery() throws Exception {
        RangeFilter rf = new RangeFilter(FIELD_NAME, "john", "john", true, true);
        SpanQuery[] clauses = new SpanQuery[]{new SpanTermQuery(new Term(FIELD_NAME, "john")), new SpanTermQuery(new Term(FIELD_NAME, "kennedy"))};
        SpanNearQuery snq = new SpanNearQuery(clauses, 1, true);
        FilteredQuery fq = new FilteredQuery(snq, rf);
        this.doSearching(fq);
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 2 ? 1 : 0) != 0);
    }

    public void testGetBestFragmentsFilteredPhraseQuery() throws Exception {
        RangeFilter rf = new RangeFilter(FIELD_NAME, "john", "john", true, true);
        PhraseQuery pq = new PhraseQuery();
        pq.add(new Term(FIELD_NAME, "john"));
        pq.add(new Term(FIELD_NAME, "kennedy"));
        FilteredQuery fq = new FilteredQuery(pq, rf);
        this.doSearching(fq);
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 2 ? 1 : 0) != 0);
    }

    public void testGetBestFragmentsMultiTerm() throws Exception {
        this.doSearching("John Kenn*");
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 5 ? 1 : 0) != 0);
    }

    public void testGetBestFragmentsWithOr() throws Exception {
        this.doSearching("JFK OR Kennedy");
        this.doStandardHighlights();
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 5 ? 1 : 0) != 0);
    }

    public void testGetBestSingleFragment() throws Exception {
        String text;
        int i;
        this.doSearching("Kennedy");
        Highlighter highlighter = new Highlighter(this, new QueryScorer(this.query));
        highlighter.setTextFragmenter(new SimpleFragmenter(40));
        for (i = 0; i < this.hits.length(); ++i) {
            text = this.hits.doc(i).get(FIELD_NAME);
            TokenStream tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(text));
            String result = highlighter.getBestFragment(tokenStream, text);
            System.out.println("\t" + result);
        }
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 4 ? 1 : 0) != 0);
        this.numHighlights = 0;
        for (i = 0; i < this.hits.length(); ++i) {
            text = this.hits.doc(i).get(FIELD_NAME);
            highlighter.getBestFragment(this.analyzer, FIELD_NAME, text);
        }
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 4 ? 1 : 0) != 0);
        this.numHighlights = 0;
        for (i = 0; i < this.hits.length(); ++i) {
            text = this.hits.doc(i).get(FIELD_NAME);
            highlighter.getBestFragments(this.analyzer, FIELD_NAME, text, 10);
        }
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 4 ? 1 : 0) != 0);
    }

    public void testGetBestSingleFragmentWithWeights() throws Exception {
        WeightedTerm[] wTerms = new WeightedTerm[]{new WeightedTerm(10.0f, "hello"), new WeightedTerm(1.0f, "kennedy")};
        Highlighter highlighter = new Highlighter(new QueryScorer(wTerms));
        TokenStream tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(this.texts[0]));
        highlighter.setTextFragmenter(new SimpleFragmenter(2));
        String result = highlighter.getBestFragment(tokenStream, this.texts[0]).trim();
        HighlighterTest.assertTrue((String)("Failed to find best section using weighted terms. Found: [" + result + "]"), (boolean)"<B>Hello</B>".equals(result));
        wTerms[1].setWeight(50.0f);
        tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(this.texts[0]));
        highlighter = new Highlighter(new QueryScorer(wTerms));
        highlighter.setTextFragmenter(new SimpleFragmenter(2));
        result = highlighter.getBestFragment(tokenStream, this.texts[0]).trim();
        HighlighterTest.assertTrue((String)("Failed to find best section using weighted terms. Found: " + result), (boolean)"<B>kennedy</B>".equals(result));
    }

    public void testOverlapAnalyzer() throws Exception {
        HashMap<String, String> synonyms = new HashMap<String, String>();
        synonyms.put("football", "soccer,footie");
        SynonymAnalyzer analyzer = new SynonymAnalyzer(synonyms);
        String srchkey = "football";
        String s = "football-soccer in the euro 2004 footie competition";
        QueryParser parser = new QueryParser("bookid", analyzer);
        Query query = parser.parse(srchkey);
        Highlighter highlighter = new Highlighter(new QueryScorer(query));
        TokenStream tokenStream = ((Analyzer)analyzer).tokenStream(null, new StringReader(s));
        String result = highlighter.getBestFragments(tokenStream, s, 3, "...");
        String expectedResult = "<B>football</B>-<B>soccer</B> in the euro 2004 <B>footie</B> competition";
        HighlighterTest.assertTrue((String)"overlapping analyzer should handle highlights OK", (boolean)expectedResult.equals(result));
    }

    public void testGetSimpleHighlight() throws Exception {
        this.doSearching("Kennedy");
        Highlighter highlighter = new Highlighter(this, new QueryScorer(this.query));
        for (int i = 0; i < this.hits.length(); ++i) {
            String text = this.hits.doc(i).get(FIELD_NAME);
            TokenStream tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(text));
            String result = highlighter.getBestFragment(tokenStream, text);
            System.out.println("\t" + result);
        }
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 4 ? 1 : 0) != 0);
    }

    public void testGetTextFragments() throws Exception {
        this.doSearching("Kennedy");
        Highlighter highlighter = new Highlighter(this, new QueryScorer(this.query));
        highlighter.setTextFragmenter(new SimpleFragmenter(20));
        for (int i = 0; i < this.hits.length(); ++i) {
            String text = this.hits.doc(i).get(FIELD_NAME);
            TokenStream tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(text));
            String[] stringResults = highlighter.getBestFragments(tokenStream, text, 10);
            tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(text));
            TextFragment[] fragmentResults = highlighter.getBestTextFragments(tokenStream, text, true, 10);
            HighlighterTest.assertTrue((String)("Failed to find correct number of text Fragments: " + fragmentResults.length + " vs " + stringResults.length), (fragmentResults.length == stringResults.length ? 1 : 0) != 0);
            for (int j = 0; j < stringResults.length; ++j) {
                System.out.println(fragmentResults[j]);
                HighlighterTest.assertTrue((String)("Failed to find same text Fragments: " + fragmentResults[j] + " found"), (boolean)fragmentResults[j].toString().equals(stringResults[j]));
            }
        }
    }

    public void testMaxSizeHighlight() throws Exception {
        this.doSearching("meat");
        Highlighter highlighter = new Highlighter(this, new QueryScorer(this.query));
        highlighter.setMaxDocBytesToAnalyze(30);
        TokenStream tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(this.texts[0]));
        highlighter.getBestFragment(tokenStream, this.texts[0]);
        HighlighterTest.assertTrue((String)("Setting MaxDocBytesToAnalyze should have prevented us from finding matches for this record: " + this.numHighlights + " found"), (this.numHighlights == 0 ? 1 : 0) != 0);
    }

    public void testMaxSizeHighlightTruncates() throws IOException {
        String goodWord = "goodtoken";
        String[] stopWords = new String[]{"stoppedtoken"};
        TermQuery query = new TermQuery(new Term("data", goodWord));
        SimpleHTMLFormatter fm = new SimpleHTMLFormatter();
        Highlighter hg = new Highlighter(fm, new QueryScorer(query));
        hg.setTextFragmenter(new NullFragmenter());
        String match = null;
        StringBuffer sb = new StringBuffer();
        sb.append(goodWord);
        for (int i = 0; i < 10000; ++i) {
            sb.append(" ");
            sb.append(stopWords[0]);
        }
        hg.setMaxDocBytesToAnalyze(100);
        match = hg.getBestFragment(new StandardAnalyzer(stopWords), "data", sb.toString());
        HighlighterTest.assertTrue((String)"Matched text should be no more than 100 chars in length ", (match.length() < hg.getMaxDocBytesToAnalyze() ? 1 : 0) != 0);
        sb.append(" ");
        sb.append(goodWord);
        match = hg.getBestFragment(new StandardAnalyzer(stopWords), "data", sb.toString());
        HighlighterTest.assertTrue((String)"Matched text should be no more than 100 chars in length ", (match.length() < hg.getMaxDocBytesToAnalyze() ? 1 : 0) != 0);
    }

    public void testUnRewrittenQuery() throws IOException, ParseException {
        this.searcher = new IndexSearcher(this.ramDir);
        StandardAnalyzer analyzer = new StandardAnalyzer();
        QueryParser parser = new QueryParser(FIELD_NAME, analyzer);
        Query query = parser.parse("JF? or Kenned*");
        System.out.println("Searching with primitive query");
        Hits hits = this.searcher.search(query);
        Highlighter highlighter = new Highlighter(this, new QueryScorer(query));
        highlighter.setTextFragmenter(new SimpleFragmenter(40));
        int maxNumFragmentsRequired = 3;
        for (int i = 0; i < hits.length(); ++i) {
            String text = hits.doc(i).get(FIELD_NAME);
            TokenStream tokenStream = ((Analyzer)analyzer).tokenStream(FIELD_NAME, new StringReader(text));
            String highlightedText = highlighter.getBestFragments(tokenStream, text, maxNumFragmentsRequired, "...");
            System.out.println(highlightedText);
        }
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 0 ? 1 : 0) != 0);
    }

    public void testNoFragments() throws Exception {
        this.doSearching("AnInvalidQueryWhichShouldYieldNoResults");
        Highlighter highlighter = new Highlighter(this, new QueryScorer(this.query));
        for (int i = 0; i < this.texts.length; ++i) {
            String text = this.texts[i];
            TokenStream tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(text));
            String result = highlighter.getBestFragment(tokenStream, text);
            HighlighterTest.assertNull((String)"The highlight result should be null for text with no query terms", (Object)result);
        }
    }

    public void testEncoding() throws Exception {
        String rawDocContent = "\"Smith & sons' prices < 3 and >4\" claims article";
        Highlighter highlighter = new Highlighter(this, new SimpleHTMLEncoder(), new Scorer(){

            @Override
            public void startFragment(TextFragment newFragment) {
            }

            @Override
            public float getTokenScore(Token token) {
                return 0.0f;
            }

            @Override
            public float getFragmentScore() {
                return 1.0f;
            }
        });
        highlighter.setTextFragmenter(new SimpleFragmenter(2000));
        TokenStream tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(rawDocContent));
        String encodedSnippet = highlighter.getBestFragments(tokenStream, rawDocContent, 1, "");
        String xhtml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE html\nPUBLIC \"//W3C//DTD XHTML 1.0 Transitional//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n<head>\n<title>My Test HTML Document</title>\n</head>\n<body>\n<h2>" + encodedSnippet + "</h2>\n</body>\n</html>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new ByteArrayInputStream(xhtml.getBytes()));
        Element root = doc.getDocumentElement();
        NodeList nodes = root.getElementsByTagName("body");
        Element body = (Element)nodes.item(0);
        nodes = body.getElementsByTagName("h2");
        Element h2 = (Element)nodes.item(0);
        String decodedSnippet = h2.getFirstChild().getNodeValue();
        HighlighterTest.assertEquals((String)"XHTML Encoding should have worked:", (String)rawDocContent, (String)decodedSnippet);
    }

    public void testMultiSearcher() throws Exception {
        RAMDirectory ramDir1 = new RAMDirectory();
        IndexWriter writer1 = new IndexWriter((Directory)ramDir1, (Analyzer)new StandardAnalyzer(), true);
        org.apache.lucene.document.Document d = new org.apache.lucene.document.Document();
        Field f = new Field(FIELD_NAME, "multiOne", Field.Store.YES, Field.Index.TOKENIZED);
        d.add(f);
        writer1.addDocument(d);
        writer1.optimize();
        writer1.close();
        IndexReader reader1 = IndexReader.open(ramDir1);
        RAMDirectory ramDir2 = new RAMDirectory();
        IndexWriter writer2 = new IndexWriter((Directory)ramDir2, (Analyzer)new StandardAnalyzer(), true);
        d = new org.apache.lucene.document.Document();
        f = new Field(FIELD_NAME, "multiTwo", Field.Store.YES, Field.Index.TOKENIZED);
        d.add(f);
        writer2.addDocument(d);
        writer2.optimize();
        writer2.close();
        IndexReader reader2 = IndexReader.open(ramDir2);
        Searchable[] searchers = new IndexSearcher[]{new IndexSearcher(ramDir1), new IndexSearcher(ramDir2)};
        MultiSearcher multiSearcher = new MultiSearcher(searchers);
        QueryParser parser = new QueryParser(FIELD_NAME, new StandardAnalyzer());
        this.query = parser.parse("multi*");
        System.out.println("Searching for: " + this.query.toString(FIELD_NAME));
        this.hits = multiSearcher.search(this.query);
        Query[] expandedQueries = new Query[]{this.query.rewrite(reader1), this.query.rewrite(reader2)};
        this.query = this.query.combine(expandedQueries);
        Highlighter highlighter = new Highlighter(this, new QueryScorer(this.query));
        for (int i = 0; i < this.hits.length(); ++i) {
            String text = this.hits.doc(i).get(FIELD_NAME);
            TokenStream tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(text));
            String highlightedText = highlighter.getBestFragment(tokenStream, text);
            System.out.println(highlightedText);
        }
        HighlighterTest.assertTrue((String)("Failed to find correct number of highlights " + this.numHighlights + " found"), (this.numHighlights == 2 ? 1 : 0) != 0);
    }

    public void testFieldSpecificHighlighting() throws IOException, ParseException {
        String docMainText = "fred is one of the people";
        QueryParser parser = new QueryParser(FIELD_NAME, this.analyzer);
        Query query = parser.parse("fred category:people");
        QueryScorer fieldSpecificScorer = new QueryScorer(query, FIELD_NAME);
        Highlighter fieldSpecificHighlighter = new Highlighter(new SimpleHTMLFormatter(), fieldSpecificScorer);
        fieldSpecificHighlighter.setTextFragmenter(new NullFragmenter());
        String result = fieldSpecificHighlighter.getBestFragment(this.analyzer, FIELD_NAME, docMainText);
        HighlighterTest.assertEquals((String)"Should match", (String)result, (String)"<B>fred</B> is one of the people");
        QueryScorer fieldInSpecificScorer = new QueryScorer(query);
        Highlighter fieldInSpecificHighlighter = new Highlighter(new SimpleHTMLFormatter(), fieldInSpecificScorer);
        fieldInSpecificHighlighter.setTextFragmenter(new NullFragmenter());
        result = fieldInSpecificHighlighter.getBestFragment(this.analyzer, FIELD_NAME, docMainText);
        HighlighterTest.assertEquals((String)"Should match", (String)result, (String)"<B>fred</B> is one of the <B>people</B>");
        this.reader.close();
    }

    protected TokenStream getTS2() {
        return new TokenStream(){
            Iterator iter;
            List lst = new ArrayList();
            {
                Token t = new Token("hi", 0, 2);
                this.lst.add(t);
                t = new Token("hispeed", 0, 8);
                this.lst.add(t);
                t = new Token("speed", 3, 8);
                t.setPositionIncrement(0);
                this.lst.add(t);
                t = new Token("10", 8, 10);
                this.lst.add(t);
                t = new Token("foo", 11, 14);
                this.lst.add(t);
                this.iter = this.lst.iterator();
            }

            @Override
            public Token next() throws IOException {
                return this.iter.hasNext() ? (Token)this.iter.next() : null;
            }
        };
    }

    protected TokenStream getTS2a() {
        return new TokenStream(){
            Iterator iter;
            List lst = new ArrayList();
            {
                Token t = new Token("hispeed", 0, 8);
                this.lst.add(t);
                t = new Token("hi", 0, 2);
                t.setPositionIncrement(0);
                this.lst.add(t);
                t = new Token("speed", 3, 8);
                this.lst.add(t);
                t = new Token("10", 8, 10);
                this.lst.add(t);
                t = new Token("foo", 11, 14);
                this.lst.add(t);
                this.iter = this.lst.iterator();
            }

            @Override
            public Token next() throws IOException {
                return this.iter.hasNext() ? (Token)this.iter.next() : null;
            }
        };
    }

    public void testOverlapAnalyzer2() throws Exception {
        String s = "Hi-Speed10 foo";
        Query query = new QueryParser("text", new WhitespaceAnalyzer()).parse("foo");
        Highlighter highlighter = new Highlighter(new QueryScorer(query));
        String result = highlighter.getBestFragments(this.getTS2(), s, 3, "...");
        HighlighterTest.assertEquals((String)"Hi-Speed10 <B>foo</B>", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("10");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2(), s, 3, "...");
        HighlighterTest.assertEquals((String)"Hi-Speed<B>10</B> foo", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("hi");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2(), s, 3, "...");
        HighlighterTest.assertEquals((String)"<B>Hi</B>-Speed10 foo", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("speed");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2(), s, 3, "...");
        HighlighterTest.assertEquals((String)"Hi-<B>Speed</B>10 foo", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("hispeed");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2(), s, 3, "...");
        HighlighterTest.assertEquals((String)"<B>Hi-Speed</B>10 foo", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("hi speed");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2(), s, 3, "...");
        HighlighterTest.assertEquals((String)"<B>Hi-Speed</B>10 foo", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("foo");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2a(), s, 3, "...");
        HighlighterTest.assertEquals((String)"Hi-Speed10 <B>foo</B>", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("10");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2a(), s, 3, "...");
        HighlighterTest.assertEquals((String)"Hi-Speed<B>10</B> foo", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("hi");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2a(), s, 3, "...");
        HighlighterTest.assertEquals((String)"<B>Hi</B>-Speed10 foo", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("speed");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2a(), s, 3, "...");
        HighlighterTest.assertEquals((String)"Hi-<B>Speed</B>10 foo", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("hispeed");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2a(), s, 3, "...");
        HighlighterTest.assertEquals((String)"<B>Hi-Speed</B>10 foo", (String)result);
        query = new QueryParser("text", new WhitespaceAnalyzer()).parse("hi speed");
        highlighter = new Highlighter(new QueryScorer(query));
        result = highlighter.getBestFragments(this.getTS2a(), s, 3, "...");
        HighlighterTest.assertEquals((String)"<B>Hi-Speed</B>10 foo", (String)result);
    }

    @Override
    public String highlightTerm(String originalText, TokenGroup group) {
        if (group.getTotalScore() <= 0.0f) {
            return originalText;
        }
        ++this.numHighlights;
        return "<b>" + originalText + "</b>";
    }

    public void doSearching(String queryString) throws Exception {
        QueryParser parser = new QueryParser(FIELD_NAME, new StandardAnalyzer());
        this.query = parser.parse(queryString);
        this.doSearching(this.query);
    }

    public void doSearching(Query unReWrittenQuery) throws Exception {
        this.searcher = new IndexSearcher(this.ramDir);
        this.query = unReWrittenQuery.rewrite(this.reader);
        System.out.println("Searching for: " + this.query.toString(FIELD_NAME));
        this.hits = this.searcher.search(this.query);
    }

    void doStandardHighlights() throws Exception {
        Highlighter highlighter = new Highlighter(this, new QueryScorer(this.query));
        highlighter.setTextFragmenter(new SimpleFragmenter(20));
        for (int i = 0; i < this.hits.length(); ++i) {
            String text = this.hits.doc(i).get(FIELD_NAME);
            int maxNumFragmentsRequired = 2;
            String fragmentSeparator = "...";
            TokenStream tokenStream = this.analyzer.tokenStream(FIELD_NAME, new StringReader(text));
            String result = highlighter.getBestFragments(tokenStream, text, maxNumFragmentsRequired, fragmentSeparator);
            System.out.println("\t" + result);
        }
    }

    protected void setUp() throws Exception {
        this.ramDir = new RAMDirectory();
        IndexWriter writer = new IndexWriter((Directory)this.ramDir, (Analyzer)new StandardAnalyzer(), true);
        for (int i = 0; i < this.texts.length; ++i) {
            this.addDoc(writer, this.texts[i]);
        }
        writer.optimize();
        writer.close();
        this.reader = IndexReader.open(this.ramDir);
        this.numHighlights = 0;
    }

    private void addDoc(IndexWriter writer, String text) throws IOException {
        org.apache.lucene.document.Document d = new org.apache.lucene.document.Document();
        Field f = new Field(FIELD_NAME, text, Field.Store.YES, Field.Index.TOKENIZED);
        d.add(f);
        writer.addDocument(d);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }
}

