/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class SingleFieldTestDb {
    private Directory db;
    private String[] docs;
    private String fieldName;

    public SingleFieldTestDb(String[] documents, String fName) {
        try {
            this.db = new RAMDirectory();
            this.docs = documents;
            this.fieldName = fName;
            WhitespaceAnalyzer analyzer = new WhitespaceAnalyzer();
            IndexWriter writer = new IndexWriter(this.db, (Analyzer)analyzer, true);
            for (int j = 0; j < this.docs.length; ++j) {
                Document d = new Document();
                d.add(new Field(this.fieldName, this.docs[j], Field.Store.NO, Field.Index.TOKENIZED));
                writer.addDocument(d);
            }
            writer.close();
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }

    Directory getDb() {
        return this.db;
    }

    String[] getDocs() {
        return this.docs;
    }

    String getFieldname() {
        return this.fieldName;
    }
}

