/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryParser.surround.query.DistanceSubQuery;
import org.apache.lucene.queryParser.surround.query.SpanNearClauseFactory;
import org.apache.lucene.queryParser.surround.query.SrndBooleanQuery;
import org.apache.lucene.queryParser.surround.query.SrndQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

public abstract class SimpleTerm
extends SrndQuery
implements DistanceSubQuery,
Comparable {
    private boolean quoted;

    public SimpleTerm(boolean q) {
        this.quoted = q;
    }

    boolean isQuoted() {
        return this.quoted;
    }

    public String getQuote() {
        return "\"";
    }

    public String getFieldOperator() {
        return "/";
    }

    public abstract String toStringUnquoted();

    public int compareTo(Object o) {
        SimpleTerm ost = (SimpleTerm)o;
        return this.toStringUnquoted().compareTo(ost.toStringUnquoted());
    }

    protected void suffixToString(StringBuffer r) {
    }

    @Override
    public String toString() {
        StringBuffer r = new StringBuffer();
        if (this.isQuoted()) {
            r.append(this.getQuote());
        }
        r.append(this.toStringUnquoted());
        if (this.isQuoted()) {
            r.append(this.getQuote());
        }
        this.suffixToString(r);
        this.weightToString(r);
        return r.toString();
    }

    public abstract void visitMatchingTerms(IndexReader var1, String var2, MatchingTermVisitor var3) throws IOException;

    @Override
    public String distanceSubQueryNotAllowed() {
        return null;
    }

    @Override
    public Query makeLuceneQueryFieldNoBoost(final String fieldName, final BasicQueryFactory qf) {
        return new Query(){

            @Override
            public String toString(String fn) {
                return this.getClass().toString() + " " + fieldName + " (" + fn + "?)";
            }

            @Override
            public Query rewrite(IndexReader reader) throws IOException {
                final ArrayList luceneSubQueries = new ArrayList();
                SimpleTerm.this.visitMatchingTerms(reader, fieldName, new MatchingTermVisitor(){

                    @Override
                    public void visitMatchingTerm(Term term) throws IOException {
                        luceneSubQueries.add(qf.newTermQuery(term));
                    }
                });
                return luceneSubQueries.size() == 0 ? SrndQuery.theEmptyLcnQuery : (luceneSubQueries.size() == 1 ? (Query)luceneSubQueries.get(0) : SrndBooleanQuery.makeBooleanQuery(luceneSubQueries, BooleanClause.Occur.SHOULD));
            }
        };
    }

    @Override
    public void addSpanQueries(final SpanNearClauseFactory sncf) throws IOException {
        this.visitMatchingTerms(sncf.getIndexReader(), sncf.getFieldName(), new MatchingTermVisitor(){

            @Override
            public void visitMatchingTerm(Term term) throws IOException {
                sncf.addTermWeighted(term, SimpleTerm.this.getWeight());
            }
        });
    }

    public static interface MatchingTermVisitor {
        public void visitMatchingTerm(Term var1) throws IOException;
    }
}

