/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryParser.surround.query.ComposedQuery;
import org.apache.lucene.queryParser.surround.query.DistanceSubQuery;
import org.apache.lucene.queryParser.surround.query.SpanNearClauseFactory;
import org.apache.lucene.queryParser.surround.query.SrndQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;

public class DistanceQuery
extends ComposedQuery
implements DistanceSubQuery {
    private int opDistance;
    private boolean ordered;

    public DistanceQuery(List queries, boolean infix, int opDistance, String opName, boolean ordered) {
        super(queries, infix, opName);
        this.opDistance = opDistance;
        this.ordered = ordered;
    }

    public int getOpDistance() {
        return this.opDistance;
    }

    public boolean subQueriesOrdered() {
        return this.ordered;
    }

    @Override
    public String distanceSubQueryNotAllowed() {
        Iterator sqi = this.getSubQueriesIterator();
        while (sqi.hasNext()) {
            Object leq = sqi.next();
            if (leq instanceof DistanceSubQuery) {
                DistanceSubQuery dsq = (DistanceSubQuery)leq;
                String m = dsq.distanceSubQueryNotAllowed();
                if (m == null) continue;
                return m;
            }
            return "Operator " + this.getOperatorName() + " does not allow subquery " + leq.toString();
        }
        return null;
    }

    @Override
    public void addSpanQueries(SpanNearClauseFactory sncf) throws IOException {
        Query snq = this.getSpanNearQuery(sncf.getIndexReader(), sncf.getFieldName(), this.getWeight(), sncf.getBasicQueryFactory());
        sncf.addSpanNearQuery(snq);
    }

    @Override
    public Query makeLuceneQueryFieldNoBoost(final String fieldName, final BasicQueryFactory qf) {
        return new Query(){

            @Override
            public String toString(String fn) {
                return this.getClass().toString() + " " + fieldName + " (" + fn + "?)";
            }

            @Override
            public Query rewrite(IndexReader reader) throws IOException {
                return DistanceQuery.this.getSpanNearQuery(reader, fieldName, this.getBoost(), qf);
            }
        };
    }

    public Query getSpanNearQuery(IndexReader reader, String fieldName, float boost, BasicQueryFactory qf) throws IOException {
        SpanQuery[] spanNearClauses = new SpanQuery[this.getNrSubQueries()];
        Iterator sqi = this.getSubQueriesIterator();
        int qi = 0;
        while (sqi.hasNext()) {
            SpanNearClauseFactory sncf = new SpanNearClauseFactory(reader, fieldName, qf);
            ((DistanceSubQuery)sqi.next()).addSpanQueries(sncf);
            if (sncf.size() == 0) {
                while (sqi.hasNext()) {
                    ((DistanceSubQuery)sqi.next()).addSpanQueries(sncf);
                    sncf.clear();
                }
                return SrndQuery.theEmptyLcnQuery;
            }
            spanNearClauses[qi] = sncf.makeSpanNearClause();
            ++qi;
        }
        SpanNearQuery r = new SpanNearQuery(spanNearClauses, this.getOpDistance() - 1, this.subQueriesOrdered());
        r.setBoost(boost);
        return r;
    }
}

