/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.surround.query;

import junit.framework.TestCase;
import org.apache.lucene.queryParser.surround.parser.QueryParser;
import org.apache.lucene.queryParser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryParser.surround.query.SingleFieldTestDb;
import org.apache.lucene.queryParser.surround.query.SrndQuery;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class BooleanQueryTst {
    String queryText;
    final int[] expectedDocNrs;
    SingleFieldTestDb dBase;
    String fieldName;
    TestCase testCase;
    BasicQueryFactory qf;
    boolean verbose = true;

    public BooleanQueryTst(String queryText, int[] expectedDocNrs, SingleFieldTestDb dBase, String fieldName, TestCase testCase, BasicQueryFactory qf) {
        this.queryText = queryText;
        this.expectedDocNrs = expectedDocNrs;
        this.dBase = dBase;
        this.fieldName = fieldName;
        this.testCase = testCase;
        this.qf = qf;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest() throws Exception {
        if (this.verbose) {
            System.out.println("");
            System.out.println("Query: " + this.queryText);
        }
        SrndQuery lq = QueryParser.parse(this.queryText);
        Query query = lq.makeLuceneQueryField(this.fieldName, this.qf);
        TestCollector tc = new TestCollector();
        try (IndexSearcher searcher = new IndexSearcher(this.dBase.getDb());){
            searcher.search(query, tc);
        }
        tc.checkNrHits();
    }

    class TestCollector
    extends HitCollector {
        int totalMatched = 0;
        boolean[] encountered;

        TestCollector() {
            this.encountered = new boolean[BooleanQueryTst.this.expectedDocNrs.length];
        }

        @Override
        public void collect(int docNr, float score) {
            int i;
            TestCase.assertTrue((String)(BooleanQueryTst.this.queryText + ": positive score"), ((double)score > 0.0 ? 1 : 0) != 0);
            TestCase.assertTrue((String)(BooleanQueryTst.this.queryText + ": too many hits"), (this.totalMatched < BooleanQueryTst.this.expectedDocNrs.length ? 1 : 0) != 0);
            for (i = 0; i < BooleanQueryTst.this.expectedDocNrs.length; ++i) {
                if (this.encountered[i] || BooleanQueryTst.this.expectedDocNrs[i] != docNr) continue;
                this.encountered[i] = true;
                break;
            }
            if (i == BooleanQueryTst.this.expectedDocNrs.length) {
                TestCase.assertTrue((String)(BooleanQueryTst.this.queryText + ": doc nr for hit not expected: " + docNr), (boolean)false);
            }
            ++this.totalMatched;
        }

        void checkNrHits() {
            TestCase.assertEquals((String)(BooleanQueryTst.this.queryText + ": nr of hits"), (int)BooleanQueryTst.this.expectedDocNrs.length, (int)this.totalMatched);
        }
    }
}

