/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.precedence;

import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.util.Calendar;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseTokenizer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.queryParser.precedence.ParseException;
import org.apache.lucene.queryParser.precedence.PrecedenceQueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class TestPrecedenceQueryParser
extends TestCase {
    public static Analyzer qpAnalyzer = new QPTestAnalyzer();
    private int originalMaxClauses;

    public void setUp() {
        this.originalMaxClauses = BooleanQuery.getMaxClauseCount();
    }

    public PrecedenceQueryParser getParser(Analyzer a) throws Exception {
        if (a == null) {
            a = new SimpleAnalyzer();
        }
        PrecedenceQueryParser qp = new PrecedenceQueryParser("field", a);
        qp.setDefaultOperator(PrecedenceQueryParser.OR_OPERATOR);
        return qp;
    }

    public Query getQuery(String query, Analyzer a) throws Exception {
        return this.getParser(a).parse(query);
    }

    public void assertQueryEquals(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQuery(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestPrecedenceQueryParser.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertWildcardQueryEquals(String query, boolean lowercase, String result) throws Exception {
        PrecedenceQueryParser qp = this.getParser(null);
        qp.setLowercaseExpandedTerms(lowercase);
        Query q = qp.parse(query);
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestPrecedenceQueryParser.fail((String)("WildcardQuery /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertWildcardQueryEquals(String query, String result) throws Exception {
        PrecedenceQueryParser qp = this.getParser(null);
        Query q = qp.parse(query);
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestPrecedenceQueryParser.fail((String)("WildcardQuery /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public Query getQueryDOA(String query, Analyzer a) throws Exception {
        if (a == null) {
            a = new SimpleAnalyzer();
        }
        PrecedenceQueryParser qp = new PrecedenceQueryParser("field", a);
        qp.setDefaultOperator(PrecedenceQueryParser.AND_OPERATOR);
        return qp.parse(query);
    }

    public void assertQueryEqualsDOA(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQueryDOA(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestPrecedenceQueryParser.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void _testSimple() throws Exception {
        this.assertQueryEquals("", null, "");
        this.assertQueryEquals("term term term", null, "term term term");
        this.assertQueryEquals("t\u00fcrm term term", null, "t\u00fcrm term term");
        this.assertQueryEquals("\u00fcmlaut", null, "\u00fcmlaut");
        this.assertQueryEquals("+a", null, "+a");
        this.assertQueryEquals("-a", null, "-a");
        this.assertQueryEquals("a AND b", null, "+a +b");
        this.assertQueryEquals("(a AND b)", null, "+a +b");
        this.assertQueryEquals("c OR (a AND b)", null, "c (+a +b)");
        this.assertQueryEquals("a AND NOT b", null, "+a -b");
        this.assertQueryEquals("a AND -b", null, "+a -b");
        this.assertQueryEquals("a AND !b", null, "+a -b");
        this.assertQueryEquals("a && b", null, "+a +b");
        this.assertQueryEquals("a && ! b", null, "+a -b");
        this.assertQueryEquals("a OR b", null, "a b");
        this.assertQueryEquals("a || b", null, "a b");
        this.assertQueryEquals("+term -term term", null, "+term -term term");
        this.assertQueryEquals("foo:term AND field:anotherTerm", null, "+foo:term +anotherterm");
        this.assertQueryEquals("term AND \"phrase phrase\"", null, "+term +\"phrase phrase\"");
        this.assertQueryEquals("\"hello there\"", null, "\"hello there\"");
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("a AND b", null) instanceof BooleanQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("hello", null) instanceof TermQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("\"hello there\"", null) instanceof PhraseQuery));
        this.assertQueryEquals("germ term^2.0", null, "germ term^2.0");
        this.assertQueryEquals("(term)^2.0", null, "term^2.0");
        this.assertQueryEquals("(germ term)^2.0", null, "(germ term)^2.0");
        this.assertQueryEquals("term^2.0", null, "term^2.0");
        this.assertQueryEquals("term^2", null, "term^2.0");
        this.assertQueryEquals("\"germ term\"^2.0", null, "\"germ term\"^2.0");
        this.assertQueryEquals("\"term germ\"^2", null, "\"term germ\"^2.0");
        this.assertQueryEquals("(foo OR bar) AND (baz OR boo)", null, "+(foo bar) +(baz boo)");
        this.assertQueryEquals("((a OR b) AND NOT c) OR d", null, "(+(a b) -c) d");
        this.assertQueryEquals("+(apple \"steve jobs\") -(foo bar baz)", null, "+(apple \"steve jobs\") -(foo bar baz)");
        this.assertQueryEquals("+title:(dog OR cat) -author:\"bob dole\"", null, "+(title:dog title:cat) -author:\"bob dole\"");
        PrecedenceQueryParser qp = new PrecedenceQueryParser("field", new StandardAnalyzer());
        TestPrecedenceQueryParser.assertEquals((Object)PrecedenceQueryParser.OR_OPERATOR, (Object)qp.getDefaultOperator());
        qp.setDefaultOperator(PrecedenceQueryParser.AND_OPERATOR);
        TestPrecedenceQueryParser.assertEquals((Object)PrecedenceQueryParser.AND_OPERATOR, (Object)qp.getDefaultOperator());
        qp.setDefaultOperator(PrecedenceQueryParser.OR_OPERATOR);
        TestPrecedenceQueryParser.assertEquals((Object)PrecedenceQueryParser.OR_OPERATOR, (Object)qp.getDefaultOperator());
        this.assertQueryEquals("a OR !b", null, "a (-b)");
        this.assertQueryEquals("a OR ! b", null, "a (-b)");
        this.assertQueryEquals("a OR -b", null, "a (-b)");
    }

    public void testPunct() throws Exception {
        WhitespaceAnalyzer a = new WhitespaceAnalyzer();
        this.assertQueryEquals("a&b", a, "a&b");
        this.assertQueryEquals("a&&b", a, "a&&b");
        this.assertQueryEquals(".NET", a, ".NET");
    }

    public void testSlop() throws Exception {
        this.assertQueryEquals("\"term germ\"~2", null, "\"term germ\"~2");
        this.assertQueryEquals("\"term germ\"~2 flork", null, "\"term germ\"~2 flork");
        this.assertQueryEquals("\"term\"~2", null, "term");
        this.assertQueryEquals("\" \"~2 germ", null, "germ");
        this.assertQueryEquals("\"term germ\"~2^2", null, "\"term germ\"~2^2.0");
    }

    public void testNumber() throws Exception {
        this.assertQueryEquals("3", null, "");
        this.assertQueryEquals("term 1.0 1 2", null, "term");
        this.assertQueryEquals("term term1 term2", null, "term term term");
        StandardAnalyzer a = new StandardAnalyzer();
        this.assertQueryEquals("3", a, "3");
        this.assertQueryEquals("term 1.0 1 2", a, "term 1.0 1 2");
        this.assertQueryEquals("term term1 term2", a, "term term1 term2");
    }

    public void _testWildcard() throws Exception {
        this.assertQueryEquals("term*", null, "term*");
        this.assertQueryEquals("term*^2", null, "term*^2.0");
        this.assertQueryEquals("term~", null, "term~0.5");
        this.assertQueryEquals("term~0.7", null, "term~0.7");
        this.assertQueryEquals("term~^2", null, "term^2.0~0.5");
        this.assertQueryEquals("term^2~", null, "term^2.0~0.5");
        this.assertQueryEquals("term*germ", null, "term*germ");
        this.assertQueryEquals("term*germ^3", null, "term*germ^3.0");
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term*", null) instanceof PrefixQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term*^2", null) instanceof PrefixQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term~", null) instanceof FuzzyQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term~0.7", null) instanceof FuzzyQuery));
        FuzzyQuery fq = (FuzzyQuery)this.getQuery("term~0.7", null);
        TestPrecedenceQueryParser.assertEquals((float)0.7f, (float)fq.getMinSimilarity(), (float)0.1f);
        TestPrecedenceQueryParser.assertEquals((int)0, (int)fq.getPrefixLength());
        fq = (FuzzyQuery)this.getQuery("term~", null);
        TestPrecedenceQueryParser.assertEquals((float)0.5f, (float)fq.getMinSimilarity(), (float)0.1f);
        TestPrecedenceQueryParser.assertEquals((int)0, (int)fq.getPrefixLength());
        try {
            this.getQuery("term~1.1", null);
            TestPrecedenceQueryParser.fail();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term*germ", null) instanceof WildcardQuery));
        this.assertWildcardQueryEquals("Term*", true, "term*");
        this.assertWildcardQueryEquals("term*", true, "term*");
        this.assertWildcardQueryEquals("Term*", true, "term*");
        this.assertWildcardQueryEquals("TERM*", true, "term*");
        this.assertWildcardQueryEquals("term*", false, "term*");
        this.assertWildcardQueryEquals("Term*", false, "Term*");
        this.assertWildcardQueryEquals("TERM*", false, "TERM*");
        this.assertWildcardQueryEquals("Te?m", "te?m");
        this.assertWildcardQueryEquals("te?m", true, "te?m");
        this.assertWildcardQueryEquals("Te?m", true, "te?m");
        this.assertWildcardQueryEquals("TE?M", true, "te?m");
        this.assertWildcardQueryEquals("Te?m*gerM", true, "te?m*germ");
        this.assertWildcardQueryEquals("te?m", false, "te?m");
        this.assertWildcardQueryEquals("Te?m", false, "Te?m");
        this.assertWildcardQueryEquals("TE?M", false, "TE?M");
        this.assertWildcardQueryEquals("Te?m*gerM", false, "Te?m*gerM");
        this.assertWildcardQueryEquals("Term~", "term~0.5");
        this.assertWildcardQueryEquals("Term~", true, "term~0.5");
        this.assertWildcardQueryEquals("Term~", false, "Term~0.5");
        this.assertWildcardQueryEquals("[A TO C]", "[a TO c]");
        this.assertWildcardQueryEquals("[A TO C]", true, "[a TO c]");
        this.assertWildcardQueryEquals("[A TO C]", false, "[A TO C]");
    }

    public void testQPA() throws Exception {
        this.assertQueryEquals("term term term", qpAnalyzer, "term term term");
        this.assertQueryEquals("term +stop term", qpAnalyzer, "term term");
        this.assertQueryEquals("term -stop term", qpAnalyzer, "term term");
        this.assertQueryEquals("drop AND stop AND roll", qpAnalyzer, "+drop +roll");
        this.assertQueryEquals("term phrase term", qpAnalyzer, "term \"phrase1 phrase2\" term");
        this.assertQueryEquals("term AND NOT phrase term", qpAnalyzer, "(+term -\"phrase1 phrase2\") term");
        this.assertQueryEquals("stop", qpAnalyzer, "");
        this.assertQueryEquals("stop OR stop AND stop", qpAnalyzer, "");
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term term term", qpAnalyzer) instanceof BooleanQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term +stop", qpAnalyzer) instanceof TermQuery));
    }

    public void testRange() throws Exception {
        this.assertQueryEquals("[ a TO z]", null, "[a TO z]");
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("[ a TO z]", null) instanceof RangeQuery));
        this.assertQueryEquals("[ a TO z ]", null, "[a TO z]");
        this.assertQueryEquals("{ a TO z}", null, "{a TO z}");
        this.assertQueryEquals("{ a TO z }", null, "{a TO z}");
        this.assertQueryEquals("{ a TO z }^2.0", null, "{a TO z}^2.0");
        this.assertQueryEquals("[ a TO z] OR bar", null, "[a TO z] bar");
        this.assertQueryEquals("[ a TO z] AND bar", null, "+[a TO z] +bar");
        this.assertQueryEquals("( bar blar { a TO z}) ", null, "bar blar {a TO z}");
        this.assertQueryEquals("gack ( bar blar { a TO z}) ", null, "gack (bar blar {a TO z})");
    }

    public String getDate(String s) throws Exception {
        DateFormat df = DateFormat.getDateInstance(3);
        return DateTools.dateToString(df.parse(s), DateTools.Resolution.DAY);
    }

    public String getLocalizedDate(int year, int month, int day) {
        DateFormat df = DateFormat.getDateInstance(3);
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        return df.format(calendar.getTime());
    }

    public void testDateRange() throws Exception {
        String startDate = this.getLocalizedDate(2002, 1, 1);
        String endDate = this.getLocalizedDate(2002, 1, 4);
        this.assertQueryEquals("[ " + startDate + " TO " + endDate + "]", null, "[" + this.getDate(startDate) + " TO " + this.getDate(endDate) + "]");
        this.assertQueryEquals("{  " + startDate + "    " + endDate + "   }", null, "{" + this.getDate(startDate) + " TO " + this.getDate(endDate) + "}");
    }

    public void testEscaped() throws Exception {
        WhitespaceAnalyzer a = new WhitespaceAnalyzer();
        this.assertQueryEquals("a\\-b:c", a, "a-b:c");
        this.assertQueryEquals("a\\+b:c", a, "a+b:c");
        this.assertQueryEquals("a\\:b:c", a, "a:b:c");
        this.assertQueryEquals("a\\\\b:c", a, "a\\b:c");
        this.assertQueryEquals("a:b\\-c", a, "a:b-c");
        this.assertQueryEquals("a:b\\+c", a, "a:b+c");
        this.assertQueryEquals("a:b\\:c", a, "a:b:c");
        this.assertQueryEquals("a:b\\\\c", a, "a:b\\c");
        this.assertQueryEquals("a:b\\-c*", a, "a:b-c*");
        this.assertQueryEquals("a:b\\+c*", a, "a:b+c*");
        this.assertQueryEquals("a:b\\:c*", a, "a:b:c*");
        this.assertQueryEquals("a:b\\\\c*", a, "a:b\\c*");
        this.assertQueryEquals("a:b\\-?c", a, "a:b-?c");
        this.assertQueryEquals("a:b\\+?c", a, "a:b+?c");
        this.assertQueryEquals("a:b\\:?c", a, "a:b:?c");
        this.assertQueryEquals("a:b\\\\?c", a, "a:b\\?c");
        this.assertQueryEquals("a:b\\-c~", a, "a:b-c~0.5");
        this.assertQueryEquals("a:b\\+c~", a, "a:b+c~0.5");
        this.assertQueryEquals("a:b\\:c~", a, "a:b:c~0.5");
        this.assertQueryEquals("a:b\\\\c~", a, "a:b\\c~0.5");
        this.assertQueryEquals("[ a\\- TO a\\+ ]", null, "[a- TO a+]");
        this.assertQueryEquals("[ a\\: TO a\\~ ]", null, "[a: TO a~]");
        this.assertQueryEquals("[ a\\\\ TO a\\* ]", null, "[a\\ TO a*]");
    }

    public void testTabNewlineCarriageReturn() throws Exception {
        this.assertQueryEqualsDOA("+weltbank +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\r+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\r\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r\n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r \n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\t+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \t+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \t +worlbank", null, "+weltbank +worlbank");
    }

    public void testSimpleDAO() throws Exception {
        this.assertQueryEqualsDOA("term term term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term +term term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term term +term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term +term +term", null, "+term +term +term");
        this.assertQueryEqualsDOA("-term term term", null, "-term +term +term");
    }

    public void testBoost() throws Exception {
        StandardAnalyzer oneStopAnalyzer = new StandardAnalyzer(new String[]{"on"});
        PrecedenceQueryParser qp = new PrecedenceQueryParser("field", oneStopAnalyzer);
        Query q = qp.parse("on^1.0");
        TestPrecedenceQueryParser.assertNotNull((Object)q);
        q = qp.parse("\"hello\"^2.0");
        TestPrecedenceQueryParser.assertNotNull((Object)q);
        TestPrecedenceQueryParser.assertEquals((float)q.getBoost(), (float)2.0f, (float)0.5f);
        q = qp.parse("hello^2.0");
        TestPrecedenceQueryParser.assertNotNull((Object)q);
        TestPrecedenceQueryParser.assertEquals((float)q.getBoost(), (float)2.0f, (float)0.5f);
        q = qp.parse("\"on\"^1.0");
        TestPrecedenceQueryParser.assertNotNull((Object)q);
        q = this.getParser(new StandardAnalyzer()).parse("the^3");
        TestPrecedenceQueryParser.assertNotNull((Object)q);
    }

    public void testException() throws Exception {
        try {
            this.assertQueryEquals("\"some phrase", null, "abc");
            TestPrecedenceQueryParser.fail((String)"ParseException expected, not thrown");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void testCustomQueryParserWildcard() {
        try {
            new QPTestParser("contents", new WhitespaceAnalyzer()).parse("a?t");
        }
        catch (ParseException expected) {
            return;
        }
        TestPrecedenceQueryParser.fail((String)"Wildcard queries should not be allowed");
    }

    public void testCustomQueryParserFuzzy() throws Exception {
        try {
            new QPTestParser("contents", new WhitespaceAnalyzer()).parse("xunit~");
        }
        catch (ParseException expected) {
            return;
        }
        TestPrecedenceQueryParser.fail((String)"Fuzzy queries should not be allowed");
    }

    public void testBooleanQuery() throws Exception {
        BooleanQuery.setMaxClauseCount(2);
        try {
            this.getParser(new WhitespaceAnalyzer()).parse("one two three");
            TestPrecedenceQueryParser.fail((String)"ParseException expected due to too many boolean clauses");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void _testPrecedence() throws Exception {
        PrecedenceQueryParser parser = this.getParser(new WhitespaceAnalyzer());
        Query query1 = parser.parse("A AND B OR C AND D");
        Query query2 = parser.parse("(A AND B) OR (C AND D)");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A OR B C");
        query2 = parser.parse("A B C");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A AND B C");
        query2 = parser.parse("(+A +B) C");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A AND NOT B");
        query2 = parser.parse("+A -B");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A OR NOT B");
        query2 = parser.parse("A -B");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A OR NOT B AND C");
        query2 = parser.parse("A (-B +C)");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
    }

    public void tearDown() {
        BooleanQuery.setMaxClauseCount(this.originalMaxClauses);
    }

    public static class QPTestParser
    extends PrecedenceQueryParser {
        public QPTestParser(String f, Analyzer a) {
            super(f, a);
        }

        @Override
        protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
            throw new ParseException("Fuzzy queries not allowed");
        }

        @Override
        protected Query getWildcardQuery(String field, String termStr) throws ParseException {
            throw new ParseException("Wildcard queries not allowed");
        }
    }

    public static class QPTestAnalyzer
    extends Analyzer {
        @Override
        public final TokenStream tokenStream(String fieldName, Reader reader) {
            return new QPTestFilter(new LowerCaseTokenizer(reader));
        }
    }

    public static class QPTestFilter
    extends TokenFilter {
        boolean inPhrase = false;
        int savedStart = 0;
        int savedEnd = 0;

        public QPTestFilter(TokenStream in) {
            super(in);
        }

        @Override
        public Token next() throws IOException {
            if (this.inPhrase) {
                this.inPhrase = false;
                return new Token("phrase2", this.savedStart, this.savedEnd);
            }
            Token token = this.input.next();
            while (token != null) {
                if (token.termText().equals("phrase")) {
                    this.inPhrase = true;
                    this.savedStart = token.startOffset();
                    this.savedEnd = token.endOffset();
                    return new Token("phrase1", this.savedStart, this.savedEnd);
                }
                if (!token.termText().equals("stop")) {
                    return token;
                }
                token = this.input.next();
            }
            return null;
        }
    }
}

