/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.IndexCommitPoint;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileNameFilter;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.Directory;

final class IndexFileDeleter {
    private List deletable;
    private Map refCounts = new HashMap();
    private List commits = new ArrayList();
    private List lastFiles = new ArrayList();
    private List commitsToDelete = new ArrayList();
    private PrintStream infoStream;
    private Directory directory;
    private IndexDeletionPolicy policy;
    private DocumentsWriter docWriter;
    public static boolean VERBOSE_REF_COUNTS = false;

    void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
        if (infoStream != null) {
            this.message("setInfoStream deletionPolicy=" + this.policy);
        }
    }

    private void message(String message) {
        this.infoStream.println("IFD [" + Thread.currentThread().getName() + "]: " + message);
    }

    public IndexFileDeleter(Directory directory, IndexDeletionPolicy policy, SegmentInfos segmentInfos, PrintStream infoStream, DocumentsWriter docWriter) throws CorruptIndexException, IOException {
        this.docWriter = docWriter;
        this.infoStream = infoStream;
        if (infoStream != null) {
            this.message("init: current segments file is \"" + segmentInfos.getCurrentSegmentFileName() + "\"; deletionPolicy=" + policy);
        }
        this.policy = policy;
        this.directory = directory;
        long currentGen = segmentInfos.getGeneration();
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        String[] files = directory.list();
        if (files == null) {
            throw new IOException("cannot read directory " + directory + ": list() returned null");
        }
        CommitPoint currentCommitPoint = null;
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (!filter.accept(null, fileName) || fileName.equals("segments.gen")) continue;
            this.getRefCount(fileName);
            if (!fileName.startsWith("segments") || SegmentInfos.generationFromSegmentsFileName(fileName) > currentGen) continue;
            if (infoStream != null) {
                this.message("init: load commit \"" + fileName + "\"");
            }
            SegmentInfos sis = new SegmentInfos();
            try {
                sis.read(directory, fileName);
            }
            catch (FileNotFoundException e) {
                if (infoStream != null) {
                    this.message("init: hit FileNotFoundException when loading commit \"" + fileName + "\"; skipping this commit point");
                }
                sis = null;
            }
            if (sis == null) continue;
            CommitPoint commitPoint = new CommitPoint(sis);
            if (sis.getGeneration() == segmentInfos.getGeneration()) {
                currentCommitPoint = commitPoint;
            }
            this.commits.add(commitPoint);
            this.incRef(sis, true);
        }
        if (currentCommitPoint == null) {
            SegmentInfos sis = new SegmentInfos();
            try {
                sis.read(directory, segmentInfos.getCurrentSegmentFileName());
            }
            catch (IOException e) {
                throw new CorruptIndexException("failed to locate current segments_N file");
            }
            if (infoStream != null) {
                this.message("forced open of current segments file " + segmentInfos.getCurrentSegmentFileName());
            }
            currentCommitPoint = new CommitPoint(sis);
            this.commits.add(currentCommitPoint);
            this.incRef(sis, true);
        }
        Collections.sort(this.commits);
        for (String fileName : this.refCounts.keySet()) {
            RefCount rc = (RefCount)this.refCounts.get(fileName);
            if (0 != rc.count) continue;
            if (infoStream != null) {
                this.message("init: removing unreferenced file \"" + fileName + "\"");
            }
            this.deleteFile(fileName);
        }
        policy.onInit(this.commits);
        if (currentCommitPoint.deleted) {
            this.checkpoint(segmentInfos, false);
        }
        this.deleteCommits();
    }

    private void deleteCommits() throws IOException {
        int size = this.commitsToDelete.size();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                CommitPoint commit = (CommitPoint)this.commitsToDelete.get(i);
                if (this.infoStream != null) {
                    this.message("deleteCommits: now remove commit \"" + commit.getSegmentsFileName() + "\"");
                }
                int size2 = commit.files.size();
                for (int j = 0; j < size2; ++j) {
                    this.decRef((String)commit.files.get(j));
                }
            }
            this.commitsToDelete.clear();
            size = this.commits.size();
            int writeTo = 0;
            for (int readFrom = 0; readFrom < size; ++readFrom) {
                CommitPoint commit = (CommitPoint)this.commits.get(readFrom);
                if (commit.deleted) continue;
                if (writeTo != readFrom) {
                    this.commits.set(writeTo, this.commits.get(readFrom));
                }
                ++writeTo;
            }
            while (size > writeTo) {
                this.commits.remove(size - 1);
                --size;
            }
        }
    }

    public void refresh(String segmentName) throws IOException {
        String segmentPrefix2;
        String segmentPrefix1;
        String[] files = this.directory.list();
        if (files == null) {
            throw new IOException("cannot read directory " + this.directory + ": list() returned null");
        }
        IndexFileNameFilter filter = IndexFileNameFilter.getFilter();
        if (segmentName != null) {
            segmentPrefix1 = segmentName + ".";
            segmentPrefix2 = segmentName + "_";
        } else {
            segmentPrefix1 = null;
            segmentPrefix2 = null;
        }
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (!filter.accept(null, fileName) || segmentName != null && !fileName.startsWith(segmentPrefix1) && !fileName.startsWith(segmentPrefix2) || this.refCounts.containsKey(fileName) || fileName.equals("segments.gen")) continue;
            if (this.infoStream != null) {
                this.message("refresh [prefix=" + segmentName + "]: removing newly created unreferenced file \"" + fileName + "\"");
            }
            this.deleteFile(fileName);
        }
    }

    public void refresh() throws IOException {
        this.refresh(null);
    }

    public void close() throws IOException {
        this.deletePendingFiles();
    }

    private void deletePendingFiles() throws IOException {
        if (this.deletable != null) {
            List oldDeletable = this.deletable;
            this.deletable = null;
            int size = oldDeletable.size();
            for (int i = 0; i < size; ++i) {
                if (this.infoStream != null) {
                    this.message("delete pending file " + oldDeletable.get(i));
                }
                this.deleteFile((String)oldDeletable.get(i));
            }
        }
    }

    public void checkpoint(SegmentInfos segmentInfos, boolean isCommit) throws IOException {
        int i;
        int size;
        List docWriterFiles;
        if (this.infoStream != null) {
            this.message("now checkpoint \"" + segmentInfos.getCurrentSegmentFileName() + "\" [" + segmentInfos.size() + " segments ; isCommit = " + isCommit + "]");
        }
        this.deletePendingFiles();
        this.incRef(segmentInfos, isCommit);
        if (this.docWriter != null) {
            docWriterFiles = this.docWriter.files();
            if (docWriterFiles != null) {
                this.incRef(docWriterFiles);
            }
        } else {
            docWriterFiles = null;
        }
        if (isCommit) {
            this.commits.add(new CommitPoint(segmentInfos));
            this.policy.onCommit(this.commits);
            this.deleteCommits();
        }
        if ((size = this.lastFiles.size()) > 0) {
            for (i = 0; i < size; ++i) {
                this.decRef((List)this.lastFiles.get(i));
            }
            this.lastFiles.clear();
        }
        if (!isCommit) {
            size = segmentInfos.size();
            for (i = 0; i < size; ++i) {
                SegmentInfo segmentInfo = segmentInfos.info(i);
                if (segmentInfo.dir != this.directory) continue;
                this.lastFiles.add(segmentInfo.files());
            }
        }
        if (docWriterFiles != null) {
            this.lastFiles.add(docWriterFiles);
        }
    }

    void incRef(SegmentInfos segmentInfos, boolean isCommit) throws IOException {
        int size = segmentInfos.size();
        for (int i = 0; i < size; ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            if (segmentInfo.dir != this.directory) continue;
            this.incRef(segmentInfo.files());
        }
        if (isCommit) {
            this.getRefCount(segmentInfos.getCurrentSegmentFileName()).IncRef();
        }
    }

    void incRef(List files) throws IOException {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            String fileName = (String)files.get(i);
            RefCount rc = this.getRefCount(fileName);
            if (this.infoStream != null && VERBOSE_REF_COUNTS) {
                this.message("  IncRef \"" + fileName + "\": pre-incr count is " + rc.count);
            }
            rc.IncRef();
        }
    }

    void decRef(List files) throws IOException {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            this.decRef((String)files.get(i));
        }
    }

    private void decRef(String fileName) throws IOException {
        RefCount rc = this.getRefCount(fileName);
        if (this.infoStream != null && VERBOSE_REF_COUNTS) {
            this.message("  DecRef \"" + fileName + "\": pre-decr count is " + rc.count);
        }
        if (0 == rc.DecRef()) {
            this.deleteFile(fileName);
            this.refCounts.remove(fileName);
        }
    }

    void decRef(SegmentInfos segmentInfos) throws IOException {
        int size = segmentInfos.size();
        for (int i = 0; i < size; ++i) {
            SegmentInfo segmentInfo = segmentInfos.info(i);
            if (segmentInfo.dir != this.directory) continue;
            this.decRef(segmentInfo.files());
        }
    }

    private RefCount getRefCount(String fileName) {
        RefCount rc;
        if (!this.refCounts.containsKey(fileName)) {
            rc = new RefCount();
            this.refCounts.put(fileName, rc);
        } else {
            rc = (RefCount)this.refCounts.get(fileName);
        }
        return rc;
    }

    void deleteFiles(List files) throws IOException {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            this.deleteFile((String)files.get(i));
        }
    }

    void deleteNewFiles(List files) throws IOException {
        int size = files.size();
        for (int i = 0; i < size; ++i) {
            if (this.refCounts.containsKey(files.get(i))) continue;
            this.deleteFile((String)files.get(i));
        }
    }

    void deleteFile(String fileName) throws IOException {
        block5: {
            try {
                if (this.infoStream != null) {
                    this.message("delete \"" + fileName + "\"");
                }
                this.directory.deleteFile(fileName);
            }
            catch (IOException e) {
                if (!this.directory.fileExists(fileName)) break block5;
                if (this.infoStream != null) {
                    this.message("IndexFileDeleter: unable to remove file \"" + fileName + "\": " + e.toString() + "; Will re-try later.");
                }
                if (this.deletable == null) {
                    this.deletable = new ArrayList();
                }
                this.deletable.add(fileName);
            }
        }
    }

    private final class CommitPoint
    implements Comparable,
    IndexCommitPoint {
        long gen;
        List files;
        String segmentsFileName;
        boolean deleted;

        public CommitPoint(SegmentInfos segmentInfos) throws IOException {
            this.segmentsFileName = segmentInfos.getCurrentSegmentFileName();
            int size = segmentInfos.size();
            this.files = new ArrayList(size);
            this.files.add(this.segmentsFileName);
            this.gen = segmentInfos.getGeneration();
            for (int i = 0; i < size; ++i) {
                SegmentInfo segmentInfo = segmentInfos.info(i);
                if (segmentInfo.dir != IndexFileDeleter.this.directory) continue;
                this.files.addAll(segmentInfo.files());
            }
        }

        @Override
        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        @Override
        public Collection getFileNames() throws IOException {
            return Collections.unmodifiableCollection(this.files);
        }

        @Override
        public void delete() {
            if (!this.deleted) {
                this.deleted = true;
                IndexFileDeleter.this.commitsToDelete.add(this);
            }
        }

        public int compareTo(Object obj) {
            CommitPoint commit = (CommitPoint)obj;
            if (this.gen < commit.gen) {
                return -1;
            }
            if (this.gen > commit.gen) {
                return 1;
            }
            return 0;
        }
    }

    private static final class RefCount {
        int count;

        private RefCount() {
        }

        public int IncRef() {
            return ++this.count;
        }

        public int DecRef() {
            assert (this.count > 0);
            return --this.count;
        }
    }
}

