/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Date;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class FieldNormModifier {
    private Directory dir;
    private Similarity sim;

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("Usage: FieldNormModifier <index> <package.SimilarityClassName | -n> <field1> [field2] ...");
            System.exit(1);
        }
        Similarity s = null;
        if (!args[1].equals("-n")) {
            try {
                Class<?> simClass = Class.forName(args[1]);
                s = (Similarity)simClass.newInstance();
            }
            catch (Exception e) {
                System.err.println("Couldn't instantiate similarity with empty constructor: " + args[1]);
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
        FSDirectory d = FSDirectory.getDirectory(args[0], false);
        FieldNormModifier fnm = new FieldNormModifier(d, s);
        for (int i = 2; i < args.length; ++i) {
            System.out.print("Updating field: " + args[i] + " " + new Date().toString() + " ... ");
            fnm.reSetNorms(args[i]);
            System.out.println(new Date().toString());
        }
        ((Directory)d).close();
    }

    public FieldNormModifier(Directory d, Similarity s) {
        this.dir = d;
        this.sim = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reSetNorms(String field) throws IOException {
        String fieldName = field.intern();
        int[] termCounts = new int[]{};
        byte[] fakeNorms = new byte[]{};
        IndexReader reader = null;
        TermEnum termEnum = null;
        TermDocs termDocs = null;
        try {
            reader = IndexReader.open(this.dir);
            termCounts = new int[reader.maxDoc()];
            if (this.sim == null) {
                fakeNorms = SegmentReader.createFakeNorms(reader.maxDoc());
            }
            try {
                termEnum = reader.terms(new Term(field, ""));
                try {
                    termDocs = reader.termDocs();
                    do {
                        Term term;
                        if ((term = termEnum.term()) == null || !term.field().equals(fieldName)) continue;
                        termDocs.seek(termEnum.term());
                        while (termDocs.next()) {
                            int n = termDocs.doc();
                            termCounts[n] = termCounts[n] + termDocs.freq();
                        }
                    } while (termEnum.next());
                }
                finally {
                    if (null != termDocs) {
                        termDocs.close();
                    }
                }
            }
            finally {
                if (null != termEnum) {
                    termEnum.close();
                }
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        try {
            reader = IndexReader.open(this.dir);
            for (int d = 0; d < termCounts.length; ++d) {
                if (reader.isDeleted(d)) continue;
                if (this.sim == null) {
                    reader.setNorm(d, fieldName, fakeNorms[0]);
                    continue;
                }
                reader.setNorm(d, fieldName, Similarity.encodeNorm(this.sim.lengthNorm(fieldName, termCounts[d])));
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
    }
}

