/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.th.ThaiAnalyzer;

public class TestThaiAnalyzer
extends TestCase {
    public void assertAnalyzesTo(Analyzer a, String input, String[] output) throws Exception {
        TokenStream ts = a.tokenStream("dummy", new StringReader(input));
        for (int i = 0; i < output.length; ++i) {
            Token t = ts.next();
            TestThaiAnalyzer.assertNotNull((Object)t);
            TestThaiAnalyzer.assertEquals((String)t.termText(), (String)output[i]);
        }
        TestThaiAnalyzer.assertNull((Object)ts.next());
        ts.close();
    }

    public void testAnalyzer() throws Exception {
        ThaiAnalyzer analyzer = new ThaiAnalyzer();
        this.assertAnalyzesTo(analyzer, "", new String[0]);
        this.assertAnalyzesTo(analyzer, "\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e15\u0e49\u0e2d\u0e07\u0e41\u0e2a\u0e14\u0e07\u0e27\u0e48\u0e32\u0e07\u0e32\u0e19\u0e14\u0e35", new String[]{"\u0e01\u0e32\u0e23", "\u0e17\u0e35\u0e48", "\u0e44\u0e14\u0e49", "\u0e15\u0e49\u0e2d\u0e07", "\u0e41\u0e2a\u0e14\u0e07", "\u0e27\u0e48\u0e32", "\u0e07\u0e32\u0e19", "\u0e14\u0e35"});
        this.assertAnalyzesTo(analyzer, "\u0e1a\u0e23\u0e34\u0e29\u0e31\u0e17\u0e0a\u0e37\u0e48\u0e2d XY&Z - \u0e04\u0e38\u0e22\u0e01\u0e31\u0e1a xyz@demo.com", new String[]{"\u0e1a\u0e23\u0e34\u0e29\u0e31\u0e17", "\u0e0a\u0e37\u0e48\u0e2d", "xy&z", "\u0e04\u0e38\u0e22", "\u0e01\u0e31\u0e1a", "xyz@demo.com"});
        this.assertAnalyzesTo(analyzer, "\u0e1b\u0e23\u0e30\u0e42\u0e22\u0e04\u0e27\u0e48\u0e32 The quick brown fox jumped over the lazy dogs", new String[]{"\u0e1b\u0e23\u0e30\u0e42\u0e22\u0e04", "\u0e27\u0e48\u0e32", "quick", "brown", "fox", "jumped", "over", "lazy", "dogs"});
    }
}

