/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.apache.lucene.analysis.snowball.SnowballFilter;

public class TestSnowball
extends TestCase {
    public void assertAnalyzesTo(Analyzer a, String input, String[] output) throws Exception {
        TokenStream ts = a.tokenStream("dummy", new StringReader(input));
        for (int i = 0; i < output.length; ++i) {
            Token t = ts.next();
            TestSnowball.assertNotNull((Object)t);
            TestSnowball.assertEquals((String)output[i], (String)t.termText());
        }
        TestSnowball.assertNull((Object)ts.next());
        ts.close();
    }

    public void testEnglish() throws Exception {
        SnowballAnalyzer a = new SnowballAnalyzer("English");
        this.assertAnalyzesTo(a, "he abhorred accents", new String[]{"he", "abhor", "accent"});
    }

    public void testFilterTokens() throws Exception {
        final Token tok = new Token("accents", 2, 7, "wrd");
        tok.setPositionIncrement(3);
        SnowballFilter filter = new SnowballFilter(new TokenStream(){

            @Override
            public Token next() {
                return tok;
            }
        }, "English");
        Token newtok = filter.next();
        TestSnowball.assertEquals((String)"accent", (String)newtok.termText());
        TestSnowball.assertEquals((int)2, (int)newtok.startOffset());
        TestSnowball.assertEquals((int)7, (int)newtok.endOffset());
        TestSnowball.assertEquals((String)"wrd", (String)newtok.type());
        TestSnowball.assertEquals((int)3, (int)newtok.getPositionIncrement());
    }
}

