/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.lucene.analysis.ru.RussianCharsets;
import org.apache.lucene.analysis.ru.RussianStemmer;

public class TestRussianStem
extends TestCase {
    private ArrayList words = new ArrayList();
    private ArrayList stems = new ArrayList();

    public TestRussianStem(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        String str;
        super.setUp();
        File dataDir = new File(System.getProperty("dataDir", "./bin"));
        BufferedReader inWords = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(dataDir, "/org/apache/lucene/analysis/ru/wordsUnicode.txt")), "Unicode"));
        while ((str = inWords.readLine()) != null) {
            this.words.add(str);
        }
        inWords.close();
        BufferedReader inStems = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(dataDir, "/org/apache/lucene/analysis/ru/stemsUnicode.txt")), "Unicode"));
        while ((str = inStems.readLine()) != null) {
            this.stems.add(str);
        }
        inStems.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testStem() {
        for (int i = 0; i < this.words.size(); ++i) {
            String realStem = RussianStemmer.stem((String)this.words.get(i), RussianCharsets.UnicodeRussian);
            TestRussianStem.assertEquals((String)"unicode", this.stems.get(i), (Object)realStem);
        }
    }
}

