/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ru;

import java.io.Reader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ru.RussianCharsets;
import org.apache.lucene.analysis.ru.RussianLetterTokenizer;
import org.apache.lucene.analysis.ru.RussianLowerCaseFilter;
import org.apache.lucene.analysis.ru.RussianStemFilter;

public final class RussianAnalyzer
extends Analyzer {
    private static final char A = '\u0000';
    private static final char B = '\u0001';
    private static final char V = '\u0002';
    private static final char G = '\u0003';
    private static final char D = '\u0004';
    private static final char E = '\u0005';
    private static final char ZH = '\u0006';
    private static final char Z = '\u0007';
    private static final char I = '\b';
    private static final char I_ = '\t';
    private static final char K = '\n';
    private static final char L = '\u000b';
    private static final char M = '\f';
    private static final char N = '\r';
    private static final char O = '\u000e';
    private static final char P = '\u000f';
    private static final char R = '\u0010';
    private static final char S = '\u0011';
    private static final char T = '\u0012';
    private static final char U = '\u0013';
    private static final char X = '\u0015';
    private static final char CH = '\u0017';
    private static final char SH = '\u0018';
    private static final char SHCH = '\u0019';
    private static final char Y = '\u001b';
    private static final char SOFT = '\u001c';
    private static final char AE = '\u001d';
    private static final char IU = '\u001e';
    private static final char IA = '\u001f';
    private static char[][] RUSSIAN_STOP_WORDS = new char[][]{{'\u0000'}, {'\u0001', '\u0005', '\u0007'}, {'\u0001', '\u000e', '\u000b', '\u0005', '\u0005'}, {'\u0001', '\u001b'}, {'\u0001', '\u001b', '\u000b'}, {'\u0001', '\u001b', '\u000b', '\u0000'}, {'\u0001', '\u001b', '\u000b', '\b'}, {'\u0001', '\u001b', '\u000b', '\u000e'}, {'\u0001', '\u001b', '\u0012', '\u001c'}, {'\u0002'}, {'\u0002', '\u0000', '\f'}, {'\u0002', '\u0000', '\u0011'}, {'\u0002', '\u0005', '\u0011', '\u001c'}, {'\u0002', '\u000e'}, {'\u0002', '\u000e', '\u0012'}, {'\u0002', '\u0011', '\u0005'}, {'\u0002', '\u0011', '\u0005', '\u0003', '\u000e'}, {'\u0002', '\u0011', '\u0005', '\u0015'}, {'\u0002', '\u001b'}, {'\u0003', '\u0004', '\u0005'}, {'\u0004', '\u0000'}, {'\u0004', '\u0000', '\u0006', '\u0005'}, {'\u0004', '\u000b', '\u001f'}, {'\u0004', '\u000e'}, {'\u0005', '\u0003', '\u000e'}, {'\u0005', '\u0005'}, {'\u0005', '\t'}, {'\u0005', '\u001e'}, {'\u0005', '\u0011', '\u000b', '\b'}, {'\u0005', '\u0011', '\u0012', '\u001c'}, {'\u0005', '\u0019', '\u0005'}, {'\u0006', '\u0005'}, {'\u0007', '\u0000'}, {'\u0007', '\u0004', '\u0005', '\u0011', '\u001c'}, {'\b'}, {'\b', '\u0007'}, {'\b', '\u000b', '\b'}, {'\b', '\f'}, {'\b', '\u0015'}, {'\n'}, {'\n', '\u0000', '\n'}, {'\n', '\u000e'}, {'\n', '\u000e', '\u0003', '\u0004', '\u0000'}, {'\n', '\u0012', '\u000e'}, {'\u000b', '\b'}, {'\u000b', '\b', '\u0001', '\u000e'}, {'\f', '\r', '\u0005'}, {'\f', '\u000e', '\u0006', '\u0005', '\u0012'}, {'\f', '\u001b'}, {'\r', '\u0000'}, {'\r', '\u0000', '\u0004', '\u000e'}, {'\r', '\u0000', '\u0018'}, {'\r', '\u0005'}, {'\r', '\u0005', '\u0003', '\u000e'}, {'\r', '\u0005', '\u0005'}, {'\r', '\u0005', '\u0012'}, {'\r', '\b'}, {'\r', '\b', '\u0015'}, {'\r', '\u000e'}, {'\r', '\u0013'}, {'\u000e'}, {'\u000e', '\u0001'}, {'\u000e', '\u0004', '\r', '\u0000', '\n', '\u000e'}, {'\u000e', '\r'}, {'\u000e', '\r', '\u0000'}, {'\u000e', '\r', '\b'}, {'\u000e', '\r', '\u000e'}, {'\u000e', '\u0012'}, {'\u000e', '\u0017', '\u0005', '\r', '\u001c'}, {'\u000f', '\u000e'}, {'\u000f', '\u000e', '\u0004'}, {'\u000f', '\u0010', '\b'}, {'\u0011'}, {'\u0011', '\u000e'}, {'\u0012', '\u0000', '\n'}, {'\u0012', '\u0000', '\n', '\u0006', '\u0005'}, {'\u0012', '\u0000', '\n', '\u000e', '\t'}, {'\u0012', '\u0000', '\f'}, {'\u0012', '\u0005'}, {'\u0012', '\u0005', '\f'}, {'\u0012', '\u000e'}, {'\u0012', '\u000e', '\u0003', '\u000e'}, {'\u0012', '\u000e', '\u0006', '\u0005'}, {'\u0012', '\u000e', '\t'}, {'\u0012', '\u000e', '\u000b', '\u001c', '\n', '\u000e'}, {'\u0012', '\u000e', '\f'}, {'\u0012', '\u001b'}, {'\u0013'}, {'\u0013', '\u0006', '\u0005'}, {'\u0015', '\u000e', '\u0012', '\u001f'}, {'\u0017', '\u0005', '\u0003', '\u000e'}, {'\u0017', '\u0005', '\t'}, {'\u0017', '\u0005', '\f'}, {'\u0017', '\u0012', '\u000e'}, {'\u0017', '\u0012', '\u000e', '\u0001', '\u001b'}, {'\u0017', '\u001c', '\u0005'}, {'\u0017', '\u001c', '\u001f'}, {'\u001d', '\u0012', '\u0000'}, {'\u001d', '\u0012', '\b'}, {'\u001d', '\u0012', '\u000e'}, {'\u001f'}};
    private Set stopSet = new HashSet();
    private char[] charset;

    public RussianAnalyzer() {
        this.charset = RussianCharsets.UnicodeRussian;
        this.stopSet = StopFilter.makeStopSet(RussianAnalyzer.makeStopWords(RussianCharsets.UnicodeRussian));
    }

    public RussianAnalyzer(char[] charset) {
        this.charset = charset;
        this.stopSet = StopFilter.makeStopSet(RussianAnalyzer.makeStopWords(charset));
    }

    public RussianAnalyzer(char[] charset, String[] stopwords) {
        this.charset = charset;
        this.stopSet = StopFilter.makeStopSet(stopwords);
    }

    private static String[] makeStopWords(char[] charset) {
        String[] res = new String[RUSSIAN_STOP_WORDS.length];
        for (int i = 0; i < res.length; ++i) {
            char[] theStopWord = RUSSIAN_STOP_WORDS[i];
            StringBuffer theWord = new StringBuffer();
            for (int j = 0; j < theStopWord.length; ++j) {
                theWord.append(charset[theStopWord[j]]);
            }
            res[i] = theWord.toString();
        }
        return res;
    }

    public RussianAnalyzer(char[] charset, Hashtable stopwords) {
        this.charset = charset;
        this.stopSet = new HashSet(stopwords.keySet());
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        TokenStream result = new RussianLetterTokenizer(reader, this.charset);
        result = new RussianLowerCaseFilter(result, this.charset);
        result = new StopFilter(result, this.stopSet);
        result = new RussianStemFilter(result, this.charset);
        return result;
    }
}

