/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.payloads;

import java.io.IOException;
import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.payloads.TokenOffsetPayloadTokenFilter;
import org.apache.lucene.index.Payload;

public class TokenOffsetPayloadTokenFilterTest
extends TestCase {
    public TokenOffsetPayloadTokenFilterTest(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void test() throws IOException {
        String test = "The quick red fox jumped over the lazy brown dogs";
        TokenOffsetPayloadTokenFilter nptf = new TokenOffsetPayloadTokenFilter(new WhitespaceTokenizer(new StringReader(test)));
        Token tok = new Token();
        int count = 0;
        while ((tok = nptf.next(tok)) != null) {
            TokenOffsetPayloadTokenFilterTest.assertTrue((String)"tok is null and it shouldn't be", (tok != null ? 1 : 0) != 0);
            Payload pay = tok.getPayload();
            TokenOffsetPayloadTokenFilterTest.assertTrue((String)"pay is null and it shouldn't be", (pay != null ? 1 : 0) != 0);
            byte[] data = pay.getData();
            int start = PayloadHelper.decodeInt(data, 0);
            TokenOffsetPayloadTokenFilterTest.assertTrue((String)(start + " does not equal: " + tok.startOffset()), (start == tok.startOffset() ? 1 : 0) != 0);
            int end = PayloadHelper.decodeInt(data, 4);
            TokenOffsetPayloadTokenFilterTest.assertTrue((String)(end + " does not equal: " + tok.endOffset()), (end == tok.endOffset() ? 1 : 0) != 0);
            ++count;
        }
        TokenOffsetPayloadTokenFilterTest.assertTrue((String)(count + " does not equal: " + 10), (count == 10 ? 1 : 0) != 0);
    }
}

