/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.nl.DutchStemmer;

public final class DutchStemFilter
extends TokenFilter {
    private Token token = null;
    private DutchStemmer stemmer = new DutchStemmer();
    private Set exclusions = null;

    public DutchStemFilter(TokenStream _in) {
        super(_in);
    }

    public DutchStemFilter(TokenStream _in, Set exclusiontable) {
        this(_in);
        this.exclusions = exclusiontable;
    }

    public DutchStemFilter(TokenStream _in, Set exclusiontable, Map stemdictionary) {
        this(_in, exclusiontable);
        this.stemmer.setStemDictionary(stemdictionary);
    }

    @Override
    public Token next() throws IOException {
        this.token = this.input.next();
        if (this.token == null) {
            return null;
        }
        if (this.exclusions != null && this.exclusions.contains(this.token.termText())) {
            return this.token;
        }
        String s = this.stemmer.stem(this.token.termText());
        if (!s.equals(this.token.termText())) {
            return new Token(s, this.token.startOffset(), this.token.endOffset(), this.token.type());
        }
        return this.token;
    }

    public void setStemmer(DutchStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }

    public void setExclusionTable(HashSet exclusiontable) {
        this.exclusions = exclusiontable;
    }

    public void setStemDictionary(HashMap dict) {
        if (this.stemmer != null) {
            this.stemmer.setStemDictionary(dict);
        }
    }
}

