/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.StringReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenFilter;

public class NGramTokenFilterTest
extends TestCase {
    private TokenStream input;
    private ArrayList tokens = new ArrayList();

    public void setUp() {
        this.input = new WhitespaceTokenizer(new StringReader("abcde"));
    }

    public void testInvalidInput() throws Exception {
        boolean gotException = false;
        try {
            new NGramTokenFilter(this.input, 2, 1);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        NGramTokenFilterTest.assertTrue((boolean)gotException);
    }

    public void testInvalidInput2() throws Exception {
        boolean gotException = false;
        try {
            new NGramTokenFilter(this.input, 0, 1);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        NGramTokenFilterTest.assertTrue((boolean)gotException);
    }

    public void testUnigrams() throws Exception {
        NGramTokenFilter filter = new NGramTokenFilter(this.input, 1, 1);
        Token token = null;
        do {
            if ((token = filter.next()) == null) continue;
            this.tokens.add(token.toString());
        } while (token != null);
        NGramTokenFilterTest.assertEquals((int)5, (int)this.tokens.size());
        ArrayList<String> exp = new ArrayList<String>();
        exp.add("(a,0,1)");
        exp.add("(b,1,2)");
        exp.add("(c,2,3)");
        exp.add("(d,3,4)");
        exp.add("(e,4,5)");
        NGramTokenFilterTest.assertEquals(exp, (Object)this.tokens);
    }

    public void testBigrams() throws Exception {
        NGramTokenFilter filter = new NGramTokenFilter(this.input, 2, 2);
        Token token = null;
        do {
            if ((token = filter.next()) == null) continue;
            this.tokens.add(token.toString());
        } while (token != null);
        NGramTokenFilterTest.assertEquals((int)4, (int)this.tokens.size());
        ArrayList<String> exp = new ArrayList<String>();
        exp.add("(ab,0,2)");
        exp.add("(bc,1,3)");
        exp.add("(cd,2,4)");
        exp.add("(de,3,5)");
        NGramTokenFilterTest.assertEquals(exp, (Object)this.tokens);
    }

    public void testNgrams() throws Exception {
        NGramTokenFilter filter = new NGramTokenFilter(this.input, 1, 3);
        Token token = null;
        do {
            if ((token = filter.next()) == null) continue;
            this.tokens.add(token.toString());
        } while (token != null);
        NGramTokenFilterTest.assertEquals((int)12, (int)this.tokens.size());
        ArrayList<String> exp = new ArrayList<String>();
        exp.add("(a,0,1)");
        exp.add("(b,1,2)");
        exp.add("(c,2,3)");
        exp.add("(d,3,4)");
        exp.add("(e,4,5)");
        exp.add("(ab,0,2)");
        exp.add("(bc,1,3)");
        exp.add("(cd,2,4)");
        exp.add("(de,3,5)");
        exp.add("(abc,0,3)");
        exp.add("(bcd,1,4)");
        exp.add("(cde,2,5)");
        NGramTokenFilterTest.assertEquals(exp, (Object)this.tokens);
    }

    public void testOversizedNgrams() throws Exception {
        NGramTokenFilter filter = new NGramTokenFilter(this.input, 6, 7);
        Token token = null;
        do {
            if ((token = filter.next()) == null) continue;
            this.tokens.add(token.toString());
        } while (token != null);
        NGramTokenFilterTest.assertTrue((boolean)this.tokens.isEmpty());
    }
}

