/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;

public class TestFrenchAnalyzer
extends TestCase {
    public void assertAnalyzesTo(Analyzer a, String input, String[] output) throws Exception {
        TokenStream ts = a.tokenStream("dummy", new StringReader(input));
        for (int i = 0; i < output.length; ++i) {
            Token t = ts.next();
            TestFrenchAnalyzer.assertNotNull((Object)t);
            TestFrenchAnalyzer.assertEquals((String)t.termText(), (String)output[i]);
        }
        TestFrenchAnalyzer.assertNull((Object)ts.next());
        ts.close();
    }

    public void testAnalyzer() throws Exception {
        FrenchAnalyzer fa = new FrenchAnalyzer();
        boolean iaeFlag = false;
        try {
            fa.tokenStream("dummy", null);
        }
        catch (IllegalArgumentException iae) {
            iaeFlag = true;
        }
        TestFrenchAnalyzer.assertEquals((boolean)iaeFlag, (boolean)true);
        iaeFlag = false;
        try {
            fa.tokenStream(null, new StringReader("dummy"));
        }
        catch (IllegalArgumentException iae) {
            iaeFlag = true;
        }
        TestFrenchAnalyzer.assertEquals((boolean)iaeFlag, (boolean)true);
        this.assertAnalyzesTo(fa, "", new String[0]);
        this.assertAnalyzesTo(fa, "chien chat cheval", new String[]{"chien", "chat", "cheval"});
        this.assertAnalyzesTo(fa, "chien CHAT CHEVAL", new String[]{"chien", "chat", "cheval"});
        this.assertAnalyzesTo(fa, "  chien  ,? + = -  CHAT /: > CHEVAL", new String[]{"chien", "chat", "cheval"});
        this.assertAnalyzesTo(fa, "chien++", new String[]{"chien"});
        this.assertAnalyzesTo(fa, "mot \"entreguillemet\"", new String[]{"mot", "entreguillemet"});
        this.assertAnalyzesTo(fa, "Jean-Fran\u00e7ois", new String[]{"jean", "fran\u00e7ois"});
        this.assertAnalyzesTo(fa, "le la chien les aux chat du des \u00e0 cheval", new String[]{"chien", "chat", "cheval"});
        this.assertAnalyzesTo(fa, "lances chismes habitable chiste \u00e9l\u00e9ments captifs", new String[]{"lanc", "chism", "habit", "chist", "\u00e9l\u00e9ment", "captif"});
        this.assertAnalyzesTo(fa, "finissions souffrirent rugissante", new String[]{"fin", "souffr", "rug"});
        this.assertAnalyzesTo(fa, "C3PO aujourd'hui oeuf \u00ef\u00e2\u00f6\u00fb\u00e0\u00e4 anticonstitutionnellement Java++ ", new String[]{"c3po", "aujourd'hui", "oeuf", "\u00ef\u00e2\u00f6\u00fb\u00e0\u00e4", "anticonstitutionnel", "jav"});
        this.assertAnalyzesTo(fa, "33Bis 1940-1945 1940:1945 (---i+++)*", new String[]{"33bis", "1940-1945", "1940", "1945", "i"});
    }
}

