/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public class KeywordTokenizer
extends Tokenizer {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private boolean done = false;

    public KeywordTokenizer(Reader input) {
        this(input, 256);
    }

    public KeywordTokenizer(Reader input, int bufferSize) {
        super(input);
    }

    @Override
    public Token next(Token result) throws IOException {
        if (!this.done) {
            int length;
            this.done = true;
            int upto = 0;
            result.clear();
            char[] buffer = result.termBuffer();
            while ((length = this.input.read(buffer, upto, buffer.length - upto)) != -1) {
                if ((upto += length) != buffer.length) continue;
                buffer = result.resizeTermBuffer(1 + buffer.length);
            }
            result.termLength = upto;
            return result;
        }
        return null;
    }

    @Override
    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.done = false;
    }
}

