/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.transformation;

import bayesnet.jayes.factor.AbstractFactor;
import bayesnet.jayes.transformation.AbstractDecomposition;
import bayesnet.jayes.util.MathUtils;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math.linear.MatrixUtils;

public class SmoothedFactorDecomposition
extends AbstractDecomposition {
    @Override
    protected double[] toLatentSpace(double[] v, List<double[]> best) {
        double min = Doubles.min((double[])v);
        double[] latent = new double[v.length + 1];
        latent[0] = min;
        double[] h = new double[v.length];
        Arrays.fill(h, min);
        MathUtils.secureSubtract(v, h, h);
        System.arraycopy(h, 0, latent, 1, h.length);
        return latent;
    }

    @Override
    protected List<double[]> getBasis(AbstractFactor f, List<double[]> vectors) {
        ArrayList<double[]> basis = new ArrayList<double[]>();
        int d = MathUtils.product(f.getDimensions()) / vectors.size();
        double[] ones = new double[d];
        Arrays.fill(ones, 1.0);
        basis.add(ones);
        for (double[] e : MatrixUtils.createRealIdentityMatrix((int)d).getData()) {
            basis.add(e);
        }
        return basis;
    }
}

