/*
 * Decompiled with CFR 0.152.
 */
package bayesnet.jayes.transformation;

import bayesnet.jayes.factor.AbstractFactor;
import bayesnet.jayes.transformation.AbstractDecomposition;
import bayesnet.jayes.transformation.util.CanonicalDoubleArrayManager;
import bayesnet.jayes.transformation.util.DecompositionFailedException;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.commons.math.optimization.GoalType;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.RealPointValuePair;
import org.apache.commons.math.optimization.linear.LinearConstraint;
import org.apache.commons.math.optimization.linear.LinearObjectiveFunction;
import org.apache.commons.math.optimization.linear.Relationship;
import org.apache.commons.math.optimization.linear.SimplexSolver;

public class LatentDeterministicDecomposition
extends AbstractDecomposition {
    @Override
    protected List<double[]> getBasis(AbstractFactor f, List<double[]> vectors) throws DecompositionFailedException {
        Map<double[], Integer> counts = this.count(vectors);
        List<double[]> basis = this.getBest(counts, f.getValues().length() / vectors.size(), vectors.size() / 2);
        if (basis == null) {
            throw new DecompositionFailedException("Could not find a good enough basis");
        }
        return basis;
    }

    private Map<double[], Integer> count(List<double[]> vectors) {
        HashMap<double[], Integer> counts = new HashMap<double[], Integer>();
        for (double[] vector : Lists.transform(vectors, (Function)new CanonicalDoubleArrayManager())) {
            if (!counts.containsKey(vector)) {
                counts.put(vector, 0);
            }
            counts.put(vector, (Integer)counts.get(vector) + 1);
        }
        return counts;
    }

    private List<double[]> getBest(Map<double[], Integer> counts, int basisSize, int minTotalCounts) {
        PriorityQueue<double[]> q = new PriorityQueue<double[]>(basisSize, (Comparator<double[]>)Ordering.natural().onResultOf(Functions.forMap(counts)));
        for (Map.Entry<double[], Integer> e : counts.entrySet()) {
            if (q.isEmpty() || q.size() < basisSize) {
                q.add(e.getKey());
                continue;
            }
            double[] head = (double[])q.peek();
            if (counts.get(head) >= counts.get(e.getKey())) continue;
            q.remove();
            q.add(e.getKey());
        }
        int totalcounts = 0;
        for (double[] v : q) {
            totalcounts += counts.get(v).intValue();
        }
        if (totalcounts < minTotalCounts) {
            return null;
        }
        return new ArrayList<double[]>(q);
    }

    @Override
    protected double[] toLatentSpace(double[] v, List<double[]> basis) throws DecompositionFailedException {
        RealPointValuePair result;
        int ind = basis.indexOf(v);
        if (ind != -1) {
            double[] l = new double[v.length];
            l[ind] = 1.0;
            return l;
        }
        List<double[]> transposedBasis = this.transpose(basis);
        ArrayList<LinearConstraint> constraints = new ArrayList<LinearConstraint>();
        for (int i = 0; i < v.length; ++i) {
            LinearConstraint c = new LinearConstraint(transposedBasis.get(i), Relationship.EQ, v[i]);
            constraints.add(c);
        }
        LinearObjectiveFunction obj = new LinearObjectiveFunction(new double[v.length], 0.0);
        try {
            result = new SimplexSolver().optimize(obj, constraints, GoalType.MINIMIZE, true);
        }
        catch (OptimizationException e) {
            throw new DecompositionFailedException(e);
        }
        return result.getPoint();
    }
}

