/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.utils;

import java.awt.Color;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.dts.spell.swing.utils.ErrorHighlighterPainter;
import org.dts.spell.swing.utils.TagList;

public class ErrorMarker {
    private JTextComponent textComponent = null;
    private Highlighter highlighter;
    private ErrorHighlighterPainter errorHighlighterPainter = new ErrorHighlighterPainter();
    private TagList errorList = new TagList();
    private TagSynchronizer caretListener = new TagSynchronizer();
    private boolean autoQuitSynchronizer = false;

    public ErrorMarker() {
        this(null, true);
    }

    public ErrorMarker(JTextComponent textComp) {
        this(textComp, true);
    }

    public ErrorMarker(JTextComponent textComp, boolean selectError) {
        this.setTextComponent(textComp);
        this.setSelectError(selectError);
    }

    public void setErrorMarkColor(Color color) {
        this.errorHighlighterPainter.setErrorColor(color);
    }

    public Color getErrorMarkColor() {
        return this.errorHighlighterPainter.getErrorColor();
    }

    public boolean isSelectError() {
        return this.errorHighlighterPainter.isHighlightBackground();
    }

    public void setSelectError(boolean selectError) {
        this.errorHighlighterPainter.setHighlightBackground(selectError);
    }

    public void setTextComponent(JTextComponent textComp) {
        this.quitTextComponent();
        this.textComponent = textComp;
        if (null != this.textComponent) {
            this.textComponent.addCaretListener(this.caretListener);
            this.textComponent.getDocument().addDocumentListener(this.caretListener);
            this.highlighter = this.textComponent.getHighlighter();
        } else {
            this.highlighter = null;
        }
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public void quitTextComponent() {
        if (null != this.textComponent) {
            this.unMarkAllErrors();
            this.textComponent.removeCaretListener(this.caretListener);
            this.textComponent.getDocument().removeDocumentListener(this.caretListener);
            this.textComponent = null;
            this.highlighter = null;
        }
    }

    public Object markError(int start, int end2, boolean scroll) throws BadLocationException {
        Object tag = this.highlighter.addHighlight(start, end2, this.errorHighlighterPainter);
        this.errorList.add(tag);
        if (scroll) {
            this.textComponent.setCaretPosition(start);
        }
        return tag;
    }

    public Object markError(int start, int end2) throws BadLocationException {
        return this.markError(start, end2, false);
    }

    public void unMarkError(Object tag) {
        this.highlighter.removeHighlight(tag);
        this.errorList.remove(tag);
    }

    public void unMarkRange(int begin, int end2) {
        this.errorList.removeRange(begin, end2, this.highlighter);
    }

    public void unMarkAllErrors() {
        this.errorList.removeAll(this.highlighter);
    }

    public boolean isAutoQuit() {
        return this.autoQuitSynchronizer;
    }

    public void setAutoQuit(boolean auto) {
        this.autoQuitSynchronizer = auto;
    }

    public String toString() {
        Highlighter.Highlight[] hl = this.highlighter.getHighlights();
        String result = "N\u00b0 Highlight " + hl.length + "\n";
        for (int i = 0; i < hl.length; ++i) {
            if (hl[i].getPainter() == this.errorHighlighterPainter) {
                result = result + "*";
            }
            result = result + hl[i] + "\n";
        }
        return result;
    }

    private class TagSynchronizer
    implements CaretListener,
    DocumentListener {
        private TagSynchronizer() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            ErrorMarker.this.errorList.updateCurrent(e.getDot());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            int os = e.getOffset();
            ErrorMarker.this.errorList.removeNullRanges(os, os + e.getLength(), ErrorMarker.this.highlighter);
            if (ErrorMarker.this.errorList.isEmpty() && ErrorMarker.this.isAutoQuit()) {
                ErrorMarker.this.quitTextComponent();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

