/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.swing.finder;

import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.dts.spell.finder.Word;
import org.dts.spell.swing.finder.DocumentCharSequence;
import org.dts.spell.swing.finder.DocumentWordFinder;
import org.dts.spell.swing.utils.TextRange;

public class SynchronizedWordFinder
extends DocumentWordFinder {
    private DocumentWordFinder documentFinder;
    private TextRange textRange;

    public SynchronizedWordFinder(DocumentWordFinder documentFinder) {
        super(documentFinder.getCharSequence(), documentFinder.getTokenizer());
        this.documentFinder = documentFinder;
    }

    public DocumentWordFinder getWrapDocumentFinder() {
        return this.documentFinder;
    }

    private Position createPosition(Word word, boolean begin) {
        Document doc = this.documentFinder.getDocument();
        if (null == word) {
            if (begin) {
                return doc.getStartPosition();
            }
            return doc.getEndPosition();
        }
        try {
            if (begin) {
                return doc.createPosition(word.getStart());
            }
            return doc.createPosition(word.getEnd());
        }
        catch (BadLocationException e) {
            if (begin) {
                return doc.getStartPosition();
            }
            return doc.getEndPosition();
        }
    }

    public void setTextRange(TextRange textRange) {
        this.textRange = textRange;
        Document doc = this.documentFinder.getDocument();
        doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    Word word = SynchronizedWordFinder.this.documentFinder.getPreviousWord(SynchronizedWordFinder.this.textRange.getBegin());
                    Position begin = SynchronizedWordFinder.this.createPosition(word, true);
                    SynchronizedWordFinder.this.documentFinder.init(word);
                    word = !SynchronizedWordFinder.this.textRange.isRemove() ? SynchronizedWordFinder.this.documentFinder.getNextWord(SynchronizedWordFinder.this.textRange.getEnd()) : SynchronizedWordFinder.this.documentFinder.getNextWord(SynchronizedWordFinder.this.textRange.getBegin());
                    Position end2 = SynchronizedWordFinder.this.createPosition(word, false);
                    SynchronizedWordFinder.this.textRange = new TextRange(begin, end2);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public String toString() {
        return "rango_analizar_(" + this.textRange + ") : #" + this.getCharSequence().subSequence(this.textRange.getBegin(), this.textRange.getEnd()).toString() + "#";
    }

    public TextRange getTextRange() {
        return this.textRange;
    }

    @Override
    public Word current() {
        return this.documentFinder.current();
    }

    @Override
    public boolean hasNext() {
        Document doc = this.documentFinder.getDocument();
        SynchronizedHasNext hasNext = new SynchronizedHasNext();
        doc.render(hasNext);
        return hasNext.hasNext();
    }

    @Override
    public Word next() {
        Document doc = this.documentFinder.getDocument();
        SynchronizedNext next = new SynchronizedNext();
        doc.render(next);
        return next.getWord();
    }

    @Override
    public void replace(final String newWord) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SynchronizedWordFinder.this.documentFinder.replace(newWord);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public CharSequence getCharSequence() {
        return this.documentFinder.getCharSequence();
    }

    @Override
    public Document getDocument() {
        return this.documentFinder.getDocument();
    }

    @Override
    public DocumentCharSequence getDocumentCharSequence() {
        return this.documentFinder.getDocumentCharSequence();
    }

    @Override
    public Word getWordAt(int index) {
        Document doc = this.documentFinder.getDocument();
        SynchronizedWordAt wordAt = new SynchronizedWordAt(index);
        doc.render(wordAt);
        return wordAt.getWord();
    }

    @Override
    public void quitDocument() {
        this.documentFinder.quitDocument();
    }

    @Override
    public void setDocument(Document document) {
        this.documentFinder.setDocument(document);
    }

    private class SynchronizedHasNext
    implements Runnable {
        private boolean hasNext;

        private SynchronizedHasNext() {
        }

        @Override
        public void run() {
            if (SynchronizedWordFinder.this.documentFinder.hasCurrent()) {
                Word word = SynchronizedWordFinder.this.current();
                this.hasNext = SynchronizedWordFinder.this.textRange.compare(word.getEnd()) > 0 ? false : SynchronizedWordFinder.this.documentFinder.hasNext();
            } else {
                this.hasNext = SynchronizedWordFinder.this.documentFinder.hasNext();
            }
        }

        public boolean hasNext() {
            return this.hasNext;
        }
    }

    private class SynchronizedNext
    implements Runnable {
        private Word word;

        private SynchronizedNext() {
        }

        @Override
        public void run() {
            this.word = SynchronizedWordFinder.this.documentFinder.next();
        }

        public Word getWord() {
            return this.word;
        }
    }

    private class SynchronizedWordAt
    implements Runnable {
        private Word word;
        private int index;

        public SynchronizedWordAt(int index) {
            this.index = index;
        }

        @Override
        public void run() {
            this.word = SynchronizedWordFinder.this.documentFinder.getWordAt(this.index);
        }

        public Word getWord() {
            return this.word;
        }
    }
}

