/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary.myspell;

import org.dts.spell.dictionary.myspell.AffEntry;
import org.dts.spell.dictionary.myspell.AffixMgr;
import org.dts.spell.dictionary.myspell.HEntry;
import org.dts.spell.dictionary.myspell.Utils;

public class PfxEntry
extends AffEntry {
    AffixMgr pmyMgr;
    PfxEntry next;
    PfxEntry nexteq;
    PfxEntry nextne;
    PfxEntry flgnxt;

    public PfxEntry(AffixMgr pmgr, AffEntry dp) {
        this.pmyMgr = pmgr;
        this.achar = dp.achar;
        this.strip = dp.strip;
        this.appnd = dp.appnd;
        this.numconds = dp.numconds;
        this.xpflg = dp.xpflg;
        System.arraycopy(dp.conds, 0, this.conds, 0, Utils.SETSIZE);
        this.next = null;
        this.nextne = null;
        this.nexteq = null;
    }

    public HEntry check(String word) {
        int len = word.length();
        int appndl = this.appnd.length();
        int stripl = this.strip.length();
        String tmpword = "";
        int tmpl = len - appndl;
        if (tmpl > 0 && tmpl + stripl >= this.numconds) {
            int cond;
            tmpword = this.strip + word.substring(appndl);
            int cp = 0;
            for (cond = 0; cond < this.numconds && (this.conds[tmpword.charAt(cp++)] & 1 << cond) != 0; ++cond) {
            }
            if (cond >= this.numconds) {
                HEntry he = this.pmyMgr.lookup(tmpword);
                if (he != null && Utils.TestAff(he.astr, this.achar, he.astr.length())) {
                    return he;
                }
                if ((this.xpflg & Utils.XPRODUCT) != 0 && (he = this.pmyMgr.suffix_check(tmpword, Utils.XPRODUCT, this)) != null) {
                    return he;
                }
            }
        }
        return null;
    }

    boolean allowCross() {
        return (this.xpflg & Utils.XPRODUCT) != 0;
    }

    public char getFlag() {
        return this.achar;
    }

    public String getKey() {
        return this.appnd;
    }

    public String add(String word) {
        int stripl;
        int len = word.length();
        if (len > (stripl = this.strip.length()) && len >= this.numconds) {
            int cond;
            int cp = 0;
            for (cond = 0; cond < this.numconds && (this.conds[word.charAt(cp++)] & 1 << cond) != 0; ++cond) {
            }
            if (cond >= this.numconds) {
                return this.appnd + word.substring(stripl);
            }
        }
        return null;
    }

    public PfxEntry getNext() {
        return this.next;
    }

    public PfxEntry getNextNE() {
        return this.nextne;
    }

    public PfxEntry getNextEQ() {
        return this.nexteq;
    }

    public PfxEntry getFlgNxt() {
        return this.flgnxt;
    }

    public void setNext(PfxEntry ptr) {
        this.next = ptr;
    }

    public void setNextNE(PfxEntry ptr) {
        this.nextne = ptr;
    }

    public void setNextEQ(PfxEntry ptr) {
        this.nexteq = ptr;
    }

    public void setFlgNxt(PfxEntry ptr) {
        this.flgnxt = ptr;
    }
}

