/*
 * Decompiled with CFR 0.152.
 */
package jehep.utils;

import bsh.Interpreter;
import groovy.lang.GroovyShell;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jmatmain.ConsoleService;
import org.python.util.jython;

public class RunScript {
    public static void main(String[] args) {
        if (args.length > 0) {
            String fin = args[0].trim();
            String option = "";
            if (args.length > 1) {
                option = " " + args[1].trim();
            }
            if (fin.endsWith(".bsh") || fin.endsWith(".Bsh") || fin.endsWith(".BSH")) {
                System.out.println("Executing:" + fin);
                try {
                    Interpreter in = new Interpreter();
                    in.source(fin);
                }
                catch (Exception ex) {
                    System.err.println("Error evaluating the script: " + ex.getMessage());
                }
                return;
            }
            if (fin.endsWith(".py") || fin.endsWith(".Py") || fin.endsWith(".PY")) {
                System.out.println("Executing:" + fin);
                jython.run((String[])args);
                return;
            }
            if (fin.endsWith(".m") || fin.endsWith(".M")) {
                System.out.println("Executing:" + fin);
                String out = RunScript.mathLib(fin);
                System.out.println(out);
                return;
            }
            if (fin.endsWith(".java") || fin.endsWith(".Java") || fin.endsWith(".JAVA")) {
                try {
                    System.out.println("Java compiling & executing:" + fin);
                    String classpath = System.getProperty("java.class.path");
                    int k = RunScript.runProcess("javac -classpath " + classpath + " " + fin);
                    if (k == 0) {
                        String ss = fin.substring(0, fin.length() - 5);
                        k = RunScript.runProcess("java -classpath " + classpath + " " + ss + option);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error evaluating code: " + e.getMessage());
                }
            } else {
                if (fin.endsWith(".groovy") || fin.endsWith(".gvy") || fin.endsWith(".gy") || fin.endsWith(".GROOVY")) {
                    System.out.println("Executing:" + fin);
                    try {
                        File fopen = new File(fin);
                        GroovyShell shell = new GroovyShell();
                        shell.evaluate(fopen);
                    }
                    catch (IOException e) {
                        System.err.println("No file found =" + fin);
                    }
                    return;
                }
                if (fin.endsWith(".rb") || fin.endsWith(".Rb") || fin.endsWith(".RB")) {
                    System.out.println("Executing:" + fin);
                    try {
                        ScriptEngine jruby = new ScriptEngineManager().getEngineByName("jruby");
                        jruby.eval(new BufferedReader(new FileReader(fin)));
                    }
                    catch (IOException e) {
                        System.err.println("No file found =" + fin);
                    }
                    catch (ScriptException ex) {
                        System.err.println("Error evaluating the script: " + ex.getMessage());
                    }
                } else {
                    System.err.println("Can only run Jython (*.py), Groovy (*.groovy, *.gvy, *.gy), JRuby (*.rb), BeanShell (*.bsh) script!");
                }
            }
        } else {
            System.err.println("Argument" + args[0] + " must be a script file or other arguments.");
            System.exit(1);
        }
    }

    private static void printLines(String name, InputStream ins) throws Exception {
        String line = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(ins));
        while ((line = in.readLine()) != null) {
            System.out.println(name + " " + line);
        }
    }

    private static int runProcess(String command) throws Exception {
        Process pro = Runtime.getRuntime().exec(command);
        RunScript.printLines(command + " stdout:", pro.getInputStream());
        RunScript.printLines(command + " stderr:", pro.getErrorStream());
        pro.waitFor();
        return pro.exitValue();
    }

    private static String mathLib(String filename) {
        String answerString = "";
        String out = null;
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(ls);
            }
            out = stringBuilder.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (out == null) {
            return answerString;
        }
        ConsoleService jasymcaConsole = new ConsoleService();
        answerString = jasymcaConsole.exec(out);
        String serr = jasymcaConsole.getError();
        if (serr.length() > 1) {
            answerString = answerString + serr;
        }
        return answerString;
    }
}

