/*
 * Decompiled with CFR 0.152.
 */
package jehep.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import jehep.ui.SetEnv;

public class ResourceLoader {
    public static String[][] substTokens;
    private static List resPaths;
    private static Hashtable bundleTable;
    private static Properties imageTable;
    private static URL defaultFailImage;

    private ResourceLoader() {
    }

    public static void setTokens(String[][] as) {
        substTokens = as;
    }

    public static void addResourcePath(String s) {
        if (s != null) {
            if (!s.equals("") && !s.endsWith("/")) {
                s = s + "/";
            }
            resPaths.add(s);
        }
    }

    private static ResourceBundle openBundle(String s) {
        ResourceBundle resourcebundle = null;
        Iterator iterator = resPaths.iterator();
        while (iterator.hasNext() && resourcebundle == null) {
            String s0 = SetEnv.locale.getLanguage();
            String s1 = (String)iterator.next() + "bundles/" + s0 + "/" + s;
            try {
                resourcebundle = ResourceBundle.getBundle(s1, SetEnv.locale);
            }
            catch (Exception exception) {}
        }
        if (resourcebundle == null) {
            System.err.println("*** MISSING RESOURCE BUNDLE *** : " + s);
        }
        bundleTable.put(s, resourcebundle);
        return resourcebundle;
    }

    public static String getString(String s, String s1) {
        String s2;
        if (s1 == null) {
            return "";
        }
        ResourceBundle resourcebundle = (ResourceBundle)bundleTable.get(s);
        if (resourcebundle == null) {
            resourcebundle = ResourceLoader.openBundle(s);
        }
        try {
            s2 = resourcebundle.getString(s1);
        }
        catch (Exception exception) {
            return "FIXME";
        }
        return s2;
    }

    public static String getCommand(String s) {
        return ResourceLoader.getString("action", s);
    }

    public static String getDisplay(String s) {
        return ResourceLoader.getString("display", s);
    }

    public static String getMessage(String s) {
        return ResourceLoader.getString("message", s);
    }

    public static String codeOrRealMsg(String s) {
        String s1 = ResourceLoader.getString("message", s);
        if (s1.equals("FIXME")) {
            s1 = s;
        }
        return s1;
    }

    public static String codeOrRealDisplay(String s) {
        String s1 = ResourceLoader.getString("display", s);
        if (s1.equals("FIXME")) {
            s1 = s;
        }
        return s1;
    }

    public static void init(String s) {
        ResourceLoader.addResourcePath(s);
        ResourceLoader.getString("action", "testvalue");
        ResourceLoader.getString("display", "testvalue");
        imageTable = new Properties();
        try {
            imageTable.load(ResourceLoader.getResourceStream("#images/imagemap.properties"));
        }
        catch (Exception exception) {
            System.err.println("*** MISSING RESOURCE *** : imagemap.properties\r\n");
        }
    }

    public static URL getImageURL(String s) {
        String s1 = imageTable.getProperty(s);
        if (s1 == null) {
            System.err.println("*** missing image association: " + s);
            return null;
        }
        return ResourceLoader.getResourceURL(s1);
    }

    public static ImageIcon getImageIcon(String s) {
        URL url = ResourceLoader.getImageURL(s);
        if (url == null) {
            url = defaultFailImage;
        }
        return url != null ? new ImageIcon(url) : null;
    }

    public static ImageIcon getDefaultImageIcon(String s, String s1) {
        ImageIcon imageicon = (ImageIcon)UIManager.getIcon(s);
        if (imageicon == null) {
            imageicon = ResourceLoader.getImageIcon(s1);
        }
        return imageicon;
    }

    public static InputStream getResourceStream(String s) throws IOException {
        URL url = ResourceLoader.getResourceURL(s);
        if (url == null) {
            return null;
        }
        return url.openStream();
    }

    public static URL getResourceURL(String s) {
        URL url = null;
        if (s == null) {
            throw new IllegalArgumentException("path = null");
        }
        if (s.startsWith("#")) {
            for (int i = 0; i < resPaths.size() && url == null; ++i) {
                String s1 = (String)resPaths.get(i) + s.substring(1);
                url = ResourceLoader.class.getClassLoader().getResource(s1);
            }
        } else {
            url = ResourceLoader.class.getClassLoader().getResource(s);
        }
        if (url == null) {
            System.err.println("*** failed locating resource: " + s);
            return null;
        }
        return url;
    }

    public static String[] getResourcePaths() {
        Object[] aobj = resPaths.toArray();
        String[] as = new String[aobj.length];
        for (int i = 0; i < aobj.length; ++i) {
            as[i] = (String)aobj[i];
        }
        return as;
    }

    static {
        resPaths = new LinkedList();
        bundleTable = new Hashtable();
    }
}

