/*
 * Decompiled with CFR 0.152.
 */
package jehep.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import jehep.ui.SetEnv;

public class JarDownloader
extends JDialog {
    private String site;
    private String filename;
    private JFrame win;
    private String dirtocopy;
    private float Percent = 0.0f;
    private Thread trun;
    private JProgressBar current;

    public JarDownloader(JFrame win) {
        this.win = win;
        this.setDefaultCloseOperation(2);
        this.setTitle("Download dialog");
        this.setModal(true);
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min(200, res.width), Math.min(250, res.height));
        this.setSize(size);
        JPanel topPanel = new JPanel();
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(200, 35));
        JButton closeButton = new JButton();
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JarDownloader.this.trun = null;
                JarDownloader.this.setVisible(false);
                JarDownloader.this.dispose();
            }
        });
        this.current = new JProgressBar(0, 100);
        this.current.setSize(150, 40);
        this.current.setStringPainted(true);
        topPanel.add(this.current);
        lowerPanel.add(closeButton);
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        this.setVisible(true);
    }

    public void downloader(String site, String filename, String dirtocopy) {
        this.site = site;
        this.filename = filename;
        this.dirtocopy = dirtocopy;
        this.current.setValue(0);
        this.downloadJar();
    }

    public void downloadJar() {
        try {
            URL url = new URL(this.site);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            int filesize = connection.getContentLength();
            float totalDataRead = 0.0f;
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            FileOutputStream fos = new FileOutputStream(this.dirtocopy + SetEnv.fSep + this.filename);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
            byte[] data = new byte[1024];
            int i = 0;
            while ((i = in.read(data, 0, 1024)) >= 0) {
                bout.write(data, 0, i);
                this.Percent = (totalDataRead += (float)i) * 100.0f / (float)filesize;
                this.current.setValue((int)this.Percent);
            }
            bout.close();
            in.close();
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception e) {
            JOptionPane.showConfirmDialog(null, e.getMessage(), "Error", -1);
        }
    }
}

