/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui.codeview;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class Py2html {
    private String sourceFile = null;
    private String sourceCode = null;
    private String htmlcode;
    private List<String> comments;
    private Vector<String> keyw;
    private static final String[] keywords = new String[]{"range", "xrange", "in", "if", "from", "throw", "boolean", "do", "implements", "protected", "throws", "break", "double", "import", "public", "def", "pass", "else", "elseif", "return", "try", "global", "except", "int", "short", "elif", "catch", "final", "with", "raise", "exec", "char", "del", "long", "print", "while", "class", "float", "native", "switch", "or", "for", "as", "not", "continue", "goto", "package", "and"};
    private static int tabsize = 4;
    private static String bgcolor = "FFFFFF";
    private static String txcolor = "000000";
    private static String kwcolor = "3333FF";
    private static String cmcolor = "009900";
    private static String c2color = "999999";
    private static String stcolor = "FF0000";

    public Py2html(String source, boolean isFile) {
        if (isFile) {
            this.sourceFile = source;
            this.sourceCode = null;
        } else {
            this.sourceCode = source;
            this.sourceFile = null;
        }
        this.comments = new ArrayList<String>();
        this.keyw = new Vector();
        for (int i = 0; i < keywords.length; ++i) {
            this.keyw.addElement(keywords[i]);
        }
    }

    public void convert() throws IOException {
        int inx2;
        int inx1;
        String str;
        String txt = "";
        int cc = 0;
        String comm = " ";
        boolean multicomment = false;
        int N = 0;
        if (this.sourceCode != null && this.sourceFile == null) {
            String[] lines = this.sourceCode.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                str = lines[i];
                inx1 = str.indexOf("\"\"\"");
                if (inx1 < 0) {
                    inx1 = str.indexOf("'''");
                }
                if (inx1 > -1 && !multicomment) {
                    comm = str.substring(inx1 + 3, str.length());
                    inx2 = comm.indexOf("\"\"\"", inx1 + 3);
                    if (inx2 < 0) {
                        inx2 = comm.indexOf("'''", inx1 + 3);
                    }
                    if (inx2 > -1) {
                        comm = comm.substring(0, inx2);
                        this.comments.add(comm);
                        ++cc;
                        multicomment = false;
                    }
                    txt = txt + "$\n";
                    if (inx2 < 0) {
                        ++cc;
                        multicomment = true;
                    }
                } else if (inx1 > -1 && multicomment) {
                    comm = comm + str.substring(0, inx1) + " ";
                    this.comments.add(comm);
                    multicomment = false;
                } else if (inx1 < 0 && multicomment) {
                    comm = comm + str + " ";
                } else if (!multicomment) {
                    txt = txt + str + "\n";
                }
                ++N;
            }
        }
        if (this.sourceFile != null) {
            FileReader ino = new FileReader(this.sourceFile);
            try {
                BufferedReader ib = new BufferedReader(ino);
                while ((str = ib.readLine()) != null) {
                    inx1 = str.indexOf("\"\"\"");
                    if (inx1 < 0) {
                        inx1 = str.indexOf("'''");
                    }
                    if (inx1 > -1 && !multicomment) {
                        comm = str.substring(inx1 + 3, str.length());
                        inx2 = comm.indexOf("\"\"\"", inx1 + 3);
                        if (inx2 < 0) {
                            inx2 = comm.indexOf("'''", inx1 + 3);
                        }
                        if (inx2 > -1) {
                            comm = comm.substring(0, inx2);
                            this.comments.add(comm);
                            ++cc;
                            multicomment = false;
                        }
                        txt = txt + "$\n";
                        if (inx2 < 0) {
                            ++cc;
                            multicomment = true;
                        }
                    } else if (inx1 > -1 && multicomment) {
                        comm = comm + str.substring(0, inx1) + " ";
                        this.comments.add(comm);
                        multicomment = false;
                    } else if (inx1 < 0 && multicomment) {
                        comm = comm + str + " ";
                    } else if (!multicomment) {
                        txt = txt + str + "\n";
                    }
                    ++N;
                }
                ib.close();
            }
            catch (IOException ib) {
                // empty catch block
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(txt.getBytes());
        this.htmlcode = "<html>\n<head>\n<title>";
        this.htmlcode = this.htmlcode + "</title>\n</head>\n<body ";
        this.htmlcode = this.htmlcode + "bgcolor=\"" + bgcolor + "\" ";
        this.htmlcode = this.htmlcode + "text=\"" + txcolor + "\">\n";
        this.htmlcode = this.htmlcode + "<div class=\"jycode\"><pre>\n";
        StringBuffer buf = new StringBuffer(2048);
        int c = 0;
        int kwl = 0;
        int bufl = 0;
        int nexttolast = 0;
        int ch = 0;
        int lastch = 0;
        int s_normal = 0;
        int s_string = 1;
        int s_char = 2;
        int s_comline = 3;
        int s_comment = 4;
        int state = s_normal;
        block16: while (c != -1) {
            c = ((InputStream)in).read();
            nexttolast = lastch;
            lastch = ch;
            int n = ch = c >= 0 ? (int)c : 0;
            if (state == s_normal) {
                if (kwl == 0 && Character.isJavaIdentifierStart((char)ch) && !Character.isJavaIdentifierPart((char)lastch) || kwl > 0 && Character.isJavaIdentifierPart((char)ch)) {
                    buf.append((char)ch);
                    ++bufl;
                    ++kwl;
                    continue;
                }
                if (kwl > 0) {
                    String kw = buf.toString().substring(buf.length() - kwl);
                    if (this.keyw.contains(kw)) {
                        buf.insert(buf.length() - kwl, "<font color=\"" + kwcolor + "\">");
                        buf.append("</font>");
                    }
                    kwl = 0;
                }
            }
            switch (ch) {
                case 38: {
                    buf.append("&amp;");
                    ++bufl;
                    continue block16;
                }
                case 34: {
                    buf.append("&quot;");
                    ++bufl;
                    if (state == s_normal) {
                        state = s_string;
                        buf.insert(buf.length() - "&quot;".length(), "<font color=\"" + stcolor + "\"><i>");
                        continue block16;
                    }
                    if (state != s_string || lastch == 92 && (lastch != 92 || nexttolast != 92)) continue block16;
                    buf.append("</i></font>");
                    state = s_normal;
                    continue block16;
                }
                case 39: {
                    buf.append("&quot;");
                    ++bufl;
                    if (state == s_normal) {
                        state = s_string;
                        buf.insert(buf.length() - "&quot;".length(), "<font color=\"" + stcolor + "\"><i>");
                        continue block16;
                    }
                    if (state != s_string || lastch == 92 && (lastch != 92 || nexttolast != 92)) continue block16;
                    buf.append("</i></font>");
                    state = s_normal;
                    continue block16;
                }
                case 35: {
                    buf.append("#");
                    ++bufl;
                    if (state == s_string || state == s_comline || state == s_comment) continue block16;
                    buf.insert(buf.length() - 1, "<font color=\"" + c2color + "\"><i>");
                    state = s_comline;
                    continue block16;
                }
                case 60: {
                    buf.append("&lt;");
                    ++bufl;
                    continue block16;
                }
                case 62: {
                    buf.append("&gt;");
                    ++bufl;
                    continue block16;
                }
                case 92: {
                    buf.append("\\");
                    ++bufl;
                    if (lastch == 92) {
                        nexttolast = 92;
                    }
                    if (lastch != 92 || state == s_string || state != s_char) continue block16;
                    continue block16;
                }
                case 9: {
                    int n2 = bufl / tabsize * tabsize + tabsize;
                    while (bufl < n2) {
                        buf.append(' ');
                        ++bufl;
                    }
                    continue block16;
                }
                case 10: 
                case 13: {
                    if (state == s_comline) {
                        buf.append("</i></font>");
                        state = s_normal;
                    }
                    buf.append((char)ch);
                    if (buf.length() >= 1024) {
                        this.htmlcode = this.htmlcode + buf.toString();
                        buf.setLength(0);
                    }
                    bufl = 0;
                    if (kwl != 0) {
                        kwl = 0;
                    }
                    if (state == s_normal || state == s_comment) continue block16;
                    state = s_normal;
                    continue block16;
                }
                case 0: {
                    if (c >= 0) break;
                    if (state == s_comline) {
                        buf.append("</font>");
                        state = s_normal;
                    }
                    this.htmlcode = this.htmlcode + buf.toString();
                    buf.setLength(0);
                    bufl = 0;
                    if (state != s_comment) continue block16;
                    buf.append("</font>");
                    state = s_normal;
                    continue block16;
                }
            }
            ++bufl;
            buf.append((char)ch);
        }
        this.htmlcode = this.htmlcode + "</pre></div>\n";
        this.htmlcode = this.htmlcode + "<p><div class=\"footer\">DataMelt. &copy; Free for non-commercial use.</div>";
        this.htmlcode = this.htmlcode + "\n</body>\n</html>";
        ((InputStream)in).close();
    }

    public List<String> getComments() {
        return this.comments;
    }

    public String getHTML() {
        return this.htmlcode;
    }
}

