/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui.codeview;

import java.awt.Font;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jehep.ui.SetEnv;
import jehep.ui.codeview.BrowserPanel;
import jehep.ui.codeview.Design;
import jehep.ui.codeview.Py2html;
import jehep.ui.codeview.StringTools;
import jehep.ui.mainGUI;

public class CodeToHtml {
    private String jycode;
    private int fSize;
    private Font font;
    private String CacheDir;
    private String currentpage;
    private mainGUI win;
    private BrowserPanel bpanel;

    public CodeToHtml(mainGUI win, String filename) {
        this.win = win;
        this.jycode = win.getText();
        this.fSize = 16;
        this.font = new Font("Arial", 0, this.fSize);
        this.CacheDir = SetEnv.DirPath + SetEnv.fSep + "cachedir" + SetEnv.fSep;
        this.currentpage = this.CacheDir + filename + ".html";
        File ff = new File(this.CacheDir);
        ff.setWritable(true);
    }

    public void run() {
        List<String> comments = null;
        String htmlcode = null;
        try {
            Py2html py2html = new Py2html(this.jycode, false);
            py2html.convert();
            comments = py2html.getComments();
            htmlcode = py2html.getHTML();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        ArrayList<String> commentsImg = new ArrayList<String>();
        for (int j = 0; j < comments.size(); ++j) {
            String text = comments.get(j);
            StringTools stool = new StringTools(text);
            List<String> tds = stool.substringsBetween("$$", "$$");
            List<String> img = stool.getImageFiles();
            for (int i = 0; i < img.size(); ++i) {
                String filename = this.CacheDir + img.get(i);
                String eq = tds.get(i);
                new Design(this.win, eq, filename, this.fSize + 1);
            }
            String out = stool.getOut();
            stool = new StringTools(out);
            List<String> tds1 = stool.substringsBetween("$", "$");
            List<String> img1 = stool.getImageFiles();
            for (int i = 0; i < img1.size(); ++i) {
                String filename = this.CacheDir + img1.get(i);
                String eq = tds1.get(i);
                new Design(this.win, eq, filename, this.fSize + 1);
            }
            out = stool.getOut();
            commentsImg.add(out);
        }
        String code = "";
        String[] temp_store = htmlcode.split("\n");
        int nn = 0;
        for (int j = 0; j < temp_store.length; ++j) {
            String line = temp_store[j];
            if (line.equals("$")) {
                String comme = (String)commentsImg.get(nn);
                code = code + "</pre><hr></div><div class=\"comment\">\n" + comme + "\n</div><div class=\"jycode\"><hr><pre>\n";
                ++nn;
                continue;
            }
            if (line.length() <= 0) continue;
            code = code + line + "\n";
        }
        try {
            FileWriter outFile = new FileWriter(this.currentpage);
            PrintWriter fout = new PrintWriter(outFile);
            fout.println(code);
            fout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void showBrowser(mainGUI win) {
        File file2 = new File(this.currentpage);
        URL url = null;
        try {
            url = file2.toURL();
            String initialPage = url.toString();
            this.bpanel = new BrowserPanel(initialPage, this.font, win);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public BrowserPanel getBrowserPanel() {
        return this.bpanel;
    }
}

