/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JTextArea;
import jehep.ui.HelpDialog;
import jehep.ui.mainGUI;

public class SmartButton
extends JButton {
    protected mainGUI win;
    private String statusHelp = "Type \"help()\" for help and \"test()\" to test BeanShell macros";
    private JTextArea textHelp;
    private int whatToDo = 1;
    private int codeType = 0;
    private int globalstatus = 1000 * this.whatToDo + this.codeType;
    private static Color GREEN = new Color(60, 180, 10);
    private static Color GREEN_OVER = new Color(10, 205, 110);
    private static Color RED = new Color(255, 155, 51);
    private static Color RED_OVER = new Color(255, 204, 150);
    private String consoletype = "BeanShell";
    private Color currentColor = Color.gray;
    private Color currentColor_over = Color.lightGray;
    private Color defaultColor = Color.gray;
    private Color defaultColor_over = Color.lightGray;

    public SmartButton(final mainGUI win) {
        this.win = win;
        this.setText("Ready");
        this.setPreferredSize(new Dimension(160, 24));
        this.setMinimumSize(new Dimension(80, 24));
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        this.currentColor = this.defaultColor = this.getBackground();
        this.currentColor_over = Color.lightGray;
        this.setToolTipText("Smart button, to get status, to run code and show help.");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmartButton.this.codeType = 0;
                if (SmartButton.this.whatToDo == 1) {
                    HelpDialog helpDialog = new HelpDialog(win, SmartButton.this.consoletype);
                } else if (SmartButton.this.whatToDo == 2) {
                    win.RunCommand();
                } else if (SmartButton.this.whatToDo == 3) {
                    // empty if block
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SmartButton.this.setBackground(SmartButton.this.currentColor_over);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SmartButton.this.setBackground(SmartButton.this.currentColor);
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setPaint(new GradientPaint(new Point(0, 0), this.getBackground(), new Point(0, this.getHeight() / 2), Color.WHITE));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight() / 2);
        g2.setPaint(new GradientPaint(new Point(0, this.getHeight() / 2), Color.WHITE, new Point(0, this.getHeight()), this.getBackground()));
        g2.fillRect(0, this.getHeight() / 2, this.getWidth(), this.getHeight());
        g2.dispose();
        super.paintComponent(g);
    }

    public void setCodeType(int code) {
        this.codeType = code;
    }

    public int getCodeType() {
        return this.codeType;
    }

    public void setWhatToDo(int whatToDo) {
        this.whatToDo = whatToDo;
    }

    public int whatHappens() {
        return this.whatToDo;
    }

    public void setPrepareToRun() {
        if (this.globalstatus != 1000 * this.whatToDo + this.codeType) {
            this.whatToDo = 2;
            this.globalstatus = 1000 * this.whatToDo + this.codeType;
            this.setBackground(GREEN);
            this.currentColor = GREEN;
            this.currentColor_over = GREEN_OVER;
            if (this.codeType == 1) {
                this.setText("Run BeanShell");
            } else {
                if (this.codeType == 2) {
                    this.setText("Run Java");
                    return;
                }
                if (this.codeType == 3) {
                    this.setText("Run Jython");
                    return;
                }
                if (this.codeType == 4) {
                    this.setText("Run Groovy");
                    return;
                }
                if (this.codeType == 5) {
                    this.setText("Run JRuby");
                    return;
                }
                if (this.codeType == 6) {
                    this.setText("Run JMathLab");
                    return;
                }
            }
        }
    }

    public void setDefault() {
        if (this.whatToDo != 1) {
            this.whatToDo = 1;
            this.currentColor = this.defaultColor;
            this.currentColor_over = this.defaultColor_over;
            this.setBackground(this.defaultColor);
            this.setText("Ready");
            this.repaint();
        }
    }

    public void setWaitingResult() {
        if (this.whatToDo != 3) {
            this.whatToDo = 3;
            this.setBackground(RED);
            this.currentColor = RED;
            this.currentColor_over = RED_OVER;
            this.setText("Running..");
            this.repaint();
        }
    }

    public void setStatusTab(int index) {
        this.setDefault();
        if (index == 0) {
            this.setText("BeanShell help");
            this.consoletype = "beanshell";
        }
        if (index == 1) {
            this.setText("Jython help");
            this.consoletype = "jython";
        }
        if (index == 2) {
            this.setText("jMathLab help");
            this.consoletype = "jmathlab";
        }
        if (index == 3) {
            this.setText("Output");
            this.consoletype = "output";
        }
    }
}

