/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import bsh.Interpreter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.OverlayLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jehep.shellbsh.JHEPConsole;
import jehep.shelljython.JyShell;
import jehep.ui.Constants;
import jehep.ui.Editor;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;
import jehep.utils.MessageConsolePanel;
import jmathlab.JPrompt;
import tabclose.CloseListener;
import tabclose.CloseTabbedPane;

public class PanelBottom
extends JPanel
implements MouseListener,
Constants {
    private mainGUI win;
    private CloseTabbedPane jtab;
    private JPanel clear1;
    private JPanel clear2;
    private JPanel clear3;
    private JPanel clear4;
    private JPanel clear5;
    private MessageConsolePanel mconsole;
    private JComponent jshell;
    private static final long serialVersionUID = 1L;
    private static long message_size = 0L;
    private JPrompt jmathlabConsole;
    private static boolean isRunning = false;

    public PanelBottom(final mainGUI win) {
        this.win = win;
        isRunning = false;
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        this.addMouseListener(this);
        this.setLayout(new OverlayLayout(this));
        this.jtab = new CloseTabbedPane(1);
        this.jtab.setFont(SetEnv.guiFont);
        this.clear1 = new JPanel();
        this.clear2 = new JPanel();
        this.clear3 = new JPanel();
        this.clear4 = new JPanel();
        this.clear1.setLayout(new BorderLayout());
        this.clear2.setLayout(new BorderLayout());
        this.clear3.setLayout(new BorderLayout());
        this.clear4.setLayout(new BorderLayout());
        this.jtab.addTab(" BeanShell ", this.clear1);
        this.jtab.addTab(" JythonShell ", this.clear2);
        this.jtab.addTab(" jMathLab ", this.clear3);
        this.jtab.addTab(" System Console ", this.clear4);
        this.jtab.addCloseListener(new CloseListener(){

            @Override
            public void closeOperation(MouseEvent e) {
                int tabNumber = PanelBottom.this.jtab.getOverTabIndex();
                if (tabNumber == 0) {
                    PanelBottom.this.RefreshBS();
                } else if (tabNumber == 1) {
                    PanelBottom.this.RefreshJS();
                } else if (tabNumber == 2) {
                    PanelBottom.this.RefreshJMathLab();
                } else if (tabNumber == 3) {
                    PanelBottom.this.RefreshMessageConsole();
                }
                if (!isRunning) {
                    win.getSmartButton().setDefault();
                    win.setStatusSmartButton(PanelBottom.this.jtab.getSelectedIndex());
                }
            }
        });
        SetEnv.win = win;
        SetEnv.isGuiLoaded = false;
        SetEnv.BSconsole = new JHEPConsole();
        SetEnv.BSin = new Interpreter(SetEnv.BSconsole);
        new Thread(SetEnv.BSin).start();
        SetEnv.iniBsh();
        this.clear1.add((Component)SetEnv.BSconsole, "Center");
        SetEnv.JConsole = new JyShell();
        SetEnv.iniJyShell();
        this.clear2.add((Component)SetEnv.JConsole, "Center");
        this.jmathlabConsole = new JPrompt();
        JTextPane textarea = this.jmathlabConsole.getTextArea();
        JScrollPane scroller = new JScrollPane(textarea);
        this.jmathlabConsole.setFontText(SetEnv.globalFont);
        this.clear3.add((Component)scroller, "Center");
        this.mconsole = new MessageConsolePanel();
        this.mconsole.setFont(SetEnv.globalFont);
        message_size = this.mconsole.getSize();
        this.clear4.add((Component)this.mconsole.getPanel(), "Center");
        ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();
        exec.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long new_message_size = PanelBottom.this.mconsole.getSize();
                if (new_message_size != message_size) {
                    message_size = new_message_size;
                    if (PanelBottom.this.jtab.getSelectedIndex() != 3) {
                        PanelBottom.this.jtab.setSelectedIndex(3);
                    }
                }
            }
        }, 0L, 3L, TimeUnit.SECONDS);
        this.jtab.repaint();
        SetEnv.isGuiLoaded = true;
        this.jtab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane pane = (JTabbedPane)evt.getSource();
                if (!isRunning && win.getSmartButton().whatHappens() != 3) {
                    int idx = pane.getSelectedIndex();
                    win.setStatusSmartButton(idx);
                }
            }
        });
        this.add(this.jtab);
    }

    public void RefreshMessageConsole() {
        this.mconsole.reload();
    }

    public void RefreshBS() {
        Thread t = new Thread("refreshing beanshell"){

            @Override
            public void run() {
                PanelBottom.this.clear1.remove(SetEnv.BSconsole);
                SetEnv.BSconsole = new JHEPConsole();
                SetEnv.BSin = new Interpreter(SetEnv.BSconsole);
                new Thread(SetEnv.BSin).start();
                SetEnv.iniBsh();
                PanelBottom.this.clear1.add(SetEnv.BSconsole);
                PanelBottom.this.jtab.repaint();
                System.gc();
            }
        };
        t.start();
    }

    public void RefreshJMathLab() {
        this.jmathlabConsole.clear();
        this.jmathlabConsole.setFontText(SetEnv.globalFont);
        System.gc();
    }

    public void RefreshJRuby() {
    }

    public void setTabIndex(int i) {
        this.jtab.setSelectedIndex(i);
    }

    public void RefreshJS() {
        Thread t = new Thread("refreshing jython"){

            @Override
            public void run() {
                if (SetEnv.JConsole != null) {
                    SetEnv.JConsole.clear();
                }
            }
        };
        t.start();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void Run(String s) {
        isRunning = true;
        this.win.getSmartButton().setWaitingResult();
        System.gc();
        this.jtab.setSelectedIndex(0);
        this.jtab.repaint();
        String ss = SetEnv.DirPath + SetEnv.fSep + "macros" + SetEnv.fSep + "user" + SetEnv.fSep + s;
        ss = "source(\"" + ss + "\");";
        if (SetEnv.OSsys.equals("windows")) {
            ss = ss.replace("\\", "\\\\");
        }
        SetEnv.BSconsole.Execute(ss);
        isRunning = false;
    }

    public void RunCommand() {
        isRunning = true;
        this.win.getSmartButton().setWaitingResult();
        if (Editor.DocName().endsWith(".py")) {
            this.jtab.setSelectedIndex(1);
            this.jtab.repaint();
            SetEnv.JyRunFile(Editor.DocName());
            isRunning = false;
            return;
        }
        if (Editor.DocName().endsWith(".rb")) {
            this.jtab.setSelectedIndex(3);
            this.jtab.repaint();
            String scriptname = Editor.getText();
            SetEnv.processJRubyMacro(scriptname);
            isRunning = false;
            return;
        }
        if (Editor.DocName().endsWith(".groovy") || Editor.DocName().endsWith(".gvy") || Editor.DocName().endsWith(".gy")) {
            this.jtab.setSelectedIndex(3);
            this.jtab.repaint();
            String scriptname = Editor.getText();
            SetEnv.processGroovyMacro(scriptname, this.mconsole);
            isRunning = false;
            return;
        }
        if (Editor.DocName().endsWith(".m")) {
            this.jtab.setSelectedIndex(2);
            this.jtab.repaint();
            this.jmathlabConsole.clear();
            this.jmathlabConsole.interpretFile(Editor.DocName());
            isRunning = false;
            return;
        }
        if (Editor.DocName().endsWith(".bsh")) {
            this.jtab.setSelectedIndex(0);
            this.jtab.repaint();
            String scriptname = Editor.DocName;
            if (SetEnv.OSsys.equals("windows")) {
                scriptname = scriptname.replace("\\", "\\\\");
            }
            String s = "source(\"" + scriptname + "\");";
            SetEnv.BSconsole.Execute(s);
            isRunning = false;
            return;
        }
        if (Editor.DocName().endsWith(".java")) {
            this.Run("run_javac.bsh");
            this.Run("run_java.bsh");
            isRunning = false;
            return;
        }
        isRunning = false;
        boolean succ = SetEnv.runDefaultCommands();
        if (succ) {
            return;
        }
    }

    class BuildJShell
    extends Thread {
        BuildJShell() {
        }

        @Override
        public void run() {
            SetEnv.JConsole = new JyShell();
            SetEnv.iniJyShell();
            PanelBottom.this.clear2.add((Component)SetEnv.JConsole, "Center");
            PanelBottom.this.jtab.repaint();
            SetEnv.isGuiLoaded = true;
        }
    }
}

