/*
 * Decompiled with CFR 0.152.
 */
package jehep.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;

public class ExampleDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton closeButton;
    private JButton runButton;
    private JButton openButton;
    private JScrollPane jScrollPane1;
    private final mainGUI win;
    private JTree jtree;
    private static HashMap<String, String> tooltips;
    private String[] rows;
    private String selected = "";
    private static final Icon leafIcon;
    private static final Icon closedIcon;
    private static final Icon openIcon;

    public ExampleDialog(final mainGUI win) {
        this.win = win;
        this.setDefaultCloseOperation(2);
        this.setModal(false);
        this.setResizable(true);
        win.setPromptTabIndex(1);
        final String path = SetEnv.DirPath + SetEnv.fSep + "macros" + SetEnv.fSep + "examples" + SetEnv.fSep;
        ArrayList<String[]> data = new ArrayList<String[]>();
        TreeSet<String> examplekeys = new TreeSet<String>();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(path + "examples.txt");
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                String[] words;
                if ((strLine = strLine.trim()).startsWith("#") || (words = strLine.split("\\u007c")).length <= 2) continue;
                String[] anArray = new String[3];
                examplekeys.add(words[0]);
                anArray[0] = words[0];
                anArray[1] = words[1];
                anArray[2] = words[2];
                data.add(anArray);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(400, 35));
        this.closeButton = new JButton();
        this.closeButton.setText("Exit");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExampleDialog.this.setVisible(false);
                ExampleDialog.this.dispose();
            }
        });
        this.runButton = new JButton();
        this.runButton.setText("Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ExampleDialog.this.selected.endsWith(".py")) {
                    String s1 = "run macros" + SetEnv.fSep + "examples" + SetEnv.fSep + ExampleDialog.this.selected;
                    SetEnv.showStatusBarText(s1);
                    SetEnv.JyRunFile(path + ExampleDialog.this.selected);
                } else {
                    JOptionPane.showMessageDialog(win, "Please select example file after clicking on the topic");
                }
            }
        });
        this.openButton = new JButton();
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ExampleDialog.this.selected.endsWith(".py")) {
                    String s1 = "open macros" + SetEnv.fSep + "examples" + SetEnv.fSep + ExampleDialog.this.selected;
                    SetEnv.showStatusBarText(s1);
                    win.open(path + ExampleDialog.this.selected, false);
                } else {
                    JOptionPane.showMessageDialog(win, "Please select example file after clicking on the topic");
                }
            }
        });
        tooltips = new HashMap();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
        for (String key : examplekeys) {
            DefaultMutableTreeNode topic = new DefaultMutableTreeNode(key);
            root.add(topic);
            for (String[] element : data) {
                if (!element[0].equals(key)) continue;
                DefaultMutableTreeNode entry = new DefaultMutableTreeNode(element[1]);
                topic.add(entry);
                tooltips.put(element[1], element[2]);
            }
        }
        JTree jtree = new JTree(root);
        jtree.setFont(SetEnv.guiFont);
        if (leafIcon != null) {
            ToolTipManager.sharedInstance().registerComponent(jtree);
        }
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)jtree.getCellRenderer();
        renderer.setClosedIcon(closedIcon);
        renderer.setOpenIcon(openIcon);
        renderer.setLeafIcon(leafIcon);
        jtree.setRootVisible(false);
        jtree.getSelectionModel().setSelectionMode(1);
        jtree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                ExampleDialog.this.selected = node.toString();
            }
        });
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.getViewport().add(jtree);
        lowerPanel.add((Component)this.openButton, null);
        lowerPanel.add((Component)this.runButton, null);
        lowerPanel.add((Component)this.closeButton, null);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        this.setTitle("DataMelt examples");
        Rectangle bounds = win.getBounds();
        int ww = bounds.width;
        int hh = bounds.height;
        int xx = bounds.x;
        int yy = bounds.y;
        this.setLocation(xx + (int)(0.1 * (double)ww), yy + (int)(0.1 * (double)hh));
        this.pack();
        this.setSize((int)(0.22 * (double)ww), (int)(0.6 * (double)hh));
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    static {
        leafIcon = new ImageIcon(ExampleDialog.class.getResource("images/python.png"));
        closedIcon = new ImageIcon(ExampleDialog.class.getResource("images/folderclosed.png"));
        openIcon = new ImageIcon(ExampleDialog.class.getResource("images/folderopen.png"));
    }

    private static class OwnRenderer
    extends DefaultTreeCellRenderer {
        Icon tutorialIcon;

        public OwnRenderer(Icon icon) {
            this.tutorialIcon = icon;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf) {
                this.setIcon(this.tutorialIcon);
                String tt = value.toString();
                String svalue = value.toString();
                if (tooltips.isEmpty()) {
                    this.setToolTipText(null);
                }
                this.setToolTipText((String)tooltips.get(svalue));
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

