/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class LATTokenMarker
extends TokenMarker {
    private static KeywordMap latKeywords;
    private KeywordMap keywords = LATTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        block16: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            switch (token) {
                case 0: {
                    switch (c) {
                        case '{': {
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)2;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '/': {
                            this.doKeyword(line, i, c);
                            if (length - i <= 1 || array[i1] != '/') continue block16;
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            this.lastOffset = this.lastKeyword = length;
                            break block16;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '#': {
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(1, (byte)7);
                            this.lastOffset = this.lastKeyword = i1;
                            break;
                        }
                        default: {
                            if (Character.isLetterOrDigit(c) || c == '_') continue block16;
                            this.doKeyword(line, i, c);
                            break;
                        }
                    }
                    continue block16;
                }
                case 2: {
                    if (c != '}') continue block16;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block16;
                }
                case 3: {
                    if (c != '\"') continue block16;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block16;
                }
                case 4: {
                    if (c != '\'') continue block16;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block16;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (latKeywords == null) {
            latKeywords = new KeywordMap(true);
            latKeywords.add("specification", (byte)9);
            latKeywords.add("realisation", (byte)9);
            latKeywords.add("constantes", (byte)9);
            latKeywords.add("types", (byte)9);
            latKeywords.add("<-", (byte)7);
            latKeywords.add("alors", (byte)6);
            latKeywords.add("autrement", (byte)6);
            latKeywords.add("booleen", (byte)8);
            latKeywords.add("boucle", (byte)6);
            latKeywords.add("caractere", (byte)8);
            latKeywords.add("cas", (byte)6);
            latKeywords.add("chaine", (byte)8);
            latKeywords.add("dans", (byte)6);
            latKeywords.add("de", (byte)6);
            latKeywords.add("div", (byte)7);
            latKeywords.add("ecrire", (byte)6);
            latKeywords.add("ecrire_ligne", (byte)6);
            latKeywords.add("enregistrement", (byte)8);
            latKeywords.add("ensemble", (byte)8);
            latKeywords.add("entier", (byte)8);
            latKeywords.add("et", (byte)7);
            latKeywords.add("etpuis", (byte)7);
            latKeywords.add("faire", (byte)6);
            latKeywords.add("fait", (byte)6);
            latKeywords.add("faux", (byte)4);
            latKeywords.add("fin", (byte)6);
            latKeywords.add("finselon", (byte)6);
            latKeywords.add("finsi", (byte)6);
            latKeywords.add("jusqua", (byte)6);
            latKeywords.add("lire", (byte)6);
            latKeywords.add("lire_ligne", (byte)6);
            latKeywords.add("liste", (byte)8);
            latKeywords.add("mod", (byte)7);
            latKeywords.add("non", (byte)7);
            latKeywords.add("ou", (byte)7);
            latKeywords.add("oubien", (byte)7);
            latKeywords.add("pour", (byte)6);
            latKeywords.add("reel", (byte)8);
            latKeywords.add("repeter", (byte)6);
            latKeywords.add("retour", (byte)6);
            latKeywords.add("retourne", (byte)6);
            latKeywords.add("selon", (byte)6);
            latKeywords.add("si", (byte)6);
            latKeywords.add("sinon", (byte)6);
            latKeywords.add("sortirsi", (byte)6);
            latKeywords.add("tableau", (byte)8);
            latKeywords.add("tantque", (byte)6);
            latKeywords.add("vrai", (byte)4);
        }
        return latKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

