/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.SyntaxUtilities;
import jehep.syntax.TokenMarker;

public class FortranTokenMarker
extends TokenMarker {
    private static final int MAYBE_KEYWORD_FIRST = 100;
    private static final int MAYBE_KEYWORD_MORE = 101;
    private static final String S_E_P = "START EDIT PAGE";
    private static KeywordMap fortranKeywords;
    private KeywordMap keywords = FortranTokenMarker.getKeywords();
    private int lastOffset;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int i;
        byte lastLineToken = token;
        if (line.count < 1) {
            return lastLineToken;
        }
        char[] array = line.array;
        int offset = line.offset;
        char c = array[offset];
        if (c == 'C' || c == 'c' || c == '*') {
            this.addToken(line.count, (byte)1);
            return lastLineToken;
        }
        token = 0;
        int lineEnd = offset + line.count;
        int limit = Math.min(lineEnd, offset + 5);
        for (i = offset; i < limit; ++i) {
            c = array[i];
            if (c == '@') {
                this.guardedAddToken(i - offset, token);
                this.addToken(lineEnd - i, (byte)2);
                return lastLineToken;
            }
            if (token != 0 || '0' > c || c > '9') continue;
            token = (byte)5;
        }
        this.addToken(limit - offset, token);
        if (limit == lineEnd) {
            return 0;
        }
        c = array[i];
        if (c == '@') {
            this.addToken(lineEnd - i, (byte)2);
            return 0;
        }
        if (c == ' ') {
            this.addToken(1, (byte)0);
            token = 0;
        } else {
            this.addToken(1, (byte)5);
            token = lastLineToken;
        }
        if (lineEnd == offset + 6) {
            return 0;
        }
        limit = Math.min(offset + 72, lineEnd);
        this.lastOffset = offset + 6;
        if (this.checkStartEditPage(line)) {
            this.addToken(limit - this.lastOffset, (byte)5);
            return 0;
        }
        block8: for (i = this.lastOffset; i < limit; ++i) {
            int i1 = i + 1;
            c = array[i];
            if (token == 3) {
                if (c != '\'') continue;
                this.addToken(i1 - this.lastOffset, (byte)3);
                token = 0;
                this.lastOffset = i1;
                continue;
            }
            if (c == '@') {
                this.guardedAddToken(i - this.lastOffset, token);
                this.addToken(lineEnd - i, (byte)2);
                return token;
            }
            if (token == 0) {
                switch (c) {
                    case '\'': {
                        this.guardedAddToken(i - this.lastOffset, token);
                        token = (byte)3;
                        this.lastOffset = i;
                        break;
                    }
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '/': 
                    case ':': 
                    case '=': {
                        this.guardedAddToken(i - this.lastOffset, token);
                        this.addToken(1, (byte)9);
                        this.lastOffset = i1;
                        break;
                    }
                    default: {
                        if (('A' > c || c > 'Z') && ('a' > c || c > 'z')) continue block8;
                        this.guardedAddToken(i - this.lastOffset, token);
                        token = (byte)100;
                        this.lastOffset = i;
                        break;
                    }
                }
                continue;
            }
            if (token == 100 || token == 101) {
                if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9' || c == '$') {
                    token = (byte)101;
                    continue;
                }
                this.doKeyword(line, i);
                c = array[i];
                switch (c) {
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '/': 
                    case ':': 
                    case '=': {
                        this.guardedAddToken(i - this.lastOffset, token);
                        this.addToken(1, (byte)9);
                        this.lastOffset = i1;
                    }
                }
                token = 0;
                continue;
            }
            throw new InternalError("Invalid state: " + token);
        }
        if (token == 100 || token == 101) {
            this.doKeyword(line, i);
            token = 0;
        } else {
            this.guardedAddToken(i - this.lastOffset, token);
        }
        if (limit == lineEnd) {
            return token;
        }
        this.guardedAddToken(lineEnd - i, (byte)2);
        return token;
    }

    private boolean checkStartEditPage(Segment line) {
        int i;
        if (line.count < 21) {
            return false;
        }
        int limit = line.offset + Math.min(line.count, 72);
        for (i = line.offset + 6; i < limit - 15 && line.array[i] == ' '; ++i) {
        }
        if (!SyntaxUtilities.regionMatches(false, line, i, S_E_P)) {
            return false;
        }
        i += 15;
        while (i < limit) {
            if (line.array[i] != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void doKeyword(Segment line, int keywordEnd) {
        int len = keywordEnd - this.lastOffset;
        if (len > 0) {
            byte id = this.keywords.lookup(line, this.lastOffset, len);
            this.addToken(len, id);
            this.lastOffset = keywordEnd;
        }
    }

    private void guardedAddToken(int len, byte token) {
        if (len > 0) {
            this.addToken(len, token);
        }
    }

    public static KeywordMap getKeywords() {
        if (fortranKeywords == null) {
            fortranKeywords = new KeywordMap(true);
            fortranKeywords.add("CALL", (byte)6);
            fortranKeywords.add("CLOSE", (byte)6);
            fortranKeywords.add("CONTINUE", (byte)6);
            fortranKeywords.add("DO", (byte)6);
            fortranKeywords.add("ELSE", (byte)6);
            fortranKeywords.add("ELSEIF", (byte)6);
            fortranKeywords.add("ENDIF", (byte)6);
            fortranKeywords.add("GOTO", (byte)6);
            fortranKeywords.add("GO TO", (byte)6);
            fortranKeywords.add("IF", (byte)6);
            fortranKeywords.add("INDEX", (byte)6);
            fortranKeywords.add("INQUIRE", (byte)6);
            fortranKeywords.add("OPEN", (byte)6);
            fortranKeywords.add("PRINT", (byte)6);
            fortranKeywords.add("READ", (byte)6);
            fortranKeywords.add("RETURN", (byte)6);
            fortranKeywords.add("THEN", (byte)6);
            fortranKeywords.add("WRITE", (byte)6);
            fortranKeywords.add("BLOCK DATA", (byte)7);
            fortranKeywords.add("COMPILER", (byte)7);
            fortranKeywords.add("END", (byte)7);
            fortranKeywords.add("ENTRY", (byte)7);
            fortranKeywords.add("FUNCTION", (byte)7);
            fortranKeywords.add("INCLUDE", (byte)7);
            fortranKeywords.add("SUBROUTINE", (byte)7);
            fortranKeywords.add("CHARACTER", (byte)8);
            fortranKeywords.add("DATA", (byte)8);
            fortranKeywords.add("DEFINE", (byte)8);
            fortranKeywords.add("EQUIVALENCE", (byte)8);
            fortranKeywords.add("IMPLICIT", (byte)8);
            fortranKeywords.add("INTEGER", (byte)8);
            fortranKeywords.add("LOGICAL", (byte)8);
            fortranKeywords.add("PARAMETER", (byte)8);
            fortranKeywords.add("REAL", (byte)8);
            fortranKeywords.add("COMMON", (byte)7);
            fortranKeywords.add("Save", (byte)7);
            fortranKeywords.add("PROGRAM", (byte)6);
            fortranKeywords.add("ENDDO", (byte)6);
            fortranKeywords.add(".AND.", (byte)9);
            fortranKeywords.add(".EQ.", (byte)9);
            fortranKeywords.add(".NE.", (byte)9);
            fortranKeywords.add(".NOT.", (byte)9);
            fortranKeywords.add(".OR.", (byte)9);
            fortranKeywords.add("+", (byte)9);
            fortranKeywords.add("-", (byte)9);
            fortranKeywords.add("*", (byte)9);
            fortranKeywords.add("**", (byte)9);
            fortranKeywords.add("/", (byte)9);
            fortranKeywords.add(".FALSE.", (byte)4);
            fortranKeywords.add(".TRUE.", (byte)4);
        }
        return fortranKeywords;
    }
}

