/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class DawnTokenMarker
extends TokenMarker {
    private static KeywordMap dawnKeywords;
    private KeywordMap keywords = DawnTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        block14: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)1);
                            token = 0;
                            this.lastOffset = this.lastKeyword = length;
                            break block14;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ' ': {
                            this.doKeyword(line, i, c);
                        }
                    }
                    continue block14;
                }
                case 3: {
                    if (c != '\"') continue block14;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block14;
                }
                case 4: {
                    if (c != '\'') continue block14;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block14;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (dawnKeywords == null) {
            dawnKeywords = new KeywordMap(false);
            dawnKeywords.add("do", (byte)6);
            dawnKeywords.add("loop", (byte)6);
            dawnKeywords.add("until", (byte)6);
            dawnKeywords.add("for", (byte)6);
            dawnKeywords.add("next", (byte)6);
            dawnKeywords.add("if", (byte)6);
            dawnKeywords.add("then", (byte)6);
            dawnKeywords.add("else", (byte)6);
            dawnKeywords.add("end", (byte)6);
            dawnKeywords.add("while", (byte)6);
            dawnKeywords.add("repeat", (byte)6);
            dawnKeywords.add("wend", (byte)6);
            dawnKeywords.add("try", (byte)6);
            dawnKeywords.add("catch", (byte)6);
            dawnKeywords.add("err", (byte)6);
            dawnKeywords.add("exit", (byte)7);
            dawnKeywords.add("needs", (byte)7);
            dawnKeywords.add("needsGlobal", (byte)7);
            dawnKeywords.add("array", (byte)8);
            dawnKeywords.add("->", (byte)8);
            dawnKeywords.add("->lit", (byte)8);
            dawnKeywords.add("lit->", (byte)8);
            dawnKeywords.add("->str", (byte)8);
            dawnKeywords.add("str->", (byte)8);
            dawnKeywords.add("sto", (byte)8);
            dawnKeywords.add("rcl", (byte)8);
            dawnKeywords.add("function", (byte)8);
            dawnKeywords.add("endFunction", (byte)8);
            dawnKeywords.add("global", (byte)8);
            dawnKeywords.add("endGlobal", (byte)8);
            dawnKeywords.add("e", (byte)4);
            dawnKeywords.add("pi", (byte)4);
            dawnKeywords.add("null", (byte)4);
            dawnKeywords.add("and", (byte)9);
            dawnKeywords.add("&", (byte)9);
            dawnKeywords.add("or", (byte)9);
            dawnKeywords.add("xor", (byte)9);
            dawnKeywords.add("|", (byte)9);
        }
        return dawnKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

