/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;
import jehep.ui.SetEnv;

public class CXXTokenMarker
extends TokenMarker {
    public static final String METHOD_DELIMITERS = " \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?@";
    private static KeywordMap cxxKeywords;
    protected boolean cpp;
    protected boolean javadoc;
    protected KeywordMap keywords;
    protected int lastOffset;
    protected int lastKeyword;
    protected int lastWhitespace;

    public CXXTokenMarker() {
        this(true, false, CXXTokenMarker.getKeywords());
        this.cpp = false;
        this.javadoc = false;
    }

    public CXXTokenMarker(boolean cpp, boolean javadoc, KeywordMap keywords) {
        this.cpp = cpp;
        this.javadoc = javadoc;
        this.keywords = keywords;
        cpp = false;
        javadoc = false;
    }

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        block21: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (!this.cpp) continue block21;
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)7);
                            this.lastOffset = this.lastKeyword = length;
                            break block21;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                backslash = false;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block21;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block21;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (this.javadoc && length - i > 2 && array[i + 2] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    token = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.addToken(length - i, (byte)1);
                                    this.lastOffset = this.lastKeyword = length;
                                    break block21;
                                }
                            }
                            continue block21;
                        }
                        default: {
                            backslash = false;
                            if (!Character.isLetterOrDigit(c) && c != '_') {
                                this.doKeyword(line, i, c);
                            }
                            if (METHOD_DELIMITERS.indexOf(c) == -1) continue block21;
                            this.lastWhitespace = i;
                            break;
                        }
                    }
                    continue block21;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block21;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    continue block21;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\"') continue block21;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block21;
                    }
                    if (c != '\'') continue block21;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    continue block21;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (cxxKeywords == null) {
            cxxKeywords = new KeywordMap(false);
            cxxKeywords.add("and", (byte)8);
            cxxKeywords.add("and_eq", (byte)8);
            cxxKeywords.add("asm", (byte)7);
            cxxKeywords.add("auto", (byte)6);
            cxxKeywords.add("bitand", (byte)8);
            cxxKeywords.add("bitor", (byte)8);
            cxxKeywords.add("bool", (byte)8);
            cxxKeywords.add("break", (byte)6);
            cxxKeywords.add("case", (byte)6);
            cxxKeywords.add("catch", (byte)6);
            cxxKeywords.add("char", (byte)8);
            cxxKeywords.add("class", (byte)8);
            cxxKeywords.add("compl", (byte)8);
            cxxKeywords.add("const", (byte)6);
            cxxKeywords.add("const_cast", (byte)8);
            cxxKeywords.add("continue", (byte)6);
            cxxKeywords.add("default", (byte)6);
            cxxKeywords.add("delete", (byte)6);
            cxxKeywords.add("cout", (byte)6);
            cxxKeywords.add("endl", (byte)6);
            cxxKeywords.add("std", (byte)6);
            cxxKeywords.add("ofstream", (byte)6);
            cxxKeywords.add("ifstream", (byte)6);
            cxxKeywords.add("fopen", (byte)6);
            cxxKeywords.add("fclose", (byte)6);
            cxxKeywords.add("close", (byte)6);
            cxxKeywords.add("sprintf", (byte)6);
            cxxKeywords.add("printf", (byte)6);
            cxxKeywords.add("strcmp", (byte)6);
            cxxKeywords.add("getline", (byte)6);
            cxxKeywords.add("ignore", (byte)6);
            cxxKeywords.add("get", (byte)6);
            cxxKeywords.add("read", (byte)6);
            cxxKeywords.add("peek", (byte)6);
            cxxKeywords.add("string", (byte)8);
            cxxKeywords.add("vector", (byte)8);
            cxxKeywords.add("do", (byte)6);
            cxxKeywords.add("double", (byte)8);
            cxxKeywords.add("dynamic_cast", (byte)8);
            cxxKeywords.add("else", (byte)6);
            cxxKeywords.add("enum", (byte)8);
            cxxKeywords.add("explicit", (byte)6);
            cxxKeywords.add("export", (byte)7);
            cxxKeywords.add("extern", (byte)7);
            cxxKeywords.add("false", (byte)4);
            cxxKeywords.add("float", (byte)8);
            cxxKeywords.add("Int_t", (byte)8);
            cxxKeywords.add("for", (byte)6);
            cxxKeywords.add("friend", (byte)6);
            cxxKeywords.add("goto", (byte)6);
            cxxKeywords.add("if", (byte)6);
            cxxKeywords.add("inline", (byte)6);
            cxxKeywords.add("int", (byte)8);
            cxxKeywords.add("long", (byte)8);
            cxxKeywords.add("mutable", (byte)8);
            cxxKeywords.add("namespace", (byte)8);
            cxxKeywords.add("not", (byte)8);
            cxxKeywords.add("not_eq", (byte)8);
            cxxKeywords.add("operator", (byte)8);
            cxxKeywords.add("or", (byte)8);
            cxxKeywords.add("or_eq", (byte)8);
            cxxKeywords.add("private", (byte)6);
            cxxKeywords.add("protected", (byte)6);
            cxxKeywords.add("public", (byte)6);
            cxxKeywords.add("register", (byte)6);
            cxxKeywords.add("reinterpret_cast", (byte)8);
            cxxKeywords.add("return", (byte)6);
            cxxKeywords.add("short", (byte)8);
            cxxKeywords.add("signed", (byte)8);
            cxxKeywords.add("sizeof", (byte)6);
            cxxKeywords.add("static", (byte)6);
            cxxKeywords.add("static_cast", (byte)8);
            cxxKeywords.add("struct", (byte)8);
            cxxKeywords.add("switch", (byte)6);
            cxxKeywords.add("template", (byte)8);
            cxxKeywords.add("this", (byte)4);
            cxxKeywords.add("throw", (byte)6);
            cxxKeywords.add("true", (byte)4);
            cxxKeywords.add("try", (byte)6);
            cxxKeywords.add("typedef", (byte)8);
            cxxKeywords.add("typeid", (byte)8);
            cxxKeywords.add("typename", (byte)8);
            cxxKeywords.add("union", (byte)8);
            cxxKeywords.add("unsigned", (byte)8);
            cxxKeywords.add("using", (byte)7);
            cxxKeywords.add("virtual", (byte)6);
            cxxKeywords.add("void", (byte)6);
            cxxKeywords.add("volatile", (byte)6);
            cxxKeywords.add("wchar_t", (byte)8);
            cxxKeywords.add("while", (byte)6);
            cxxKeywords.add("xor", (byte)8);
            cxxKeywords.add("xor_eq", (byte)8);
            cxxKeywords.add("NULL", (byte)4);
            cxxKeywords.add("new", (byte)11);
            cxxKeywords.add("#include", (byte)9);
            cxxKeywords.add("#define", (byte)11);
            cxxKeywords.add("#undef", (byte)11);
            cxxKeywords.add("#ifndef", (byte)11);
            cxxKeywords.add("#endif", (byte)11);
            cxxKeywords.add("#else", (byte)11);
            cxxKeywords.add("#if", (byte)11);
            cxxKeywords.add("#elif", (byte)11);
            cxxKeywords.add("#efined", (byte)11);
            cxxKeywords.add("#line", (byte)11);
            cxxKeywords.add("#error", (byte)11);
            cxxKeywords.add("#pragma", (byte)11);
            cxxKeywords.add("Double_t", (byte)8);
            cxxKeywords.add("Float_t", (byte)8);
            cxxKeywords.add("Int_t", (byte)8);
            cxxKeywords.add("UInt_t", (byte)8);
            cxxKeywords.add("Char_t", (byte)8);
            cxxKeywords.add("Bool_t", (byte)8);
            cxxKeywords.add("Short_t", (byte)8);
            cxxKeywords.add("Long64_t", (byte)8);
            cxxKeywords.add("ULong64_t", (byte)8);
            cxxKeywords.add("Double32_t", (byte)8);
            cxxKeywords.add("gROOT", (byte)6);
            cxxKeywords.add("gStyle", (byte)6);
            cxxKeywords.add("gPad", (byte)6);
            cxxKeywords.add("gSystem", (byte)6);
            cxxKeywords.add("gRandom", (byte)6);
            cxxKeywords.add("gBenchmark", (byte)6);
            cxxKeywords.add("gMinuit", (byte)6);
            cxxKeywords.add("gEnv", (byte)6);
            cxxKeywords.add("gDirectory", (byte)6);
            cxxKeywords.add("gFile", (byte)6);
            cxxKeywords.add("gHTML", (byte)6);
            CXXTokenMarker.ReadRoot();
        }
        return cxxKeywords;
    }

    private static void ReadRoot() {
        String thisLine;
        BufferedReader in;
        String sd1 = SetEnv.DirPath + File.separator + "syntax" + File.separator + "root" + File.separator + "classes.d";
        try {
            in = new BufferedReader(new FileReader(sd1));
            while ((thisLine = in.readLine()) != null) {
                if (thisLine.length() <= 1) continue;
                cxxKeywords.add(thisLine, (byte)6);
            }
        }
        catch (Exception e) {
            System.out.println("Error in reading:" + sd1);
        }
        sd1 = SetEnv.DirPath + File.separator + "syntax" + File.separator + "root" + File.separator + "methods.d";
        try {
            in = new BufferedReader(new FileReader(sd1));
            while ((thisLine = in.readLine()) != null) {
                if (thisLine.length() <= 1) continue;
                cxxKeywords.add(thisLine, (byte)7);
            }
        }
        catch (Exception e) {
            System.out.println("Error in reading " + sd1);
        }
    }

    protected boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
            this.lastKeyword = i1;
            this.lastWhitespace = i;
            return true;
        }
        this.lastKeyword = i1;
        return false;
    }
}

