/*
 * Decompiled with CFR 0.152.
 */
package jehep.syntax;

import javax.swing.text.Segment;
import jehep.syntax.KeywordMap;
import jehep.syntax.TokenMarker;

public class CSharpTokenMarker
extends TokenMarker {
    public static final byte VERBATIM_STRING = 101;
    private static KeywordMap cKeywords;
    private KeywordMap keywords = CSharpTokenMarker.getKeywords();
    private int lastOffset;
    private int lastKeyword;
    private int lastWhitespace;

    @Override
    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        this.lastWhitespace = offset - 1;
        boolean backslash = false;
        block25: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
                continue;
            }
            switch (token) {
                case 0: {
                    switch (c) {
                        case '(': {
                            if (backslash) {
                                this.doKeyword(line, i, c);
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(this.lastWhitespace - this.lastOffset + 1, token);
                            this.addToken(i - this.lastWhitespace - 1, (byte)11);
                            this.addToken(1, (byte)0);
                            token = 0;
                            this.lastOffset = this.lastKeyword = i1;
                            this.lastWhitespace = i;
                            break;
                        }
                        case '#': {
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            if (this.doKeyword(line, i, c)) break;
                            this.addToken(i - this.lastOffset, token);
                            this.addToken(length - i, (byte)7);
                            this.lastOffset = this.lastKeyword = length;
                            break block25;
                        }
                        case '\"': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)3;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case '@': {
                            if (length - i <= 1 || array[i1] != '\"') continue block25;
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)101;
                            this.lastOffset = this.lastKeyword = i++;
                            break;
                        }
                        case '\'': {
                            this.doKeyword(line, i, c);
                            if (backslash) {
                                backslash = false;
                                break;
                            }
                            this.addToken(i - this.lastOffset, token);
                            token = (byte)4;
                            this.lastOffset = this.lastKeyword = i;
                            break;
                        }
                        case ':': {
                            if (this.lastKeyword == offset) {
                                if (this.doKeyword(line, i, c)) break;
                                backslash = false;
                                this.addToken(i1 - this.lastOffset, (byte)5);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            if (!this.doKeyword(line, i, c)) continue block25;
                            break;
                        }
                        case '/': {
                            backslash = false;
                            this.doKeyword(line, i, c);
                            if (length - i <= 1) continue block25;
                            switch (array[i1]) {
                                case '*': {
                                    this.addToken(i - this.lastOffset, token);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (length - i > 2 && array[i + 2] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    token = 1;
                                    break;
                                }
                                case '/': {
                                    this.addToken(i - this.lastOffset, token);
                                    if (length - i > 2) {
                                        this.addToken(length - i, (byte)2);
                                    } else {
                                        this.addToken(length - i, (byte)1);
                                    }
                                    this.lastOffset = this.lastKeyword = length;
                                    break block25;
                                }
                            }
                            continue block25;
                        }
                        default: {
                            backslash = false;
                            if (!Character.isLetterOrDigit(c) && c != '_') {
                                this.doKeyword(line, i, c);
                            }
                            if (" \t~!%^*()-+=|\\#/{}[]:;\"'<>,.?@".indexOf(c) == -1) continue block25;
                            this.lastWhitespace = i;
                            break;
                        }
                    }
                    continue block25;
                }
                case 1: 
                case 2: {
                    backslash = false;
                    if (c != '*' || length - i <= 1 || array[i1] != '/') continue block25;
                    this.addToken(++i + 1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i + 1;
                    this.lastWhitespace = i;
                    continue block25;
                }
                case 101: {
                    if (backslash) {
                        backslash = false;
                        continue block25;
                    }
                    if (c != '\"') continue block25;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    continue block25;
                }
                case 3: {
                    if (backslash) {
                        backslash = false;
                        continue block25;
                    }
                    if (c != '\"') continue block25;
                    this.addToken(i1 - this.lastOffset, token);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    continue block25;
                }
                case 4: {
                    if (backslash) {
                        backslash = false;
                        continue block25;
                    }
                    if (c != '\'') continue block25;
                    this.addToken(i1 - this.lastOffset, (byte)3);
                    token = 0;
                    this.lastOffset = this.lastKeyword = i1;
                    this.lastWhitespace = i;
                    continue block25;
                }
                default: {
                    throw new InternalError("Invalid state: " + token);
                }
            }
        }
        if (token == 0) {
            this.doKeyword(line, length, '\u0000');
        }
        switch (token) {
            case 101: {
                this.addToken(length - this.lastOffset, (byte)3);
                break;
            }
            case 3: 
            case 4: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, token);
                if (!backslash) {
                    token = 0;
                }
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    public static KeywordMap getKeywords() {
        if (cKeywords == null) {
            cKeywords = new KeywordMap(false);
            cKeywords.add("abstract", (byte)6);
            cKeywords.add("as", (byte)6);
            cKeywords.add("base", (byte)6);
            cKeywords.add("break", (byte)6);
            cKeywords.add("case", (byte)6);
            cKeywords.add("catch", (byte)6);
            cKeywords.add("checked", (byte)6);
            cKeywords.add("const", (byte)6);
            cKeywords.add("continue", (byte)6);
            cKeywords.add("decimal", (byte)6);
            cKeywords.add("default", (byte)6);
            cKeywords.add("delegate", (byte)6);
            cKeywords.add("do", (byte)6);
            cKeywords.add("else", (byte)6);
            cKeywords.add("explicit", (byte)6);
            cKeywords.add("extern", (byte)6);
            cKeywords.add("finally", (byte)6);
            cKeywords.add("fixed", (byte)6);
            cKeywords.add("for", (byte)6);
            cKeywords.add("foreach", (byte)6);
            cKeywords.add("get", (byte)6);
            cKeywords.add("goto", (byte)6);
            cKeywords.add("if", (byte)6);
            cKeywords.add("implicit", (byte)6);
            cKeywords.add("in", (byte)6);
            cKeywords.add("internal", (byte)6);
            cKeywords.add("is", (byte)6);
            cKeywords.add("lock", (byte)6);
            cKeywords.add("new", (byte)6);
            cKeywords.add("operator", (byte)6);
            cKeywords.add("out", (byte)6);
            cKeywords.add("override", (byte)6);
            cKeywords.add("params", (byte)6);
            cKeywords.add("private", (byte)6);
            cKeywords.add("protected", (byte)6);
            cKeywords.add("public", (byte)6);
            cKeywords.add("readonly", (byte)6);
            cKeywords.add("ref", (byte)6);
            cKeywords.add("return", (byte)6);
            cKeywords.add("sealed", (byte)6);
            cKeywords.add("set", (byte)6);
            cKeywords.add("sizeof", (byte)6);
            cKeywords.add("stackalloc", (byte)6);
            cKeywords.add("static", (byte)6);
            cKeywords.add("switch", (byte)6);
            cKeywords.add("throw", (byte)6);
            cKeywords.add("try", (byte)6);
            cKeywords.add("typeof", (byte)6);
            cKeywords.add("unchecked", (byte)6);
            cKeywords.add("unsafe", (byte)6);
            cKeywords.add("virtual", (byte)6);
            cKeywords.add("while", (byte)6);
            cKeywords.add("using", (byte)7);
            cKeywords.add("namespace", (byte)7);
            cKeywords.add("bool", (byte)8);
            cKeywords.add("byte", (byte)8);
            cKeywords.add("char", (byte)8);
            cKeywords.add("class", (byte)8);
            cKeywords.add("double", (byte)8);
            cKeywords.add("enum", (byte)8);
            cKeywords.add("event", (byte)8);
            cKeywords.add("float", (byte)8);
            cKeywords.add("int", (byte)8);
            cKeywords.add("interface", (byte)8);
            cKeywords.add("long", (byte)8);
            cKeywords.add("object", (byte)8);
            cKeywords.add("sbyte", (byte)8);
            cKeywords.add("short", (byte)8);
            cKeywords.add("string", (byte)8);
            cKeywords.add("struct", (byte)8);
            cKeywords.add("uint", (byte)8);
            cKeywords.add("ulong", (byte)8);
            cKeywords.add("ushort", (byte)8);
            cKeywords.add("void", (byte)8);
            cKeywords.add("false", (byte)4);
            cKeywords.add("null", (byte)4);
            cKeywords.add("this", (byte)4);
            cKeywords.add("true", (byte)4);
        }
        return cKeywords;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = this.keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)0);
            }
            this.addToken(len, id);
            this.lastOffset = i;
            this.lastKeyword = i1;
            this.lastWhitespace = i;
            return true;
        }
        this.lastKeyword = i1;
        return false;
    }
}

