/*
 * Decompiled with CFR 0.152.
 */
package jehep.spell;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.text.Segment;
import jehep.ui.Editor;
import jehep.ui.SetEnv;

public class SpellUtil {
    private static int[] wavePoints = new int[10];
    public static final String METHOD_DELIMITERS = "$\\<>";
    public static final String METHOD_SPACE = " \t~!%^*()_1234567890\n-+=|#/:;\"'<>,.?";
    public static Color defaultColor;

    public static void Check(Segment line, Graphics gfx, Font defaultFont, Color Cdefault, int x, int y, FontMetrics fm) {
        char[] Tarray = line.array;
        int offset = line.offset;
        int length = line.count + offset;
        defaultColor = Cdefault;
        int fhigh = fm.getHeight();
        y += (int)((double)fhigh * 0.24);
        for (int i = 0; i < wavePoints.length; ++i) {
            SpellUtil.wavePoints[i] = (int)Math.round(Math.cos((double)(2 * i) * (Math.PI * 2 / (double)wavePoints.length)));
        }
        int kwid = 0;
        int swid = 0;
        int wpos1 = 0;
        int wpos2 = 0;
        char c = ' ';
        String word = "";
        int fspace = fm.charWidth(' ');
        String word_old = "";
        for (int i = offset; i <= length; ++i) {
            if (i < length) {
                c = Tarray[i];
            }
            if (i == length) {
                c = '\n';
            }
            int fwidth = fm.charWidth(c);
            kwid += fwidth;
            if (METHOD_SPACE.indexOf(c) != -1 || i == length) {
                int mi1;
                int mi2;
                int i1 = kwid - swid - fspace;
                int i2 = kwid - fspace;
                if (i == length) {
                    i2 = kwid;
                    i1 = kwid - swid;
                }
                if ((mi2 = offset + wpos1) - (mi1 = offset + wpos1 - wpos2) > 0) {
                    Segment ss = new Segment(Tarray, mi1, mi2 - mi1);
                    word = ss.toString();
                    word = word.trim();
                    SpellUtil.spell(word, word_old, gfx, i1, i2, y);
                    word_old = word;
                }
                swid = 0;
                wpos2 = 0;
            } else {
                swid += fwidth;
                ++wpos2;
            }
            ++wpos1;
        }
    }

    private static void spell(String word, String word_old, Graphics gfx, int i1, int i2, int y) {
        boolean ISCorrect;
        boolean iche1;
        if (word.indexOf("\\") != -1) {
            return;
        }
        if (word.indexOf("$") != -1) {
            return;
        }
        if (word.indexOf("{") != -1) {
            return;
        }
        if (word.indexOf("}") != -1) {
            return;
        }
        boolean accep = Editor.AcceptedWords().contains(word);
        if (accep) {
            Editor.BadWords().remove(word);
        }
        if (iche1 = word.equals(word_old)) {
            gfx.setColor(new Color(255, 102, 20));
            SpellUtil.paintWaveLine(gfx, i1, i2, y);
            gfx.setColor(defaultColor);
        }
        if (!(ISCorrect = SetEnv.checker.isCorrect(word)) && !accep) {
            Editor.BadWords().add(word);
            gfx.setColor(Color.red);
            SpellUtil.paintWaveLine(gfx, i1, i2, y);
            gfx.setColor(defaultColor);
        }
    }

    private static void paintWaveLine(Graphics g, int x1, int x2, int y1) {
        for (int x = x1; x < x2; ++x) {
            int y = y1 - 2 - wavePoints[x % wavePoints.length];
            g.drawLine(x, y, x, y);
        }
    }
}

