/*
 * Decompiled with CFR 0.152.
 */
package jehep.shelljython;

import com.artenum.jyconsole.AutoScrollable;
import com.artenum.jyconsole.HistoryManager;
import com.artenum.jyconsole.action.DefaultClearAction;
import com.artenum.jyconsole.action.DefaultCompletionAction;
import com.artenum.jyconsole.action.DefaultEscapeAction;
import com.artenum.jyconsole.action.DefaultHistoryNavigationAction;
import com.artenum.jyconsole.action.DefaultValidationAction;
import com.artenum.jyconsole.command.Command;
import com.artenum.jyconsole.command.CommandRunner;
import com.artenum.jyconsole.command.ThreadPerCommandRunner;
import com.artenum.jyconsole.io.InteractiveCommandLine;
import com.artenum.jyconsole.io.NotSingleThreadStream;
import com.artenum.jyconsole.io.SingleThreadStream;
import com.artenum.jyconsole.io.StyledDocumentOutputStream;
import com.artenum.jyconsole.listener.FocusMouseListener;
import com.artenum.jyconsole.python.JInteractiveInterpreter;
import com.artenum.jyconsole.ui.MiniTextPane;
import com.artenum.jyconsole.ui.PopupMenu;
import com.artenum.jyconsole.ui.Prompt;
import com.artenum.jyconsole.ui.ScrollingView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import jehep.shelljython.JyReplacement;
import jehep.shelljython.JySyntaxDocument;
import jehep.ui.SetEnv;
import jport.EnvGlobal;
import org.python.core.PyObject;
import org.python.util.InteractiveConsole;

public class JyShell
extends JPanel
implements ComponentListener,
AutoScrollable {
    private static final long serialVersionUID = 1L;
    public static final String HEADER_NOEDITOR = "  <-- Jython Shell --> \n";
    public static final String HEADER = "";
    public static final String COPYRIGHT = "\nCopyright (c) 2005, Artenum SARL \nAllRights reserved.\n\nCopyright (c) 2000, Jython Developers\nAll rights reserved.\n\nCopyright (c) 2000 BeOpen.com.All Rights Reserved.\n\nCopyright (c) 2000 The Apache Software Foundation.\nAll rights reserved.\n\nCopyright (c) 1995-2000 Corporation for National Research Initiatives.\nAll Rights Reserved.\n\nCopyright (c) 1991-1995 Stichting Mathematisch Centrum, Amsterdam.\nAll Rights Reserved.\n";
    public static final String LICENSE = "\nJyConsole follows the QPL License. (http://www.trolltech.com/licenses/qpl.html)\n";
    public static final String CREDITS = "\nJyConsole is maintained by the Artenum developers (www.artenum.com).\n - Authors: Sebastien Jourdain, jourdain@artenum.com\n - Contributors: Colin Crist, colincrist@hermesjms.com\n";
    public static final String PREF_FILE_PATH = "jyconsole.pref.file.path";
    public static final String PREF_SCRIPT_DIR = "jyconsole.pref.script.dir";
    public static final String PREF_ERROR_TXT_COLOR = "jyconsole.pref.txt.color.error";
    public static final String PREF_NORMAL_TXT_COLOR = "jyconsole.pref.txt.color.normal";
    public static final String PREF_WARNING_TXT_COLOR = "jyconsole.pref.txt.color.warning";
    public static final String PREF_BG_COLOR = "jyconsole.pref.bg.color";
    public static final String PREF_COMMAND_RUNNER = "jyconsole.pref.commandRunner.className";
    public static final String PREF_PRINT_ERROR_STREAM = "jyconsole.pref.print.error.stream";
    public static final String PREF_PRINT_STD_STREAM = "jyconsole.pref.print.std.stream";
    public static final String PREF_INIT_LOADING_SCRIPT = "jyconsole.pref.loading.script";
    public static final String STYLE_NORMAL = "default";
    public static final String STYLE_WARNING = "warning";
    public static final String STYLE_ERROR = "error";
    private String interpreterThreadName;
    private JInteractiveInterpreter pythonInterpreter;
    private InteractiveCommandLine cmd;
    private HistoryManager historyManager;
    private CommandRunner commandRunner;
    private JPanel cmdLineUI;
    private Hashtable preference;
    private JTextPane archiveUI;
    private JySyntaxDocument archiveModel;
    private JTextPane cmdUI;
    private JySyntaxDocument cmdModel;
    private Prompt prompt;
    private JScrollPane scroll;
    private JPanel uiContent;
    private PopupMenu popup;
    private FocusMouseListener focusGrabber;

    public JyShell() {
        this(null, null);
    }

    public JyShell(CommandRunner commandRunner) {
        this(null, commandRunner);
    }

    public JyShell(PyObject pyObj) {
        this(pyObj, null);
    }

    public JyShell(PyObject pyObj, CommandRunner commandRunner) {
        super(new BorderLayout());
        File scriptToLoad;
        this.commandRunner = commandRunner;
        this.uiContent = new ScrollingView(new BorderLayout());
        this.archiveModel = new JySyntaxDocument();
        this.cmdModel = new JySyntaxDocument();
        this.archiveUI = new MiniTextPane(this.archiveModel);
        this.archiveUI.setEditable(false);
        this.cmdUI = new JTextPane(this.cmdModel);
        this.cmdUI.setCaretColor(Color.red);
        Font font = new Font("Arial", 0, 12);
        if (SetEnv.ClassPath != null) {
            font = SetEnv.globalFont;
        }
        if (EnvGlobal.ClassPath != null) {
            font = EnvGlobal.globalFont;
        }
        this.cmdUI.setFont(font);
        this.archiveUI.setFont(font);
        this.prompt = new Prompt(this.cmdUI);
        this.cmdLineUI = new JPanel(new BorderLayout());
        this.cmdLineUI.setFont(font);
        this.cmdLineUI.add((Component)this.prompt, "West");
        this.cmdLineUI.add((Component)this.cmdUI, "Center");
        this.uiContent.add((Component)this.archiveUI, "North");
        this.uiContent.add((Component)this.cmdLineUI, "Center");
        this.uiContent.addComponentListener(this);
        Style def = StyleContext.getDefaultStyleContext().getStyle(STYLE_NORMAL);
        Style regular = this.archiveUI.addStyle(STYLE_NORMAL, def);
        this.cmdUI.addStyle(STYLE_NORMAL, def);
        Style s = this.archiveUI.addStyle(STYLE_WARNING, regular);
        s = this.cmdUI.addStyle(STYLE_WARNING, regular);
        s = this.archiveUI.addStyle(STYLE_ERROR, regular);
        s = this.cmdUI.addStyle(STYLE_ERROR, regular);
        this.scroll = new JScrollPane(this.uiContent);
        this.add((Component)this.scroll, "Center");
        this.preference = new Hashtable();
        if (System.getProperty(PREF_SCRIPT_DIR) != null) {
            this.preference.put(PREF_SCRIPT_DIR, System.getProperty(PREF_SCRIPT_DIR));
        } else {
            this.preference.put(PREF_SCRIPT_DIR, new File(".").getAbsolutePath());
        }
        if (System.getProperty(PREF_ERROR_TXT_COLOR) != null) {
            this.preference.put(PREF_ERROR_TXT_COLOR, Color.decode(System.getProperty(PREF_ERROR_TXT_COLOR)));
        } else {
            this.preference.put(PREF_ERROR_TXT_COLOR, Color.RED);
        }
        if (System.getProperty(PREF_WARNING_TXT_COLOR) != null) {
            this.preference.put(PREF_WARNING_TXT_COLOR, Color.decode(System.getProperty(PREF_WARNING_TXT_COLOR)));
        } else {
            this.preference.put(PREF_WARNING_TXT_COLOR, Color.GREEN);
        }
        if (System.getProperty(PREF_NORMAL_TXT_COLOR) != null) {
            this.preference.put(PREF_NORMAL_TXT_COLOR, Color.decode(System.getProperty(PREF_NORMAL_TXT_COLOR)));
        } else {
            this.preference.put(PREF_NORMAL_TXT_COLOR, Color.BLACK);
        }
        if (System.getProperty(PREF_BG_COLOR) != null) {
            this.preference.put(PREF_BG_COLOR, Color.decode(System.getProperty(PREF_BG_COLOR)));
        } else {
            this.preference.put(PREF_BG_COLOR, Color.WHITE);
        }
        if (System.getProperty(PREF_FILE_PATH) != null) {
            this.preference.put(PREF_FILE_PATH, System.getProperty(PREF_FILE_PATH));
            try {
                FileInputStream fis = new FileInputStream(System.getProperty(PREF_FILE_PATH));
                try {
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    Hashtable pref = (Hashtable)ois.readObject();
                    ois.close();
                    this.preference.putAll(pref);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
            }
            catch (FileNotFoundException e) {
                try {
                    FileOutputStream fos = new FileOutputStream(System.getProperty(PREF_FILE_PATH));
                    ObjectOutputStream oos = new ObjectOutputStream(fos);
                    oos.writeObject(this.preference);
                    oos.close();
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        } else {
            this.preference.put(PREF_FILE_PATH, "./pref.data");
        }
        this.cmd = new InteractiveCommandLine(this.cmdModel, this.cmdUI, this.prompt, STYLE_NORMAL);
        this.interpreterThreadName = new String("JyConsole-" + System.currentTimeMillis());
        if (commandRunner == null) {
            if (System.getProperty(PREF_COMMAND_RUNNER) != null) {
                try {
                    Constructor<?> contructor = Class.forName(System.getProperty(PREF_COMMAND_RUNNER)).getConstructor(String.class);
                    this.commandRunner = (CommandRunner)contructor.newInstance(this.interpreterThreadName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (commandRunner == null) {
                this.commandRunner = new ThreadPerCommandRunner(this.interpreterThreadName);
            }
        }
        this.pythonInterpreter = new JInteractiveInterpreter(false);
        if (pyObj != null) {
            this.pythonInterpreter.setLocals(pyObj);
        }
        this.pythonInterpreter.addOut(new SingleThreadStream(new StyledDocumentOutputStream(this.archiveModel, STYLE_NORMAL), this.interpreterThreadName));
        this.pythonInterpreter.addErr(new SingleThreadStream(new StyledDocumentOutputStream(this.archiveModel, STYLE_ERROR), this.interpreterThreadName));
        if (System.getProperty(PREF_PRINT_STD_STREAM) != null && System.getProperty(PREF_PRINT_STD_STREAM).equals("true")) {
            System.setOut(new PrintStream(new StyledDocumentOutputStream(this.archiveModel, STYLE_NORMAL)));
        }
        if (System.getProperty(PREF_PRINT_ERROR_STREAM) != null && System.getProperty(PREF_PRINT_ERROR_STREAM).equals("true")) {
            System.setErr(new PrintStream(new NotSingleThreadStream(new StyledDocumentOutputStream(this.archiveModel, STYLE_ERROR), "completion")));
        }
        this.historyManager = new HistoryManager(this);
        InputMap inputMap = this.cmdUI.getInputMap();
        ActionMap actionMap = this.cmdUI.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "EXECUTE_COMMAND");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "ESCAPE_COMMAND");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "UP_COMMAND");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "DOWN_COMMAND");
        inputMap.put(KeyStroke.getKeyStroke(32, 2), "COMPLETION_COMMAND");
        inputMap.put(KeyStroke.getKeyStroke(76, 2), "CLEAR_COMMAND");
        actionMap.put("EXECUTE_COMMAND", new DefaultValidationAction(this));
        actionMap.put("ESCAPE_COMMAND", new DefaultEscapeAction(this));
        actionMap.put("UP_COMMAND", new DefaultHistoryNavigationAction(this, 1));
        actionMap.put("DOWN_COMMAND", new DefaultHistoryNavigationAction(this, 2));
        actionMap.put("COMPLETION_COMMAND", new DefaultCompletionAction(this));
        actionMap.put("CLEAR_COMMAND", new DefaultClearAction(this));
        this.applyPreferences();
        this.popup = new PopupMenu(this);
        this.cmdUI.addMouseListener(this.popup);
        this.archiveUI.addMouseListener(this.popup);
        this.prompt.addMouseListener(this.popup);
        this.focusGrabber = new FocusMouseListener(this.cmdUI, this);
        this.prompt.addMouseListener(this.focusGrabber);
        this.archiveUI.addMouseListener(this.focusGrabber);
        this.clear();
        if (System.getProperty(PREF_INIT_LOADING_SCRIPT) != null && (scriptToLoad = new File(System.getProperty(PREF_INIT_LOADING_SCRIPT))).exists()) {
            this.executePythonFile(scriptToLoad);
        }
    }

    public void setCommandRunner(CommandRunner commandRunner) {
        if (this.commandRunner != null) {
            this.commandRunner.stop();
        }
        this.commandRunner = commandRunner;
    }

    public String getInterpreterThreadName() {
        return this.interpreterThreadName;
    }

    public void setConsoleFont(Font font) {
        Style norm = this.cmdUI.getStyle(STYLE_NORMAL);
        StyleConstants.setFontFamily(norm, font.getFontName());
        StyleConstants.setFontSize(norm, font.getSize());
        StyleConstants.setItalic(norm, font.isItalic());
        StyleConstants.setBold(norm, font.isBold());
        this.cmdUI.setLogicalStyle(norm);
        Style err = this.cmdUI.getStyle(STYLE_ERROR);
        StyleConstants.setFontFamily(err, font.getFontName());
        StyleConstants.setFontSize(err, font.getSize());
        StyleConstants.setItalic(err, font.isItalic());
        StyleConstants.setBold(err, font.isBold());
        this.cmdUI.setLogicalStyle(err);
        Style war = this.cmdUI.getStyle(STYLE_WARNING);
        StyleConstants.setFontFamily(war, font.getFontName());
        StyleConstants.setFontSize(war, font.getSize());
        StyleConstants.setItalic(war, font.isItalic());
        StyleConstants.setBold(war, font.isBold());
        this.cmdUI.setLogicalStyle(war);
        Style norm1 = this.archiveUI.getStyle(STYLE_NORMAL);
        StyleConstants.setFontFamily(norm1, font.getFontName());
        StyleConstants.setFontSize(norm1, font.getSize());
        StyleConstants.setItalic(norm1, font.isItalic());
        StyleConstants.setBold(norm1, font.isBold());
        this.archiveUI.setLogicalStyle(norm1);
        Style err1 = this.archiveUI.getStyle(STYLE_ERROR);
        StyleConstants.setFontFamily(err1, font.getFontName());
        StyleConstants.setFontSize(err1, font.getSize());
        StyleConstants.setItalic(err1, font.isItalic());
        StyleConstants.setBold(err1, font.isBold());
        this.archiveUI.setLogicalStyle(err1);
        Style war1 = this.archiveUI.getStyle(STYLE_WARNING);
        StyleConstants.setFontFamily(war1, font.getFontName());
        StyleConstants.setFontSize(war1, font.getSize());
        StyleConstants.setItalic(war1, font.isItalic());
        StyleConstants.setBold(war1, font.isBold());
        this.archiveUI.setLogicalStyle(war1);
        this.cmdLineUI.setFont(font);
        this.cmdUI.setFont(font);
        this.archiveUI.setFont(font);
        this.cmdUI.updateUI();
        this.archiveUI.updateUI();
        this.cmdLineUI.updateUI();
    }

    public void applyPreferences() {
        this.setColor((Color)this.preference.get(PREF_NORMAL_TXT_COLOR), (Color)this.preference.get(PREF_BG_COLOR));
        this.setColorToStyle(STYLE_ERROR, (Color)this.preference.get(PREF_ERROR_TXT_COLOR));
        this.setColorToStyle(STYLE_WARNING, (Color)this.preference.get(PREF_WARNING_TXT_COLOR));
    }

    public void savePreferences() {
        try {
            FileOutputStream fos = new FileOutputStream((String)this.preference.get(PREF_FILE_PATH));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.preference);
            oos.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public Hashtable getPreferences() {
        return this.preference;
    }

    public Point getCompletionWindowLocation() {
        Point p = this.getInteractiveCommandLine().getCaretPositionPoint();
        Container current = this.cmdUI;
        for (current = current.getParent(); current != null; current = current.getParent()) {
            Point p2 = current.getLocation();
            p.translate(p2.x, p2.y);
        }
        p.x += this.prompt.getWidth();
        return p;
    }

    public InteractiveCommandLine getInteractiveCommandLine() {
        return this.cmd;
    }

    public void showPreviousCmdInHistory() {
        this.historyManager.showPreviousCommand();
        this.prompt.updateLineView();
    }

    public void showNextCmdInHistory() {
        this.historyManager.showNextCommand();
        this.prompt.updateLineView();
    }

    public void executeCmdLine() {
        this.archiveModel.setHighlighting(true);
        this.cmdUI.setCaretPosition(0);
        try {
            String cmdLine = this.getInteractiveCommandLine().getCmdLine();
            cmdLine = JyReplacement.make(cmdLine);
            this.historyManager.addCommandInHistory(cmdLine);
            this.archiveModel.insertString(this.archiveModel.getLength(), ">>> " + cmdLine.replaceAll("\n", "\n... ") + "\n", this.archiveModel.getStyle(STYLE_NORMAL));
            this.runPythonCmd(cmdLine);
            this.getInteractiveCommandLine().reset();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.prompt.updateLineView();
    }

    public void executePythonFile(File pyFile) {
        this.archiveModel.setHighlighting(false);
        this.commandRunner.invokeLater(new Command(this.pythonInterpreter, pyFile));
    }

    public void runPythonCmd(String cmd) {
        if (SetEnv.ClassPath == null && EnvGlobal.ClassPath != null) {
            cmd = EnvGlobal.substitudePorto((String)cmd);
        }
        this.archiveModel.setHighlighting(true);
        this.commandRunner.invokeLater(new Command(this.pythonInterpreter, cmd));
    }

    public String getVersion() {
        return InteractiveConsole.getDefaultBanner();
    }

    public void execute(String cmd) {
        this.commandRunner.invokeLater(new Command(this.pythonInterpreter, cmd));
    }

    public void killCurrentThread() {
        this.commandRunner.reset();
    }

    public void clear() {
        try {
            this.cmdModel.remove(0, this.cmdModel.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        try {
            this.archiveModel.remove(0, this.archiveModel.getLength());
            if (SetEnv.ClassPath != null) {
                this.archiveModel.insertString(0, HEADER, this.archiveModel.getStyle(STYLE_NORMAL));
            } else {
                this.archiveModel.insertString(0, HEADER_NOEDITOR, this.archiveModel.getStyle(STYLE_NORMAL));
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void copyright() {
        try {
            String cmdLine = this.getInteractiveCommandLine().getCmdLine();
            this.historyManager.addCommandInHistory(cmdLine);
            this.archiveModel.insertString(this.archiveModel.getLength(), ">>> " + cmdLine.replaceAll("\n", "\n... ") + "\n", this.archiveModel.getStyle(STYLE_NORMAL));
            this.cmdModel.remove(0, this.cmdModel.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        try {
            this.archiveModel.insertString(this.archiveModel.getLength(), COPYRIGHT, this.archiveModel.getStyle(STYLE_NORMAL));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void credits() {
        try {
            String cmdLine = this.getInteractiveCommandLine().getCmdLine();
            this.historyManager.addCommandInHistory(cmdLine);
            this.archiveModel.insertString(this.archiveModel.getLength(), ">>> " + cmdLine.replaceAll("\n", "\n... ") + "\n", this.archiveModel.getStyle(STYLE_NORMAL));
            this.cmdModel.remove(0, this.cmdModel.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        try {
            this.archiveModel.insertString(this.archiveModel.getLength(), CREDITS, this.archiveModel.getStyle(STYLE_NORMAL));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void license() {
        try {
            String cmdLine = this.getInteractiveCommandLine().getCmdLine();
            this.historyManager.addCommandInHistory(cmdLine);
            this.archiveModel.insertString(this.archiveModel.getLength(), ">>> " + cmdLine.replaceAll("\n", "\n... ") + "\n", this.archiveModel.getStyle(STYLE_NORMAL));
            this.cmdModel.remove(0, this.cmdModel.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        try {
            this.archiveModel.insertString(this.archiveModel.getLength(), LICENSE, this.archiveModel.getStyle(STYLE_NORMAL));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public JInteractiveInterpreter getPythonInterpreter() {
        return this.pythonInterpreter;
    }

    public void setColor(Color fg, Color bg) {
        this.prompt.setColor(fg, bg);
        this.cmdUI.setBackground(bg);
        this.archiveUI.setBackground(bg);
        this.setColorToStyle(STYLE_NORMAL, fg);
    }

    public void setColorToStyle(String styleName, Color fg) {
        StyleConstants.setForeground(this.archiveModel.getStyle(styleName), fg);
        StyleConstants.setForeground(this.cmdModel.getStyle(styleName), fg);
    }

    public void setBoldToStyle(String styleName, boolean bold) {
        StyleConstants.setBold(this.archiveModel.getStyle(styleName), bold);
        StyleConstants.setBold(this.cmdModel.getStyle(styleName), bold);
    }

    public void setItalicToStyle(String styleName, boolean italic) {
        StyleConstants.setItalic(this.archiveModel.getStyle(styleName), italic);
        StyleConstants.setItalic(this.cmdModel.getStyle(styleName), italic);
    }

    @Override
    public void updateScrollPosition() {
        this.scroll.getViewport().setViewPosition(new Point(0, this.uiContent.getHeight() - this.scroll.getViewport().getExtentSize().height));
        this.scroll.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.updateScrollPosition();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

