/*
 * Decompiled with CFR 0.152.
 */
package jehep.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jehep.ui.Constants;
import jehep.ui.SetEnv;
import jehep.ui.mainGUI;
import jehep.utils.Utils;

public class SearchDialog
extends JDialog
implements ActionListener,
ItemListener,
Constants {
    private mainGUI window;
    private JButton jbtNext;
    private JButton jbtCancel;
    private JTextField jtf;
    private JComboBox jcb;
    private String findstr;
    private JCheckBox jcheck;
    private JCheckBox jcheck2;
    private JCheckBox jcheck3;
    private boolean ignoreCase;
    private boolean wholeWord;
    private boolean wrap;
    private boolean runFind;
    private int pos = -1;
    private int lastpos = 0;
    private Utils Utils;

    public SearchDialog(mainGUI window) {
        super(window, "Find", false);
        this.window = window;
        this.setResizable(false);
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min(300, res.width), Math.min(200, res.height));
        this.setSize(size);
        this.Utils = new Utils(window);
        this.jcheck = new JCheckBox("Ignor case");
        this.jcheck.addItemListener(this);
        this.jcheck.setFont(SetEnv.guiFont);
        this.jcheck2 = new JCheckBox("Whole word");
        this.jcheck2.addItemListener(this);
        this.jcheck2.setFont(SetEnv.guiFont);
        this.jcheck3 = new JCheckBox("Wrap");
        this.jcheck3.addItemListener(this);
        this.jcheck3.setFont(SetEnv.guiFont);
        JPanel topbutPanel = new JPanel();
        topbutPanel.setLayout(new FlowLayout(1));
        this.jbtNext = this.createButton("Find Next");
        topbutPanel.add(this.jbtNext);
        this.jbtCancel = this.createButton("Exit");
        topbutPanel.add(this.jbtCancel);
        this.jbtNext.setPreferredSize(new Dimension(110, 24));
        this.jbtCancel.setPreferredSize(new Dimension(110, 24));
        this.jbtNext.setToolTipText("Find Next Word");
        this.jbtCancel.setToolTipText("Close Window");
        JPanel botbutPanel = new JPanel();
        botbutPanel.setLayout(new FlowLayout(1));
        botbutPanel.add(this.jcheck);
        botbutPanel.add(this.jcheck2);
        botbutPanel.add(this.jcheck3);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 1));
        buttonPane.add(Box.createVerticalGlue());
        buttonPane.add(topbutPanel);
        buttonPane.add(Box.createVerticalGlue());
        buttonPane.add(botbutPanel);
        this.getContentPane().add((Component)buttonPane, "South");
        JPanel dataPane = new JPanel();
        dataPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagLayout gbLayout = new GridBagLayout();
        dataPane.setLayout(gbLayout);
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel findlabel = new JLabel("Find");
        findlabel.setFont(new Font("Arial", 0, 12));
        JPanel Labels = new JPanel();
        Labels.setLayout(new FlowLayout(1));
        Labels.add(findlabel);
        this.getContentPane().add((Component)Labels, "North");
        JPanel txtField = new JPanel();
        this.jcb = new JComboBox();
        txtField.add(this.jcb);
        this.jcb.setFont(SetEnv.guiFont);
        gbLayout.setConstraints(txtField, constraints);
        dataPane.add(txtField);
        this.jcb.setEditable(true);
        this.jcb.setPreferredSize(new Dimension(175, 18));
        this.jtf = new JTextField();
        KeyHandler handler = new KeyHandler();
        this.jtf = (JTextField)this.jcb.getEditor().getEditorComponent();
        this.jtf.addKeyListener(handler);
        this.getContentPane().add((Component)dataPane, "Center");
        this.pack();
        this.setVisible(false);
        this.setFont(SetEnv.guiFont);
        this.ignoreCase = false;
    }

    public void selectText() {
        this.jtf.selectAll();
    }

    public void getSelectedText() {
        String s = this.window.getSelectedText();
        if (s != null && s != "") {
            s.trim();
            int x = this.jcb.getItemCount();
            boolean match = false;
            for (int i = 0; i < x; ++i) {
                if (!this.jtf.getText().equals(s)) continue;
                match = true;
            }
            if (!match) {
                this.jcb.insertItemAt(this.makeObj(s), 0);
                this.jcb.setSelectedIndex(0);
            }
        }
    }

    private Object makeObj(final String item) {
        return new Object(){

            public String toString() {
                return item;
            }
        };
    }

    public void addItemToBox() {
        int x = this.jcb.getItemCount();
        boolean match = false;
        for (int i = 0; i < x; ++i) {
            if (!this.jtf.getText().equals(this.jcb.getItemAt(i).toString())) continue;
            match = true;
        }
        if (!match) {
            this.jcb.insertItemAt(this.makeObj(this.jtf.getText()), 0);
        }
    }

    JButton createButton(String label) {
        JButton button = new JButton(label);
        button.setFont(SetEnv.guiFont);
        button.setPreferredSize(new Dimension(80, 18));
        button.addActionListener(this);
        return button;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.ignoreCase = this.jcheck.isSelected();
        this.wholeWord = this.jcheck2.isSelected();
        this.wrap = this.jcheck3.isSelected();
    }

    public void FindNext() {
        this.findstr = "";
        String s = this.window.GetText();
        if (this.jtf.getText().equals("")) {
            return;
        }
        this.findstr = this.jtf.getText();
        this.addItemToBox();
        if (this.ignoreCase) {
            s = s.toLowerCase();
            this.findstr = this.findstr.toLowerCase();
        }
        if (this.wholeWord) {
            this.findstr = " " + this.findstr + " ";
        } else {
            this.findstr.trim();
        }
        this.pos = s.indexOf(this.findstr, this.window.getCaretPosition());
        this.lastpos = s.lastIndexOf(this.findstr);
        if (this.pos == -1) {
            if (this.wrap) {
                this.pos = s.indexOf(this.findstr, 0);
                if (this.pos != -1) {
                    this.window.select(this.pos, this.pos + this.findstr.length());
                } else {
                    jehep.utils.Utils.userMessage("Not Found", this.findstr + " not found", 1);
                }
            } else {
                jehep.utils.Utils.userMessage("Not Found", this.findstr + " not found", 1);
            }
        } else {
            this.window.select(this.pos, this.pos + this.findstr.length());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (e.getSource() == this.jbtNext) {
                this.FindNext();
            } else if (e.getSource() == this.jbtCancel) {
                this.setVisible(false);
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            switch (evt.getKeyCode()) {
                case 10: {
                    if (evt.getSource() == SearchDialog.this.jtf) {
                        SearchDialog.this.FindNext();
                    }
                }
                case 27: {
                    SearchDialog.this.setVisible(false);
                }
            }
        }
    }
}

