/*
 * Decompiled with CFR 0.152.
 */
package jehep.misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jehep.ui.SetEnv;
import jehep.utils.Util;
import jport.EnvGlobal;

public class ErrorDialog
extends JDialog
implements Runnable,
ActionListener {
    private JTextArea textArea;
    private JButton okButton;
    private JButton sysButton;
    private Thread reader;
    private Thread reader2;
    private boolean quit;
    private final PipedInputStream pin = new PipedInputStream();
    private final PipedInputStream pin2 = new PipedInputStream();
    private PrintStream oldStdout;
    private PrintStream oldStderr;
    private Component win;
    private String message = "System messages and errors";
    private static boolean isShown = false;
    private Font font;

    public ErrorDialog(Component win) {
        this.win = win;
        this.setDefaultCloseOperation(2);
        this.setTitle(this.message);
        this.setModal(false);
        this.setResizable(true);
        isShown = false;
        Dimension size = new Dimension((int)(0.5 * (double)win.getWidth()), (int)(0.6 * (double)win.getHeight()));
        this.setSize(size);
        Container mainPane = this.getContentPane();
        mainPane.setLayout(new BorderLayout());
        this.textArea = new JTextArea(20, 50);
        this.textArea.setEditable(false);
        this.font = new Font("Arial", 0, 12);
        if (SetEnv.ClassPath != null) {
            this.font = SetEnv.globalFont;
        }
        if (EnvGlobal.ClassPath != null) {
            this.font = EnvGlobal.globalFont;
        }
        this.textArea.setFont(this.font);
        JScrollPane textScrollPane = new JScrollPane(this.textArea);
        textScrollPane.setVerticalScrollBarPolicy(22);
        mainPane.add((Component)textScrollPane, "Center");
        JPanel buttonsPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        buttonsPanel.add(this.okButton);
        this.sysButton = new JButton("Stop monitoring");
        this.sysButton.addActionListener(this);
        buttonsPanel.add(this.sysButton);
        mainPane.add((Component)buttonsPanel, "Last");
        this.oldStdout = System.out;
        try {
            PipedOutputStream pout = new PipedOutputStream(this.pin);
            System.setOut(new PrintStream(pout, true));
        }
        catch (IOException io) {
            this.textArea.append("Couldn't redirect STDOUT to this console\n" + io.getMessage());
        }
        catch (SecurityException se) {
            this.textArea.append("Couldn't redirect STDOUT to this console\n" + se.getMessage());
        }
        this.oldStderr = System.err;
        try {
            PipedOutputStream pout2 = new PipedOutputStream(this.pin2);
            System.setErr(new PrintStream(pout2, true));
        }
        catch (IOException io) {
            this.textArea.append("Couldn't redirect STDERR to this console\n" + io.getMessage());
        }
        catch (SecurityException se) {
            this.textArea.append("Couldn't redirect STDERR to this console\n" + se.getMessage());
        }
        this.quit = false;
        Util.centreWithin(win, this);
        this.setVisible(isShown);
        this.reader = new Thread(this);
        this.reader.start();
        this.reader2 = new Thread(this);
        this.reader2.start();
    }

    public boolean getIsShown() {
        return isShown;
    }

    public void showIt(boolean vis) {
        isShown = vis;
        this.setVisible(vis);
    }

    public void showIt() {
        isShown = true;
        Thread t = new Thread("Show error dialog"){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    ErrorDialog.this.showIt(true);
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        };
        t.start();
    }

    public void setMessage(String mes) {
        this.setTitle(mes);
    }

    @Override
    public synchronized void run() {
        try {
            String input2;
            while (Thread.currentThread() == this.reader) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.pin.available() != 0) {
                    input2 = this.readLine(this.pin);
                    this.textArea.append(input2);
                }
                if (!this.quit) continue;
                return;
            }
            while (Thread.currentThread() == this.reader2) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException input2) {
                    // empty catch block
                }
                if (this.pin2.available() != 0) {
                    input2 = this.readLine(this.pin2);
                    this.textArea.append(input2);
                }
                if (!this.quit) continue;
                return;
            }
        }
        catch (Exception e) {
            this.textArea.append("\nConsole reports an Internal error.");
            this.textArea.append("The error is: " + e);
        }
    }

    public synchronized String readLine(PipedInputStream in) throws IOException {
        int available;
        String input = "";
        while ((available = in.available()) != 0) {
            if (!this.getIsShown()) {
                this.showIt();
            }
            byte[] b = new byte[available];
            in.read(b);
            if (!(input = input + new String(b, 0, b.length)).endsWith("\n") && !input.endsWith("\r\n") && !this.quit) continue;
        }
        return input;
    }

    private void endThreads() {
        this.quit = true;
        this.notifyAll();
        try {
            this.reader.join(1000L);
            this.pin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.reader2.join(1000L);
            this.pin2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setOut(this.oldStdout);
        System.setErr(this.oldStderr);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.showIt(false);
        }
        if (e.getSource() == this.sysButton) {
            this.endThreads();
            this.textArea.setText("");
            this.showIt(false);
        }
    }

    public void writeln(String message) {
        this.textArea.append(message + System.getProperty("line.separator"));
    }
}

