/*
 * Decompiled with CFR 0.152.
 */
package jehep.gnu.regexp;

import jehep.gnu.regexp.CharIndexed;
import jehep.gnu.regexp.REMatch;
import jehep.gnu.regexp.REToken;

final class RETokenChar
extends REToken {
    private char[] ch = new char[1];
    private boolean insens;

    RETokenChar(int subIndex, char c, boolean ins) {
        super(subIndex);
        this.insens = ins;
        this.ch[0] = this.insens ? Character.toLowerCase(c) : c;
    }

    @Override
    int getMinimumLength() {
        return this.ch.length;
    }

    @Override
    boolean match(CharIndexed input, REMatch mymatch) {
        int z = this.ch.length;
        for (int i = 0; i < z; ++i) {
            char c = input.charAt(mymatch.index + i);
            if ((this.insens ? Character.toLowerCase(c) : c) == this.ch[i]) continue;
            return false;
        }
        mymatch.index += z;
        return this.next(input, mymatch);
    }

    @Override
    boolean chain(REToken next) {
        if (next instanceof RETokenChar) {
            RETokenChar cnext = (RETokenChar)next;
            int newsize = this.ch.length + cnext.ch.length;
            char[] chTemp = new char[newsize];
            System.arraycopy(this.ch, 0, chTemp, 0, this.ch.length);
            System.arraycopy(cnext.ch, 0, chTemp, this.ch.length, cnext.ch.length);
            this.ch = chTemp;
            return false;
        }
        return super.chain(next);
    }

    @Override
    void dump(StringBuffer os) {
        os.append(this.ch);
    }
}

