/*
 * Decompiled with CFR 0.152.
 */
package jehep.fbrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jehep.fbrowser.AbstractCellEditor;
import jehep.fbrowser.AbstractFileSystemModel;
import jehep.fbrowser.AbstractTreeTableModel;
import jehep.fbrowser.Communicator;
import jehep.fbrowser.Consts;
import jehep.fbrowser.FBException;
import jehep.fbrowser.FileInterface;
import jehep.fbrowser.TreeTableModel;
import jehep.fbrowser.TreeTableModelAdapter;
import jehep.fbrowser.Worker;
import jehep.ui.PanelFiles;

public class JTreeTable
extends JTable {
    private static final long serialVersionUID = 1L;
    protected TreeTableCellRenderer tree;
    public PanelFiles win;
    private JPopupMenu popupMenu;
    private int lastSelectedRow = 0;

    public JTreeTable(AbstractTreeTableModel treeTableModel, PanelFiles win) {
        this.win = win;
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.tree.setLargeModel(true);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component c = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                return c;
            }
        });
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
        this.createListeners();
    }

    private void createListeners() {
        KeyStroke keyStroke_EnterFolder = KeyStroke.getKeyStroke("ENTER");
        this.getInputMap().put(keyStroke_EnterFolder, "enter_folder");
        this.getActionMap().put("enter_folder", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JTreeTable.this.tree.isSelectionEmpty()) {
                    int row = JTreeTable.this.tree.getSelectionRows()[0];
                    if (JTreeTable.this.tree.isExpanded(row)) {
                        JTreeTable.this.tree.collapseRow(row);
                    } else {
                        JTreeTable.this.tree.expandRow(row);
                    }
                    JTreeTable.this.tree.setSelectionRow(row);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                JTreeTable.this.rememberSelection();
                if (!e.isTemporary()) {
                    JTreeTable.this.clearSelection();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        KeyStroke keyStroke_Expand = KeyStroke.getKeyStroke(69, 128, false);
        this.getInputMap().put(keyStroke_Expand, "expand");
        this.getActionMap().put("expand", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTreeTable.this.expandFromHere();
            }
        });
        KeyStroke keyStroke_Rename = KeyStroke.getKeyStroke("F6");
        this.getInputMap().put(keyStroke_Rename, "rename");
        this.getActionMap().put("rename", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTreeTable.this.renameFile();
            }
        });
        KeyStroke keyStroke_Refresh = KeyStroke.getKeyStroke("F5");
        this.getInputMap().put(keyStroke_Refresh, "refresh");
        this.getActionMap().put("refresh", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTreeTable.this.refreshFile();
            }
        });
        KeyStroke keyStroke_Delete = KeyStroke.getKeyStroke("F8");
        this.getInputMap().put(keyStroke_Delete, "delete");
        this.getActionMap().put("delete", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTreeTable.this.deleteFile();
            }
        });
        KeyStroke keyStroke_NewFolder = KeyStroke.getKeyStroke("F7");
        this.getInputMap().put(keyStroke_NewFolder, "new_folder");
        this.getActionMap().put("new_folder", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JTreeTable.this.newFolder();
            }
        });
        this.popupMenu = new JPopupMenu();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String action = e.getActionCommand();
                if ("rename".equals(action)) {
                    JTreeTable.this.renameFile();
                } else if ("delete".equals(action)) {
                    JTreeTable.this.deleteFile();
                } else if ("refresh".equals(action)) {
                    JTreeTable.this.refreshFile();
                } else if ("expand".equals(action)) {
                    JTreeTable.this.expandFromHere();
                } else if ("new_folder".equals(action)) {
                    JTreeTable.this.newFolder();
                }
            }
        };
        JMenuItem item = new JMenuItem("Rename");
        item.setActionCommand("rename");
        item.addActionListener(al);
        item.setAccelerator(keyStroke_Rename);
        this.popupMenu.add(item);
        item = new JMenuItem("Delete");
        item.setActionCommand("delete");
        item.addActionListener(al);
        item.setAccelerator(keyStroke_Delete);
        this.popupMenu.add(item);
        item = new JMenuItem("Refresh");
        item.setActionCommand("refresh");
        item.addActionListener(al);
        item.setAccelerator(keyStroke_Refresh);
        this.popupMenu.add(item);
        item = new JMenuItem("New folder");
        item.setActionCommand("new_folder");
        item.addActionListener(al);
        item.setAccelerator(keyStroke_NewFolder);
        this.popupMenu.add(item);
        item = new JMenuItem("Expand from here");
        item.setActionCommand("expand");
        item.addActionListener(al);
        item.setAccelerator(keyStroke_Expand);
        this.popupMenu.add(item);
        this.add(this.popupMenu);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JTreeTable.this.lastSelectedRow = JTreeTable.this.rowAtPoint(new Point(e.getX(), e.getY()));
                    JTreeTable.this.changeSelection(JTreeTable.this.lastSelectedRow, 0, false, false);
                    JTreeTable.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private void renameFile() {
        FileInterface file2 = (FileInterface)((TreeTableModelAdapter)this.getModel()).nodeForRow(this.getSelectedRow());
        if (file2 == null) {
            Communicator.showErrorMessage(this, "No file is selected.");
            return;
        }
        this.rememberSelection();
        String newName = Communicator.askForInput(this, "Enter a new name for the " + (file2.isFile() ? "file" : "directory") + " '" + file2.getName() + "'.");
        if (newName != null) {
            if ("".equals(newName)) {
                Communicator.showErrorMessage(this, "Name cannot be empty.");
            } else {
                TreeTableModelAdapter thisModel = (TreeTableModelAdapter)this.getModel();
                SwingWorker_Rename worker = new SwingWorker_Rename((AbstractFileSystemModel)thisModel.treeTableModel, file2, newName);
                worker.start();
            }
        }
    }

    private void deleteFile() {
        int row;
        TreeTableModelAdapter thisModel = (TreeTableModelAdapter)this.getModel();
        FileInterface file2 = (FileInterface)thisModel.nodeForRow(row = this.getSelectedRow());
        if (file2 == null) {
            Communicator.showErrorMessage(this, "No file is selected.");
            return;
        }
        if (Communicator.askYesNo(this, "Delete the resource '" + file2.getPath() + "'?")) {
            boolean isModelRoot = row == 0;
            SwingWorker_Remove worker = new SwingWorker_Remove((AbstractFileSystemModel)thisModel.treeTableModel, file2, isModelRoot);
            worker.start();
        }
    }

    public void refreshFile() {
        TreeTableModelAdapter thisModel = (TreeTableModelAdapter)this.getModel();
        FileInterface file2 = (FileInterface)thisModel.nodeForRow(this.getSelectedRow());
        if (file2 == null) {
            return;
        }
        Consts.debug("5 zaraz odpale swing workera do refresha " + file2.getPath());
        SwingWorker_Refresh worker = new SwingWorker_Refresh((AbstractFileSystemModel)thisModel.treeTableModel, file2);
        worker.start();
        Consts.debug("6 swing worker do refresha odpalony " + SwingUtilities.isEventDispatchThread());
    }

    private void newFolder() {
        TreeTableModelAdapter thisModel = (TreeTableModelAdapter)this.getModel();
        FileInterface file2 = (FileInterface)thisModel.nodeForRow(this.getSelectedRow());
        if (file2 == null) {
            Communicator.showErrorMessage(this, "No file is selected.");
            return;
        }
        if (file2.isFile()) {
            Communicator.showErrorMessage(this, "'" + file2.getPath() + "' is a file.");
        } else {
            String folderName = Communicator.askForInput(this, "Enter folder name:");
            if (folderName != null) {
                if ("".equals(folderName)) {
                    Communicator.showErrorMessage(this, "Folder name cannot be empty.");
                } else {
                    try {
                        ((AbstractFileSystemModel)thisModel.treeTableModel).newFolder(file2, folderName);
                    }
                    catch (FBException ce) {
                        Communicator.showErrorMessage(this, "Creating new folder failed. ", ce);
                    }
                }
            }
        }
    }

    private void expandFromHere() {
        TreeTableModelAdapter thisModel = (TreeTableModelAdapter)this.getModel();
        FileInterface file2 = (FileInterface)thisModel.nodeForRow(this.getSelectedRow());
        if (file2 == null) {
            return;
        }
        Consts.debug("will start expand request");
        SwingWorker_ExpandFromHere worker = new SwingWorker_ExpandFromHere((AbstractFileSystemModel)thisModel.treeTableModel, file2);
        worker.start();
        Consts.debug("expand request started " + SwingUtilities.isEventDispatchThread());
    }

    private void rememberSelection() {
        this.lastSelectedRow = this.getSelectedRow();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.setEditable(false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            try {
                super.paint(g);
            }
            catch (ArrayIndexOutOfBoundsException aoobe) {
                Consts.debug("UWAGA !!!! jtreetable 750" + aoobe.getMessage() + " " + aoobe.getCause());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = 1L;
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent me = (MouseEvent)e;
                    MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }
    }

    private class SwingWorker_Rename
    extends SwingWorker_ForCastor {
        String newName;

        public SwingWorker_Rename(AbstractFileSystemModel mod, FileInterface file2, String newName) {
            super(mod, file2);
            this.newName = newName;
        }

        @Override
        public void constructImpl() throws FBException {
            this.fileSystemModel.renameFile(this.file, this.newName);
        }

        @Override
        public void finished() {
            this.afterFinished("Renaming failed.");
        }
    }

    private class SwingWorker_Remove
    extends SwingWorker_ForCastor {
        boolean isModelRoot;

        public SwingWorker_Remove(AbstractFileSystemModel mod, FileInterface file2, boolean isModelRoot) {
            super(mod, file2);
            this.isModelRoot = isModelRoot;
        }

        @Override
        public void constructImpl() throws FBException {
            this.fileSystemModel.removeFile(this.file, this.isModelRoot);
        }

        @Override
        public void finished() {
            if (this.ce != null || this.isModelRoot) {
                // empty if block
            }
            this.afterFinished("Deleting failed.");
        }
    }

    private class SwingWorker_Refresh
    extends SwingWorker_ForCastor {
        public SwingWorker_Refresh(AbstractFileSystemModel mod, FileInterface file2) {
            super(mod, file2);
        }

        @Override
        public void constructImpl() throws FBException {
            Consts.debug("7 no i robi sie refresh " + SwingUtilities.isEventDispatchThread());
            this.fileSystemModel.refreshFile(this.file);
            Consts.debug("8 no i refresh sie zrobil");
        }

        @Override
        public void finished() {
            this.afterFinished("Refreshing failed");
        }
    }

    private class SwingWorker_ExpandFromHere
    extends SwingWorker_ForCastor {
        public SwingWorker_ExpandFromHere(AbstractFileSystemModel mod, FileInterface file2) {
            super(mod, file2);
        }

        @Override
        public void constructImpl() throws FBException {
        }

        @Override
        public void finished() {
            this.afterFinished("Loading children failed.");
        }
    }

    private abstract class SwingWorker_ForCastor
    extends Worker {
        protected FileInterface file;
        protected AbstractFileSystemModel fileSystemModel;
        protected FBException ce = null;

        protected SwingWorker_ForCastor(AbstractFileSystemModel fileSystemModel, FileInterface file2) {
            this.file = file2;
            this.fileSystemModel = fileSystemModel;
        }

        @Override
        public Object construct() {
            try {
                this.constructImpl();
            }
            catch (FBException c) {
                this.ce = c;
            }
            return null;
        }

        protected abstract void constructImpl() throws FBException;

        protected void afterFinished(String msg) {
            JTreeTable.this.win.setProject();
            if (this.ce != null) {
                Communicator.showErrorMessage(JTreeTable.this, msg, this.ce);
            }
        }
    }
}

