/*
 * Decompiled with CFR 0.152.
 */
package jehep.fbrowser;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import jehep.fbrowser.AbstractTreeTableModel;
import jehep.fbrowser.MergeSort;
import jehep.fbrowser.TreeTableModel;

public class FileSystemModel2
extends AbstractTreeTableModel {
    protected static String[] cNames = new String[]{"Name", "Size", "Type", "Modified"};
    protected static Class[] cTypes = new Class[]{TreeTableModel.class, Integer.class, String.class, Date.class};
    public static final Integer ZERO = new Integer(0);
    static Stack sorters = new Stack();
    protected boolean isValid = true;
    protected FileNode reloadNode;
    int reloadCount;
    protected boolean descendLinks;
    protected static FileNode[] EMPTY_CHILDREN = new FileNode[0];
    private static MergeSort fileMS = new MergeSort(){

        @Override
        public int compareElementsAt(int beginLoc, int endLoc) {
            return ((String)this.toSort[beginLoc]).compareTo((String)this.toSort[endLoc]);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static MergeSort getSizeSorter() {
        Stack stack = sorters;
        synchronized (stack) {
            if (sorters.size() == 0) {
                return new SizeSorter();
            }
            return (MergeSort)sorters.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void recycleSorter(MergeSort sorter) {
        Stack stack = sorters;
        synchronized (stack) {
            sorters.push(sorter);
        }
    }

    public FileSystemModel2() {
        this(File.separator);
    }

    public FileSystemModel2(String rootPath) {
        super(null);
        this.root = new FileNode(new File(rootPath));
    }

    @Override
    public int getChildCount(Object node) {
        Object[] children = this.getChildren(node);
        return children == null ? 0 : children.length;
    }

    @Override
    public Object getChild(Object node, int i) {
        return this.getChildren(node)[i];
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((FileNode)node).isLeaf();
    }

    @Override
    public int getColumnCount() {
        return cNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return cNames[column];
    }

    @Override
    public Class getColumnClass(int column) {
        return cTypes[column];
    }

    @Override
    public Object getValueAt(Object node, int column) {
        FileNode fn = (FileNode)node;
        try {
            switch (column) {
                case 0: {
                    return fn.getFile().getName();
                }
                case 1: {
                    if (fn.isTotalSizeValid()) {
                        return new Integer((int)((FileNode)node).totalSize());
                    }
                    return null;
                }
                case 2: {
                    return fn.isLeaf() ? "File" : "Directory";
                }
                case 3: {
                    return fn.lastModified();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadChildren(Object node) {
        FileNode fn = (FileNode)node;
        FileSystemModel2 fileSystemModel2 = this;
        synchronized (fileSystemModel2) {
            ++this.reloadCount;
        }
        fn.resetSize();
        new Thread(new FileNodeLoader((FileNode)node)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoading() {
        this.isValid = false;
        FileSystemModel2 fileSystemModel2 = this;
        synchronized (fileSystemModel2) {
            while (this.reloadCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.isValid = true;
    }

    public void setDescendsLinks(boolean newValue) {
        this.descendLinks = newValue;
    }

    public boolean getDescendsLinks() {
        return this.descendLinks;
    }

    public String getPath(Object node) {
        return ((FileNode)node).getFile().getPath();
    }

    public long getTotalSize(Object node) {
        return ((FileNode)node).totalSize();
    }

    public boolean isReloading() {
        return this.reloadCount > 0;
    }

    public TreePath getPathLoading() {
        FileNode rn = this.reloadNode;
        if (rn != null) {
            return new TreePath(rn.getPath());
        }
        return null;
    }

    public Object getNodeLoading() {
        return this.reloadNode;
    }

    protected File getFile(Object node) {
        FileNode fileNode = (FileNode)node;
        return fileNode.getFile();
    }

    protected Object[] getChildren(Object node) {
        FileNode fileNode = (FileNode)node;
        return fileNode.getChildren();
    }

    static class SizeSorter
    extends MergeSort {
        SizeSorter() {
        }

        @Override
        public int compareElementsAt(int beginLoc, int endLoc) {
            long secondSize;
            long firstSize = ((FileNode)this.toSort[beginLoc]).totalSize();
            if (firstSize != (secondSize = ((FileNode)this.toSort[endLoc]).totalSize())) {
                return (int)(secondSize - firstSize);
            }
            return ((FileNode)this.toSort[beginLoc]).toString().compareTo(((FileNode)this.toSort[endLoc]).toString());
        }
    }

    class FileNode {
        protected File file;
        private FileNode parent;
        protected FileNode[] children;
        protected long totalSize;
        protected boolean totalSizeValid;
        protected String canonicalPath;
        protected boolean isLink;
        protected Date lastModified;

        protected FileNode(File file2) {
            this(null, file2);
        }

        protected FileNode(FileNode parent, File file2) {
            this.parent = parent;
            this.file = file2;
            try {
                this.canonicalPath = file2.getCanonicalPath();
            }
            catch (IOException ioe) {
                this.canonicalPath = "";
            }
            this.isLink = parent != null ? !this.canonicalPath.startsWith(parent.getCanonicalPath()) : false;
            if (this.isLeaf()) {
                this.totalSize = file2.length();
                this.totalSizeValid = true;
            }
        }

        public Date lastModified() {
            if (this.lastModified == null && this.file != null) {
                this.lastModified = new Date(this.file.lastModified());
            }
            return this.lastModified;
        }

        public String toString() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        public long totalSize() {
            return this.totalSize;
        }

        public FileNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            return this.file.isFile();
        }

        public boolean isTotalSizeValid() {
            return this.totalSizeValid;
        }

        protected void resetLastModified() {
            this.lastModified = null;
        }

        protected void resetSize() {
            this.alterTotalSize(-this.totalSize);
        }

        protected FileNode[] getChildren() {
            return this.children;
        }

        protected void loadChildren(MergeSort sorter) {
            this.totalSize = this.file.length();
            this.children = this.createChildren(null);
            for (int counter = this.children.length - 1; counter >= 0; --counter) {
                Thread.yield();
                if (!(this.children[counter].isLeaf() || !FileSystemModel2.this.descendLinks && this.children[counter].isLink())) {
                    this.children[counter].loadChildren(sorter);
                }
                this.totalSize += this.children[counter].totalSize();
                if (FileSystemModel2.this.isValid) continue;
                counter = 0;
            }
            if (FileSystemModel2.this.isValid) {
                if (sorter != null) {
                    sorter.sort(this.children);
                }
                this.totalSizeValid = true;
            }
        }

        protected FileNode[] createChildren(MergeSort sorter) {
            FileNode[] retArray = null;
            try {
                Object[] files = this.file.list();
                if (files != null) {
                    if (sorter != null) {
                        sorter.sort(files);
                    }
                    retArray = new FileNode[files.length];
                    String path = this.file.getPath();
                    for (int i = 0; i < files.length; ++i) {
                        File childFile = new File(path, (String)files[i]);
                        retArray[i] = new FileNode(this, childFile);
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (retArray == null) {
                retArray = EMPTY_CHILDREN;
            }
            return retArray;
        }

        protected boolean loadedChildren() {
            return this.file.isFile() || this.children != null;
        }

        public FileNode[] getPath() {
            return this.getPathToRoot(this, 0);
        }

        public String getCanonicalPath() {
            return this.canonicalPath;
        }

        public boolean isLink() {
            return this.isLink;
        }

        protected FileNode[] getPathToRoot(FileNode aNode, int depth) {
            FileNode[] retNodes;
            if (aNode == null) {
                if (depth == 0) {
                    return null;
                }
                retNodes = new FileNode[depth];
            } else {
                retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
                retNodes[retNodes.length - depth] = aNode;
            }
            return retNodes;
        }

        protected void setChildren(FileNode[] newChildren, boolean generateEvent) {
            long oldSize = this.totalSize;
            this.totalSize = this.file.length();
            this.children = newChildren;
            for (int counter = this.children.length - 1; counter >= 0; --counter) {
                this.totalSize += this.children[counter].totalSize();
            }
            if (generateEvent) {
                Object[] path = this.getPath();
                FileSystemModel2.this.fireTreeStructureChanged(FileSystemModel2.this, path, null, null);
                FileNode parent = this.getParent();
                if (parent != null) {
                    parent.alterTotalSize(this.totalSize - oldSize);
                }
            }
        }

        protected synchronized void alterTotalSize(long sizeDelta) {
            if (sizeDelta != 0L && (this.parent = this.getParent()) != null) {
                this.totalSize += sizeDelta;
                this.nodeChanged();
                this.parent.alterTotalSize(sizeDelta);
            } else {
                this.totalSize += sizeDelta;
            }
        }

        protected synchronized void setTotalSizeValid(boolean newValue) {
            if (this.totalSizeValid != newValue) {
                this.nodeChanged();
                this.totalSizeValid = newValue;
                FileNode parent = this.getParent();
                if (parent != null) {
                    parent.childTotalSizeChanged(this);
                }
            }
        }

        protected synchronized void forceTotalSizeValid() {
            this.totalSizeValid = true;
        }

        protected synchronized void childTotalSizeChanged(FileNode child) {
            if (this.totalSizeValid != child.isTotalSizeValid()) {
                if (this.totalSizeValid) {
                    this.setTotalSizeValid(false);
                } else {
                    FileNode[] children = this.getChildren();
                    for (int counter = children.length - 1; counter >= 0; --counter) {
                        if (children[counter].isTotalSizeValid()) continue;
                        return;
                    }
                    this.setTotalSizeValid(true);
                }
            }
        }

        protected void nodeChanged() {
            FileNode parent = this.getParent();
            if (parent != null) {
                Object[] path = parent.getPath();
                int[] index = new int[]{FileSystemModel2.this.getIndexOfChild(parent, this)};
                Object[] children = new Object[]{this};
                FileSystemModel2.this.fireTreeNodesChanged(FileSystemModel2.this, path, index, children);
            }
        }
    }

    class FileNodeLoader
    implements Runnable {
        FileNode node;
        MergeSort sizeMS;

        FileNodeLoader(FileNode node) {
            this.node = node;
            node.resetLastModified();
            node.setChildren(node.createChildren(fileMS), true);
            node.setTotalSizeValid(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileNode[] children = this.node.getChildren();
            this.sizeMS = FileSystemModel2.getSizeSorter();
            for (int counter = children.length - 1; counter >= 0; --counter) {
                if (!children[counter].isLeaf()) {
                    FileSystemModel2.this.reloadNode = children[counter];
                    this.loadChildren(children[counter]);
                    FileSystemModel2.this.reloadNode = null;
                }
                if (FileSystemModel2.this.isValid) continue;
                counter = 0;
            }
            FileSystemModel2.recycleSorter(this.sizeMS);
            if (FileSystemModel2.this.isValid) {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        MergeSort sorter = FileSystemModel2.getSizeSorter();
                        sorter.sort(FileNodeLoader.this.node.getChildren());
                        FileSystemModel2.recycleSorter(sorter);
                        FileNodeLoader.this.node.setChildren(FileNodeLoader.this.node.getChildren(), true);
                        FileSystemModel2 fileSystemModel2 = FileSystemModel2.this;
                        synchronized (fileSystemModel2) {
                            --FileSystemModel2.this.reloadCount;
                            FileSystemModel2.this.notifyAll();
                        }
                    }
                });
            } else {
                FileSystemModel2 fileSystemModel2 = FileSystemModel2.this;
                synchronized (fileSystemModel2) {
                    --FileSystemModel2.this.reloadCount;
                    FileSystemModel2.this.notifyAll();
                }
            }
        }

        protected void loadChildren(FileNode node) {
            if (!(node.isLeaf() || !FileSystemModel2.this.descendLinks && node.isLink())) {
                final FileNode[] children = node.createChildren(null);
                for (int counter = children.length - 1; counter >= 0; --counter) {
                    if (!children[counter].isLeaf()) {
                        if (FileSystemModel2.this.descendLinks || !children[counter].isLink()) {
                            children[counter].loadChildren(this.sizeMS);
                        } else {
                            children[counter].forceTotalSizeValid();
                        }
                    }
                    if (FileSystemModel2.this.isValid) continue;
                    counter = 0;
                }
                if (FileSystemModel2.this.isValid) {
                    final FileNode fn = node;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MergeSort sorter = FileSystemModel2.getSizeSorter();
                            sorter.sort(children);
                            FileSystemModel2.recycleSorter(sorter);
                            fn.setChildren(children, true);
                            fn.setTotalSizeValid(true);
                            fn.nodeChanged();
                        }
                    });
                }
            } else {
                node.forceTotalSizeValid();
            }
        }
    }
}

