/*
 * Decompiled with CFR 0.152.
 */
package jehep.fbrowser;

import jehep.fbrowser.AbstractTreeTableModel;
import jehep.fbrowser.FBException;
import jehep.fbrowser.FileInterface;
import jehep.fbrowser.TreeTableModel;

public abstract class AbstractFileSystemModel
extends AbstractTreeTableModel
implements TreeTableModel {
    protected static final String[] commonColumns = new String[]{"Name", "Last modified", "Length"};
    protected static final Class[] commonColumnsTypes = new Class[]{TreeTableModel.class, String.class, Long.class};

    public AbstractFileSystemModel(FileInterface root) throws FBException {
        super(root);
    }

    protected abstract String[] specyficColumns();

    @Override
    public int getColumnCount() {
        return commonColumns.length + this.specyficColumns().length;
    }

    @Override
    public String getColumnName(int column) {
        int n = commonColumns.length;
        if (column < n) {
            return commonColumns[column];
        }
        return this.specyficColumns()[column - n];
    }

    protected abstract Class getSpecyficColumnClass(int var1);

    @Override
    public Class getColumnClass(int column) {
        int n = commonColumnsTypes.length;
        if (column < n) {
            return commonColumnsTypes[column];
        }
        return this.getSpecyficColumnClass(column - n);
    }

    protected abstract Object getValueAt(FileInterface var1, int var2);

    @Override
    public Object getValueAt(Object node, int column) {
        int n = commonColumns.length;
        FileInterface file2 = (FileInterface)node;
        if (file2 == null) {
            return null;
        }
        if (column < n) {
            switch (column) {
                case 0: {
                    return file2.getName();
                }
                case 1: {
                    return file2.getLastMod();
                }
                case 2: {
                    return new Long(file2.getLength());
                }
            }
            return null;
        }
        return this.getValueAt(file2, column - n);
    }

    @Override
    public Object getChild(Object parent, int index) {
        FileInterface fileParent = (FileInterface)parent;
        if (fileParent == null) {
            return null;
        }
        FileInterface[] ch = fileParent.getChildren();
        return ch[index];
    }

    @Override
    public int getChildCount(Object parent) {
        FileInterface fileParent = (FileInterface)parent;
        try {
            fileParent.assureChildrenLoaded();
        }
        catch (FBException ce) {
            fileParent.loadingChildrenFailed();
            return 0;
        }
        FileInterface[] children = fileParent.getChildren();
        return children == null ? 0 : children.length;
    }

    public void renameFile(FileInterface file2, String newName) throws FBException {
        FBException ce = null;
        try {
            file2.renameInPlace(newName);
        }
        catch (FBException e) {
            ce = e;
        }
        Object[] newpath = file2.getPathForEvents(false);
        this.fireTreeStructureChanged(this, newpath, null, null);
        this.fireTreeNodesChanged(this, newpath, null, null);
        if (ce != null) {
            throw ce;
        }
    }

    public void removeFile(FileInterface file2, boolean isModelRoot) throws FBException {
        FBException ce = null;
        try {
            file2.remove();
        }
        catch (FBException e) {
            ce = e;
        }
        if (!isModelRoot) {
            Object[] path = file2.getPathForEvents(false);
            this.fireTreeStructureChanged(this, path, null, null);
        }
        if (ce != null) {
            throw ce;
        }
    }

    public void refreshFile(FileInterface file2) throws FBException {
        FBException ce = null;
        try {
            file2.refresh();
        }
        catch (FBException e) {
            ce = e;
        }
        Object[] path = file2.getPathForEvents(true);
        this.fireTreeStructureChanged(this, path, null, null);
        if (file2.getParent() == null) {
            this.fireTreeNodesChanged(this, path, null, null);
        } else {
            path = file2.getPathForEvents(false);
            this.fireTreeNodesChanged(this, path, new int[]{file2.getParent().getChildNr(file2)}, new Object[]{file2});
        }
        if (ce != null) {
            throw ce;
        }
    }

    public void newFolder(FileInterface file2, String folderName) throws FBException {
        FBException ce = null;
        try {
            file2.mkdir(folderName);
        }
        catch (FBException e) {
            ce = e;
        }
        Object[] path = file2.getPathForEvents(true);
        this.fireTreeStructureChanged(this, path, null, null);
        if (ce != null) {
            throw ce;
        }
    }
}

