/*
 * Decompiled with CFR 0.152.
 */
package jehep.completion;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jehep.ui.Editor;
import jehep.ui.SetEnv;
import org.dts.spell.SpellChecker;
import org.dts.spell.dictionary.SpellDictionaryException;
import org.dts.spell.swing.utils.ErrorMsgBox;

public class CompPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel wrongWordLabel;
    private JTextField checkText;
    private JList suggestList;
    private DefaultListModel suggestionListModel;
    private JButton replaceButton;
    private String wrongWord;
    protected final ListListener listListener = new ListListener();
    private ActionListener cancelListener;
    private ActionListener closeListener;

    public CompPanel() {
        this.suggestionListModel = new DefaultListModel();
        this.createPanels();
        this.initFocus();
    }

    public void setWrongWord(String txt) {
        this.wrongWord = txt;
        this.checkText.setText(this.wrongWord);
        List<String> suggest = SetEnv.dict.getSuggestions(txt);
        this.setSuggestionWords(suggest);
    }

    public void cancel() {
        this.fireCancelAction();
    }

    public void setCancelListener(ActionListener listener) {
        this.cancelListener = listener;
    }

    public void setCloseListener(ActionListener listener) {
        this.closeListener = listener;
    }

    protected void fireCancelAction() {
        if (null != this.cancelListener) {
            this.cancelListener.actionPerformed(new ActionEvent(this, 1001, "cancel"));
        }
    }

    protected void fireCloseAction() {
        if (null != this.closeListener) {
            this.closeListener.actionPerformed(new ActionEvent(this, 1001, "close"));
        }
    }

    public void setSuggestionWords(List<String> list) {
        if (list.isEmpty()) {
            this.clearSuggestionWords();
        } else {
            Iterator<String> it = list.iterator();
            this.suggestionListModel.clear();
            while (it.hasNext()) {
                String word = it.next();
                this.suggestionListModel.addElement(word);
            }
        }
    }

    protected void clearSuggestionWords() {
        this.suggestionListModel.clear();
        this.suggestionListModel.addElement("no suggestions");
    }

    protected void createPanels() {
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.createCenterPanel(), "Center");
        this.add((Component)this.createSouthPanel(), "South");
        this.clearSuggestionWords();
    }

    public String getNewWord() {
        return this.checkText.getText().trim();
    }

    public void ignoreAll() {
        SpellChecker checker = SetEnv.checker;
        checker.addIgnore(this.wrongWord);
        Editor.AcceptedWords().add(this.wrongWord.toLowerCase());
        this.fireCloseAction();
    }

    public void addCurrent() {
        try {
            SetEnv.dict.addWord(this.wrongWord);
            Editor.AcceptedWords().add(this.wrongWord);
            Editor.RefreshDoc();
            this.fireCloseAction();
        }
        catch (SpellDictionaryException e) {
            ErrorMsgBox.show((Component)this, e);
            e.printStackTrace();
        }
    }

    public void replaceCurrent() {
        Editor.replaceSelection(this.getNewWord());
        Editor.RefreshDoc();
        this.fireCloseAction();
    }

    public void replaceAll() {
        Editor.replaceAllWords(this.wrongWord, this.getNewWord());
        Editor.RefreshDoc();
        this.fireCloseAction();
    }

    protected JPanel createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.checkText = this.createCheckTextField();
        this.checkText.setBorder(new TitledBorder(null, "Wrong word", 0, 0, new Font("Dialog", 0, 12)));
        panel.add((Component)this.checkText, "North");
        panel.add((Component)this.createSuggestionPanel(), "Center");
        panel.add((Component)this.createReplaceTextButtonsPanel(), "South");
        return panel;
    }

    protected JTextField createCheckTextField() {
        JTextField result = new JTextField();
        return result;
    }

    protected JPanel createReplaceTextButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout(1));
        this.replaceButton = this.createButton("replace", EventHandler.create(ActionListener.class, this, "replaceCurrent"));
        this.replaceButton.setPreferredSize(new Dimension(120, 30));
        panel.add(this.replaceButton);
        JButton replaceAllButton = this.createButton("replace all", EventHandler.create(ActionListener.class, this, "replaceAll"));
        replaceAllButton.setPreferredSize(new Dimension(120, 30));
        panel.add(replaceAllButton);
        return panel;
    }

    protected JLabel createSuggestionLabel() {
        return new JLabel("suggestion");
    }

    protected JList createSuggestionList() {
        JList result = new JList();
        result.setSelectionMode(0);
        result.addListSelectionListener(this.listListener);
        result.addMouseListener(this.listListener);
        result.addFocusListener(this.listListener);
        result.setModel(this.suggestionListModel);
        return result;
    }

    protected JPanel createSuggestionPanel() {
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        JLabel label = this.createSuggestionLabel();
        this.suggestList = this.createSuggestionList();
        label.setLabelFor(this.suggestList);
        panel.add((Component)label, "North");
        panel.add((Component)new JScrollPane(this.suggestList), "Center");
        return panel;
    }

    private JPanel createSouthPanel() {
        JPanel panel = new JPanel(new FlowLayout(1));
        JButton ignoreB = this.createButton("ignore all", EventHandler.create(ActionListener.class, this, "ignoreAll"));
        ignoreB.setPreferredSize(new Dimension(120, 30));
        panel.add(ignoreB);
        JButton addDicB = this.createButton("add to " + SetEnv.SelectedDicName, EventHandler.create(ActionListener.class, this, "addCurrent"));
        addDicB.setPreferredSize(new Dimension(120, 30));
        panel.add(addDicB);
        return panel;
    }

    protected JButton createButton(Action action) {
        return new JButton(action);
    }

    protected JButton createButton(String id, final ActionListener action) {
        AbstractAction tempAction = new AbstractAction(id){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                action.actionPerformed(e);
            }
        };
        return this.createButton(tempAction);
    }

    protected JPanel createNorthPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        this.wrongWordLabel = this.createWrongWordLabel();
        panel.add(this.wrongWordLabel);
        return panel;
    }

    protected JLabel createWrongWordLabel() {
        JLabel result = new JLabel("");
        return result;
    }

    protected MessageFormat createWrongWordMessageFormat() {
        return new MessageFormat("wrong");
    }

    public void initFocus() {
        boolean empty = this.isEmpty(this.suggestList);
        this.suggestList.ensureIndexIsVisible(0);
        this.checkText.requestFocusInWindow();
        this.suggestList.setFocusable(!empty);
    }

    protected boolean isEmpty(JList list) {
        return list.getFirstVisibleIndex() < 0 || list.getModel().getElementAt(0) == "no suggestions";
    }

    protected class ListListener
    extends MouseAdapter
    implements ListSelectionListener,
    FocusListener {
        protected ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object selectedValue;
            JList list;
            if (!e.getValueIsAdjusting() && !CompPanel.this.isEmpty(list = (JList)e.getSource()) && (selectedValue = list.getSelectedValue()) != null) {
                CompPanel.this.checkText.setText(selectedValue.toString());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() != 2 || !CompPanel.this.isEmpty(CompPanel.this.suggestList)) {
                // empty if block
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!e.isTemporary() && CompPanel.this.suggestList.getSelectedIndex() < 0) {
                CompPanel.this.suggestList.setSelectedIndex(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

