/*
 * Decompiled with CFR 0.152.
 */
package jabref.undo;

import jabref.BasePanel;
import jabref.BibtexDatabase;
import jabref.BibtexString;
import jabref.Globals;
import jabref.KeyCollisionException;
import javax.swing.undo.AbstractUndoableEdit;

public class UndoableRemoveString
extends AbstractUndoableEdit {
    private BibtexDatabase base;
    private BibtexString string;
    private int pos;
    private BasePanel panel;

    public UndoableRemoveString(BasePanel panel, BibtexDatabase base, BibtexString string, int pos) {
        this.base = base;
        this.string = string;
        this.pos = pos;
        this.panel = panel;
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("remove string ");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("remove string ");
    }

    @Override
    public void undo() {
        super.undo();
        try {
            this.base.addString(this.string, this.pos);
        }
        catch (KeyCollisionException ex) {
            ex.printStackTrace();
        }
        this.panel.updateStringDialog();
    }

    @Override
    public void redo() {
        super.redo();
        this.base.removeString(this.pos);
        this.panel.updateStringDialog();
    }
}

