/*
 * Decompiled with CFR 0.152.
 */
package jabref.undo;

import jabref.BasePanel;
import jabref.BibtexDatabase;
import jabref.BibtexString;
import jabref.KeyCollisionException;
import javax.swing.undo.AbstractUndoableEdit;

public class UndoableMoveString
extends AbstractUndoableEdit {
    private BasePanel panel;
    private BibtexDatabase base;
    private boolean up;
    private int pos;

    public UndoableMoveString(BasePanel panel, BibtexDatabase base, int pos, boolean up) {
        this.panel = panel;
        this.base = base;
        this.pos = pos;
        this.up = up;
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo: move string " + (this.up ? "up" : "down");
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo: move string " + (this.up ? "up" : "down");
    }

    @Override
    public void undo() {
        super.undo();
        this.panel.assureStringDialogNotEditing();
        this.moveString(!this.up, this.up ? this.pos - 1 : this.pos + 1);
        this.panel.updateStringDialog();
    }

    @Override
    public void redo() {
        super.redo();
        this.panel.assureStringDialogNotEditing();
        this.moveString(this.up, this.pos);
        this.panel.updateStringDialog();
    }

    private void moveString(boolean up, int pos) {
        BibtexString bs = this.base.getString(pos);
        this.base.removeString(pos);
        try {
            this.base.addString(bs, up ? pos - 1 : pos + 1);
        }
        catch (KeyCollisionException keyCollisionException) {
            // empty catch block
        }
    }
}

