/*
 * Decompiled with CFR 0.152.
 */
package jabref.undo;

import jabref.BibtexEntry;
import jabref.Util;
import javax.swing.undo.AbstractUndoableEdit;

public class UndoableFieldChange
extends AbstractUndoableEdit {
    private BibtexEntry entry;
    private String field;
    private Object oldValue;
    private Object newValue;

    public UndoableFieldChange(BibtexEntry entry, String field, Object oldValue, Object newValue) {
        this.entry = entry;
        this.field = field;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo: change field";
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo: change field";
    }

    @Override
    public void undo() {
        super.undo();
        try {
            this.entry.setField(this.field, this.oldValue);
        }
        catch (Throwable ex) {
            Util.pr(ex.getMessage());
        }
    }

    @Override
    public void redo() {
        super.redo();
        try {
            this.entry.setField(this.field, this.newValue);
        }
        catch (Throwable ex) {
            Util.pr(ex.getMessage());
        }
    }
}

