/*
 * Decompiled with CFR 0.152.
 */
package jabref.label;

import jabref.BibtexEntry;
import jabref.label.DefaultLabelRule;
import jabref.label.KeyWord;
import java.util.StringTokenizer;

public class InproceedingsLabelRule
extends DefaultLabelRule {
    @Override
    public String applyRule(BibtexEntry oldEntry) {
        String oldLabel = (String)oldEntry.getField("bibtexkey");
        String newLabel = "";
        StringTokenizer authorTokens = null;
        try {
            authorTokens = new StringTokenizer((String)oldEntry.getField("author"), ",");
            newLabel = newLabel + authorTokens.nextToken().toLowerCase().replaceAll(" ", "").replaceAll("\\.", "");
        }
        catch (Throwable t) {
            System.out.println("error getting author: " + t);
        }
        try {
            if (oldEntry.getField("year") != null) {
                newLabel = newLabel + String.valueOf(oldEntry.getField("year"));
            }
        }
        catch (Throwable t) {
            System.out.println("error getting year: " + t);
        }
        try {
            if (oldEntry.getField("booktitle") != null) {
                authorTokens = new StringTokenizer(((String)oldEntry.getField("booktitle")).replaceAll(",", " ").replaceAll("/", " "));
                String tempString = authorTokens.nextToken();
                tempString = tempString.replaceAll(",", "");
                boolean done = false;
                while (tempString != null && !done) {
                    if ((tempString = tempString.replaceAll(",", "").trim()).trim().length() > 3 && !KeyWord.isKeyWord(tempString)) {
                        done = true;
                        continue;
                    }
                    if (authorTokens.hasMoreTokens()) {
                        tempString = authorTokens.nextToken();
                        continue;
                    }
                    done = true;
                }
                if (tempString != null && tempString.indexOf("null") < 0) {
                    newLabel = newLabel + String.valueOf(tempString.toLowerCase());
                }
            }
        }
        catch (Throwable t) {
            System.err.println(t);
        }
        return newLabel;
    }
}

